/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.dom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.ui.css.core.dom.CSSExtendedProperties;
import org.eclipse.e4.ui.css.core.dom.CSSStylableElement;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.impl.dom.CSSExtendedPropertiesImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;
import org.w3c.dom.css.CSSStyleDeclaration;

public abstract class ElementAdapter
implements Element,
CSSStylableElement {
    private static final String[] EMPTY_STRING = new String[0];
    private Object nativeWidget;
    protected CSSEngine engine;
    private Map defaultStyleDeclarationMap = new HashMap();
    private CSSExtendedProperties style = null;
    private List staticPseudoInstances;

    public ElementAdapter(Object object, CSSEngine cSSEngine) {
        this.nativeWidget = object;
        this.engine = cSSEngine;
    }

    public void addStaticPseudoInstance(String string) {
        if (this.staticPseudoInstances == null) {
            this.staticPseudoInstances = new ArrayList();
        }
        this.staticPseudoInstances.add(string);
    }

    public boolean isStaticPseudoInstance(String string) {
        if (this.staticPseudoInstances == null) {
            return false;
        }
        return this.staticPseudoInstances.contains(string);
    }

    public void copyDefaultStyleDeclarations(CSSStylableElement cSSStylableElement) {
        this.setDefaultStyleDeclaration(null, cSSStylableElement.getDefaultStyleDeclaration(null));
        String[] stringArray = cSSStylableElement.getStaticPseudoInstances();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                CSSStyleDeclaration cSSStyleDeclaration = cSSStylableElement.getDefaultStyleDeclaration(string);
                this.setDefaultStyleDeclaration(string, cSSStyleDeclaration);
                ++n;
            }
        }
    }

    public abstract String getLocalName();

    public abstract String getAttribute(String var1);

    public String getAttributeNS(String string, String string2) throws DOMException {
        return this.getAttribute(string2);
    }

    public Attr getAttributeNode(String string) {
        return null;
    }

    public Attr getAttributeNodeNS(String string, String string2) throws DOMException {
        return null;
    }

    public NodeList getElementsByTagName(String string) {
        return null;
    }

    public NodeList getElementsByTagNameNS(String string, String string2) throws DOMException {
        return null;
    }

    public boolean hasAttribute(String string) {
        return false;
    }

    public boolean hasAttributeNS(String string, String string2) throws DOMException {
        return this.hasAttribute(string2);
    }

    public void removeAttribute(String string) throws DOMException {
    }

    public void removeAttributeNS(String string, String string2) throws DOMException {
    }

    public Attr removeAttributeNode(Attr attr) throws DOMException {
        return null;
    }

    public void setAttribute(String string, String string2) throws DOMException {
    }

    public void setAttributeNS(String string, String string2, String string3) throws DOMException {
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        return null;
    }

    public Attr setAttributeNodeNS(Attr attr) throws DOMException {
        return null;
    }

    public Node appendChild(Node node) throws DOMException {
        return this.insertBefore(node, null);
    }

    public Node cloneNode(boolean bl) {
        return null;
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public Node getFirstChild() {
        return null;
    }

    public Node getLastChild() {
        return null;
    }

    public String getTagName() {
        return this.getLocalName();
    }

    public Node getNextSibling() {
        return null;
    }

    public String getNodeName() {
        return this.getLocalName();
    }

    public short getNodeType() {
        return 1;
    }

    public String getNodeValue() throws DOMException {
        return null;
    }

    public Document getOwnerDocument() {
        return null;
    }

    public String getPrefix() {
        return null;
    }

    public Node getPreviousSibling() {
        return null;
    }

    public boolean hasAttributes() {
        return false;
    }

    public boolean hasChildNodes() {
        return false;
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        return null;
    }

    public boolean isSupported(String string, String string2) {
        return false;
    }

    public void normalize() {
    }

    public Node removeChild(Node node) throws DOMException {
        return null;
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        return null;
    }

    public void setNodeValue(String string) throws DOMException {
    }

    public void setPrefix(String string) throws DOMException {
    }

    public void setIdAttribute(String string, boolean bl) throws DOMException {
    }

    public void setIdAttributeNS(String string, String string2, boolean bl) throws DOMException {
    }

    public void setIdAttributeNode(Attr attr, boolean bl) throws DOMException {
    }

    public short compareDocumentPosition(Node node) throws DOMException {
        return 0;
    }

    public String getBaseURI() {
        return null;
    }

    public Object getFeature(String string, String string2) {
        return null;
    }

    public String getTextContent() throws DOMException {
        return null;
    }

    public Object getUserData(String string) {
        return null;
    }

    public boolean isDefaultNamespace(String string) {
        return false;
    }

    public boolean isEqualNode(Node node) {
        return false;
    }

    public boolean isSameNode(Node node) {
        return false;
    }

    public String lookupNamespaceURI(String string) {
        return null;
    }

    public String lookupPrefix(String string) {
        return null;
    }

    public void setTextContent(String string) throws DOMException {
    }

    public Object getNativeWidget() {
        return this.nativeWidget;
    }

    public Object setUserData(String string, Object object, UserDataHandler userDataHandler) {
        return null;
    }

    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    public CSSStyleDeclaration getDefaultStyleDeclaration(String string) {
        return (CSSStyleDeclaration)this.defaultStyleDeclarationMap.get(string);
    }

    public void setDefaultStyleDeclaration(String string, CSSStyleDeclaration cSSStyleDeclaration) {
        this.defaultStyleDeclarationMap.put(string, cSSStyleDeclaration);
    }

    public void onStylesApplied(NodeList nodeList) {
    }

    protected Element getElement(Object object) {
        return this.engine.getElement(object);
    }

    public CSSExtendedProperties getStyle() {
        if (this.style == null) {
            this.style = new CSSExtendedPropertiesImpl(this.nativeWidget, this.engine);
        }
        return this.style;
    }

    public String[] getStaticPseudoInstances() {
        if (this.staticPseudoInstances == null) {
            return EMPTY_STRING;
        }
        return this.staticPseudoInstances.toArray(EMPTY_STRING);
    }

    public boolean isPseudoInstanceOf(String string) {
        if (this.staticPseudoInstances == null) {
            return false;
        }
        return this.staticPseudoInstances.contains(string);
    }
}

