/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.dom.properties.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.e4.ui.css.core.dom.CSSStylableElement;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler;
import org.eclipse.e4.ui.css.core.dom.properties.providers.AbstractCSSPropertyHandlerProvider;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.exceptions.UnsupportedClassCSSPropertyException;
import org.eclipse.e4.ui.css.core.utils.StringUtils;
import org.w3c.dom.css.CSSStyleDeclaration;

public class CSSPropertyHandlerLazyProviderImpl
extends AbstractCSSPropertyHandlerProvider {
    private static Log logger = LogFactory.getLog(CSSPropertyHandlerLazyProviderImpl.class);
    private List packageNames = new ArrayList();
    private Map propertyToHandlersMap = new HashMap();

    public Collection getCSSPropertyHandlers(String string) throws Exception {
        Map map = this.getPropertyToHandlersMap();
        Object v = map.get(string);
        if (v != null) {
            if (v instanceof List) {
                return (List)v;
            }
            return null;
        }
        ArrayList<ICSSPropertyHandler> arrayList = null;
        try {
            String string2 = this.getHandlerClassName(string);
            for (String string3 : this.packageNames) {
                ICSSPropertyHandler iCSSPropertyHandler = this.getCSSPropertyHandler(string3, string2);
                if (iCSSPropertyHandler == null) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Handle CSS Property=" + string + ", with class=" + string3 + "." + string2));
                }
                if (arrayList == null) {
                    arrayList = new ArrayList<ICSSPropertyHandler>();
                }
                arrayList.add(iCSSPropertyHandler);
            }
            if (logger.isDebugEnabled() && arrayList == null) {
                logger.debug((Object)("Cannot find Handle Class CSS Property=" + string + ", for class=" + string2));
            }
        }
        finally {
            if (arrayList != null) {
                map.put(string, arrayList);
            } else {
                map.put(string, "__HANDLER_NOT_FOUND__");
            }
        }
        return arrayList;
    }

    public void registerPackage(String string) {
        this.packageNames.add(string);
        this.propertyToHandlersMap = null;
    }

    protected Map getPropertyToHandlersMap() {
        if (this.propertyToHandlersMap == null) {
            this.propertyToHandlersMap = new HashMap();
        }
        return this.propertyToHandlersMap;
    }

    protected ICSSPropertyHandler getCSSPropertyHandler(String string, String string2) throws Exception {
        String string3 = String.valueOf(string) + "." + string2;
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(string3);
            Object obj = clazz.newInstance();
            if (!(obj instanceof ICSSPropertyHandler)) {
                throw new UnsupportedClassCSSPropertyException(clazz);
            }
            return (ICSSPropertyHandler)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    protected String getHandlerClassName(String string) {
        String string2 = "CSSProperty";
        String[] stringArray = StringUtils.split(string, "-");
        int n = 0;
        while (n < stringArray.length) {
            String string3 = stringArray[n];
            string3 = String.valueOf(string3.substring(0, 1).toUpperCase()) + string3.substring(1, string3.length());
            string2 = String.valueOf(string2) + string3;
            ++n;
        }
        string2 = String.valueOf(string2) + "Handler";
        return string2;
    }

    protected CSSStyleDeclaration getDefaultCSSStyleDeclaration(CSSEngine cSSEngine, CSSStylableElement cSSStylableElement, CSSStyleDeclaration cSSStyleDeclaration, String string) throws Exception {
        if (cSSStylableElement.getDefaultStyleDeclaration(string) != null) {
            return cSSStylableElement.getDefaultStyleDeclaration(string);
        }
        if (cSSStyleDeclaration != null) {
            StringBuffer stringBuffer = null;
            int n = cSSStyleDeclaration.getLength();
            int n2 = 0;
            while (n2 < n) {
                String string2 = cSSStyleDeclaration.item(n2);
                String[] stringArray = cSSEngine.getCSSCompositePropertiesNames(string2);
                if (stringArray != null) {
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        string2 = stringArray[n3];
                        String string3 = this.getCSSPropertyStyle(cSSEngine, cSSStylableElement, string2, string);
                        if (string3 != null) {
                            if (stringBuffer == null) {
                                stringBuffer = new StringBuffer();
                            }
                            stringBuffer.append(string3);
                        }
                        ++n3;
                    }
                } else {
                    String string4 = this.getCSSPropertyStyle(cSSEngine, cSSStylableElement, string2, string);
                    if (string4 != null) {
                        if (stringBuffer == null) {
                            stringBuffer = new StringBuffer();
                        }
                        stringBuffer.append(string4);
                    }
                }
                ++n2;
            }
            if (stringBuffer != null) {
                CSSStyleDeclaration cSSStyleDeclaration2 = cSSEngine.parseStyleDeclaration(stringBuffer.toString());
                cSSStylableElement.setDefaultStyleDeclaration(string, cSSStyleDeclaration2);
                return cSSStyleDeclaration2;
            }
        }
        return cSSStylableElement.getDefaultStyleDeclaration(string);
    }
}

