/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.dom.properties.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.ui.css.core.dom.CSSStylableElement;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler;
import org.eclipse.e4.ui.css.core.dom.properties.css2.ICSSPropertyBackgroundHandler;
import org.eclipse.e4.ui.css.core.dom.properties.css2.ICSSPropertyBorderHandler;
import org.eclipse.e4.ui.css.core.dom.properties.css2.ICSSPropertyClassificationHandler;
import org.eclipse.e4.ui.css.core.dom.properties.css2.ICSSPropertyDimensionHandler;
import org.eclipse.e4.ui.css.core.dom.properties.css2.ICSSPropertyFontHandler;
import org.eclipse.e4.ui.css.core.dom.properties.css2.ICSSPropertyTextHandler;
import org.eclipse.e4.ui.css.core.dom.properties.providers.AbstractCSSPropertyHandlerProvider;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.w3c.dom.css.CSSStyleDeclaration;

public class CSSPropertyHandlerSimpleProviderImpl
extends AbstractCSSPropertyHandlerProvider {
    private static Map defaultCSSProperties = new HashMap();
    private Map propertiesHandler = new HashMap();
    private Map customCSSProperties = new HashMap();
    private boolean isCSSPropertiesInitialized;

    static {
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("background", ICSSPropertyBackgroundHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("background-attachment", ICSSPropertyBackgroundHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("background-color", ICSSPropertyBackgroundHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("background-image", ICSSPropertyBackgroundHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("background-position", ICSSPropertyBackgroundHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("background-repeat", ICSSPropertyBackgroundHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("border", ICSSPropertyBorderHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("border-bottom", ICSSPropertyBorderHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("border-bottom-color", ICSSPropertyBorderHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("border-bottom-style", ICSSPropertyBorderHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("border-bottom-width", ICSSPropertyBorderHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("border-color", ICSSPropertyBorderHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("border-left", ICSSPropertyBorderHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("border-left-color", ICSSPropertyBorderHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("border-left-style", ICSSPropertyBorderHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("border-left-width", ICSSPropertyBorderHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("border-right", ICSSPropertyBorderHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("border-right-color", ICSSPropertyBorderHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("border-right-style", ICSSPropertyBorderHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("border-right-width", ICSSPropertyBorderHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("border-style", ICSSPropertyBorderHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("border-top", ICSSPropertyBorderHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("border-top-color", ICSSPropertyBorderHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("border-top-style", ICSSPropertyBorderHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("border-top-width", ICSSPropertyBorderHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("border-width", ICSSPropertyBorderHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("clear", ICSSPropertyClassificationHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("cursor", ICSSPropertyClassificationHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("display", ICSSPropertyClassificationHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("float", ICSSPropertyClassificationHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("position", ICSSPropertyClassificationHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("visibility", ICSSPropertyClassificationHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("height", ICSSPropertyDimensionHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("line-height", ICSSPropertyDimensionHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("max-height", ICSSPropertyDimensionHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("max-width", ICSSPropertyDimensionHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("min-height", ICSSPropertyDimensionHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("min-width", ICSSPropertyDimensionHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("width", ICSSPropertyDimensionHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("font", ICSSPropertyFontHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("font-family", ICSSPropertyFontHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("font-size", ICSSPropertyFontHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("font-size-adjust", ICSSPropertyFontHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("font-stretch", ICSSPropertyFontHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("font-style", ICSSPropertyFontHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("font-variant", ICSSPropertyFontHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("font-weight", ICSSPropertyFontHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("color", ICSSPropertyTextHandler.class);
        CSSPropertyHandlerSimpleProviderImpl.registerDefaultCSSProperty("text-transform", ICSSPropertyTextHandler.class);
    }

    public Collection getCSSPropertyHandlers(String string) throws Exception {
        Class clazz = this.getCSSPropertyHandlerClass(string);
        return (Collection)this.propertiesHandler.get(clazz);
    }

    public void registerCSSPropertyHandler(Class clazz, ICSSPropertyHandler iCSSPropertyHandler) {
        Object v = this.propertiesHandler.get(clazz);
        if (v != null) {
            if (v instanceof List) {
                List list = (List)v;
                list.add(iCSSPropertyHandler);
            }
        } else {
            ArrayList<ICSSPropertyHandler> arrayList = new ArrayList<ICSSPropertyHandler>();
            arrayList.add(iCSSPropertyHandler);
            this.propertiesHandler.put(clazz, arrayList);
        }
    }

    protected Class getCSSPropertyHandlerClass(String string) {
        this.initializeCSSPropertiesIfNeed();
        return (Class)this.customCSSProperties.get(string);
    }

    public void registerCSSProperty(String string, Class clazz) {
        this.customCSSProperties.put(string, clazz);
    }

    public static void registerDefaultCSSProperty(String string, Class clazz) {
        defaultCSSProperties.put(string, clazz);
    }

    private void initializeCSSPropertiesIfNeed() {
        if (this.isCSSPropertiesInitialized) {
            return;
        }
        this.customCSSProperties.putAll(defaultCSSProperties);
        this.isCSSPropertiesInitialized = true;
    }

    public Collection getAllCSSPropertyNames() {
        this.initializeCSSPropertiesIfNeed();
        return this.customCSSProperties.keySet();
    }

    public CSSStyleDeclaration getDefaultCSSStyleDeclaration(CSSEngine cSSEngine, CSSStylableElement cSSStylableElement, CSSStyleDeclaration cSSStyleDeclaration, String string) throws Exception {
        CSSStyleDeclaration cSSStyleDeclaration2 = cSSStylableElement.getDefaultStyleDeclaration(string);
        if (cSSStyleDeclaration2 != null) {
            return cSSStyleDeclaration2;
        }
        StringBuffer stringBuffer = null;
        Collection collection = this.getAllCSSPropertyNames();
        for (String string2 : collection) {
            String string3 = this.getCSSPropertyStyle(cSSEngine, cSSStylableElement, string2, string);
            if (string3 == null) continue;
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            }
            stringBuffer.append(string3);
        }
        if (stringBuffer != null) {
            cSSStyleDeclaration2 = cSSEngine.parseStyleDeclaration(stringBuffer.toString());
            cSSStylableElement.setDefaultStyleDeclaration(string, cSSStyleDeclaration2);
            return cSSStyleDeclaration2;
        }
        return null;
    }
}

