/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.impl.dom;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.ui.css.core.dom.CSSProperty;
import org.eclipse.e4.ui.css.core.dom.CSSPropertyList;
import org.eclipse.e4.ui.css.core.exceptions.DOMExceptionImpl;
import org.eclipse.e4.ui.css.core.impl.dom.AbstractCSSNode;
import org.eclipse.e4.ui.css.core.impl.dom.CSSPropertyImpl;
import org.eclipse.e4.ui.css.core.impl.dom.CSSPropertyListImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public class CSSStyleDeclarationImpl
extends AbstractCSSNode
implements CSSStyleDeclaration,
Serializable {
    private boolean readOnly;
    private CSSRule parentRule;
    private List<CSSProperty> properties = new ArrayList<CSSProperty>();

    public CSSStyleDeclarationImpl(CSSRule cSSRule) {
        this.parentRule = cSSRule;
    }

    public String getCssText() {
        throw new UnsupportedOperationException("NOT YET IMPLEMENTED");
    }

    public int getLength() {
        return this.properties.size();
    }

    public CSSRule getParentRule() {
        return this.parentRule;
    }

    public CSSValue getPropertyCSSValue(String string) {
        CSSProperty cSSProperty = this.findCSSProperty(string);
        return cSSProperty == null ? null : cSSProperty.getValue();
    }

    public String getPropertyPriority(String string) {
        CSSProperty cSSProperty = this.findCSSProperty(string);
        return cSSProperty != null && cSSProperty.isImportant() ? CSSPropertyImpl.IMPORTANT_IDENTIFIER : "";
    }

    public String getPropertyValue(String string) {
        CSSProperty cSSProperty = this.findCSSProperty(string);
        return cSSProperty == null ? "" : cSSProperty.getValue().toString();
    }

    public String item(int n) {
        return this.properties.get(n).getName();
    }

    public String removeProperty(String string) throws DOMException {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, 20);
        }
        int n = 0;
        while (n < this.properties.size()) {
            CSSProperty cSSProperty = this.properties.get(n);
            if (CSSPropertyImpl.sameName(cSSProperty, string)) {
                this.properties.remove(n);
                return cSSProperty.getValue().toString();
            }
            ++n;
        }
        return "";
    }

    public void setCssText(String string) throws DOMException {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, 20);
        }
        throw new UnsupportedOperationException("NOT YET IMPLEMENTED");
    }

    public void setProperty(String string, String string2, String string3) throws DOMException {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, 20);
        }
        throw new UnsupportedOperationException("NOT YET IMPLEMENTED");
    }

    public void addProperty(CSSProperty cSSProperty) {
        this.properties.add(cSSProperty);
    }

    public CSSPropertyList getCSSPropertyList() {
        CSSPropertyListImpl cSSPropertyListImpl = new CSSPropertyListImpl();
        for (CSSProperty cSSProperty : this.properties) {
            cSSPropertyListImpl.add(cSSProperty);
        }
        return cSSPropertyListImpl;
    }

    protected void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    private CSSProperty findCSSProperty(String string) {
        for (CSSProperty cSSProperty : this.properties) {
            if (!CSSPropertyImpl.sameName(cSSProperty, string)) continue;
            return cSSProperty;
        }
        return null;
    }
}

