/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.impl.dom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.ui.css.core.dom.ExtendedCSSRule;
import org.eclipse.e4.ui.css.core.dom.ExtendedDocumentCSS;
import org.eclipse.e4.ui.css.core.impl.dom.StyleSheetListImpl;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.StyleSheet;
import org.w3c.dom.stylesheets.StyleSheetList;

public class DocumentCSSImpl
implements ExtendedDocumentCSS {
    private StyleSheetListImpl styleSheetList = new StyleSheetListImpl();
    private Map styleDeclarationMap = null;

    public StyleSheetList getStyleSheets() {
        return this.styleSheetList;
    }

    public CSSStyleDeclaration getOverrideStyle(Element element, String string) {
        return null;
    }

    public void addStyleSheet(StyleSheet styleSheet) {
        this.styleSheetList.addStyleSheet(styleSheet);
    }

    public void removeAllStyleSheets() {
        this.styleSheetList.removeAllStyleSheets();
        this.styleDeclarationMap = null;
    }

    public List queryConditionSelector(int n) {
        return this.querySelector(0, n);
    }

    public List querySelector(int n, int n2) {
        List list = this.getCSSStyleDeclarationList(n, n2);
        if (list != null) {
            return list;
        }
        int n3 = this.styleSheetList.getLength();
        int n4 = 0;
        while (n4 < n3) {
            CSSStyleSheet cSSStyleSheet = (CSSStyleSheet)this.styleSheetList.item(n4);
            CSSRuleList cSSRuleList = cSSStyleSheet.getCssRules();
            list = this.querySelector(cSSRuleList, n, n2);
            this.setCSSStyleDeclarationList(list, n, n2);
            ++n4;
        }
        return list;
    }

    protected List querySelector(CSSRuleList cSSRuleList, int n, int n2) {
        ArrayList<Selector> arrayList = new ArrayList<Selector>();
        int n3 = cSSRuleList.getLength();
        int n4 = 0;
        while (n4 < n3) {
            CSSRule cSSRule = cSSRuleList.item(n4);
            switch (cSSRule.getType()) {
                case 1: {
                    if (!(cSSRule instanceof ExtendedCSSRule)) break;
                    ExtendedCSSRule extendedCSSRule = (ExtendedCSSRule)cSSRule;
                    SelectorList selectorList = extendedCSSRule.getSelectorList();
                    int n5 = selectorList.getLength();
                    int n6 = 0;
                    while (n6 < n5) {
                        Selector selector = selectorList.item(n6);
                        if (selector.getSelectorType() == n) {
                            switch (n) {
                                case 0: {
                                    ConditionalSelector conditionalSelector = (ConditionalSelector)selector;
                                    short s = conditionalSelector.getCondition().getConditionType();
                                    if (n2 != s) break;
                                    arrayList.add(selector);
                                }
                            }
                        }
                        ++n6;
                    }
                    break;
                }
            }
            ++n4;
        }
        return arrayList;
    }

    protected List getCSSStyleDeclarationList(int n, int n2) {
        Integer n3 = this.getKey(n, n2);
        return (List)this.getStyleDeclarationMap().get(n3);
    }

    protected void setCSSStyleDeclarationList(List list, int n, int n2) {
        Integer n3 = this.getKey(n, n2);
        this.getStyleDeclarationMap().put(n3, list);
    }

    protected Integer getKey(int n, int n2) {
        if (n == 0) {
            if (n2 == SAC_CLASS_CONDITION) {
                return SAC_CLASS_CONDITION;
            }
            if (n2 == SAC_ID_CONDITION) {
                return SAC_ID_CONDITION;
            }
            if (n2 == SAC_PSEUDO_CLASS_CONDITION) {
                return SAC_PSEUDO_CLASS_CONDITION;
            }
            return OTHER_SAC_CONDITIONAL_SELECTOR;
        }
        return OTHER_SAC_SELECTOR;
    }

    protected Map getStyleDeclarationMap() {
        if (this.styleDeclarationMap == null) {
            this.styleDeclarationMap = new HashMap();
        }
        return this.styleDeclarationMap;
    }
}

