/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.impl.dom;

import java.util.ArrayList;
import org.eclipse.e4.ui.css.core.dom.ExtendedCSSRule;
import org.eclipse.e4.ui.css.core.impl.dom.CSSComputedStyleImpl;
import org.eclipse.e4.ui.css.core.impl.dom.StyleWrapper;
import org.eclipse.e4.ui.css.core.impl.sac.ExtendedSelector;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.DocumentCSS;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.stylesheets.StyleSheetList;
import org.w3c.dom.views.DocumentView;

public class ViewCSSImpl
implements ViewCSS {
    protected DocumentCSS documentCSS;

    public ViewCSSImpl(DocumentCSS documentCSS) {
        this.documentCSS = documentCSS;
    }

    public DocumentView getDocument() {
        return null;
    }

    public CSSStyleDeclaration getComputedStyle(Element element, String string) {
        StyleSheetList styleSheetList = this.documentCSS.getStyleSheets();
        int n = styleSheetList.getLength();
        int n2 = 0;
        while (n2 < n) {
            CSSStyleSheet cSSStyleSheet = (CSSStyleSheet)styleSheetList.item(n2);
            CSSStyleDeclaration cSSStyleDeclaration = this.getComputedStyle(cSSStyleSheet, element, string);
            if (cSSStyleDeclaration != null) {
                return cSSStyleDeclaration;
            }
            ++n2;
        }
        return null;
    }

    public CSSStyleDeclaration getComputedStyle(CSSStyleSheet cSSStyleSheet, Element element, String string) {
        ArrayList<StyleWrapper> arrayList = null;
        StyleWrapper styleWrapper = null;
        CSSRuleList cSSRuleList = cSSStyleSheet.getCssRules();
        int n = cSSRuleList.getLength();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            CSSRule cSSRule = cSSRuleList.item(n3);
            switch (cSSRule.getType()) {
                case 1: {
                    CSSStyleRule cSSStyleRule = (CSSStyleRule)cSSRule;
                    if (!(cSSRule instanceof ExtendedCSSRule)) break;
                    ExtendedCSSRule extendedCSSRule = (ExtendedCSSRule)cSSRule;
                    SelectorList selectorList = extendedCSSRule.getSelectorList();
                    int n4 = selectorList.getLength();
                    int n5 = 0;
                    while (n5 < n4) {
                        ExtendedSelector extendedSelector;
                        Selector selector = selectorList.item(n5);
                        if (selector instanceof ExtendedSelector && (extendedSelector = (ExtendedSelector)selector).match(element, string)) {
                            CSSStyleDeclaration cSSStyleDeclaration = cSSStyleRule.getStyle();
                            int n6 = extendedSelector.getSpecificity();
                            StyleWrapper styleWrapper2 = new StyleWrapper(cSSStyleDeclaration, n6, n2++);
                            if (styleWrapper == null) {
                                styleWrapper = styleWrapper2;
                            } else {
                                if (arrayList == null) {
                                    arrayList = new ArrayList<StyleWrapper>();
                                    arrayList.add(styleWrapper);
                                }
                                arrayList.add(styleWrapper2);
                            }
                        }
                        ++n5;
                    }
                    break;
                }
            }
            ++n3;
        }
        if (arrayList != null) {
            return new CSSComputedStyleImpl(arrayList);
        }
        if (styleWrapper != null) {
            return styleWrapper.style;
        }
        return null;
    }
}

