/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.impl.dom.parsers;

import java.io.IOException;
import java.util.Stack;
import org.eclipse.e4.ui.css.core.dom.parsers.CSSParser;
import org.eclipse.e4.ui.css.core.impl.dom.CSSStyleDeclarationImpl;
import org.eclipse.e4.ui.css.core.impl.dom.CSSValueFactory;
import org.eclipse.e4.ui.css.core.sac.DocumentHandlerFactory;
import org.eclipse.e4.ui.css.core.sac.ExtendedDocumentHandler;
import org.eclipse.e4.ui.css.core.sac.ISACParserFactory;
import org.eclipse.e4.ui.css.core.sac.ParserNotFoundException;
import org.eclipse.e4.ui.css.core.sac.SACParserFactory;
import org.w3c.css.sac.ConditionFactory;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SelectorFactory;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.CSSValue;

public class AbstractCSSParser
implements CSSParser {
    private static DocumentHandlerFactory defaultDocumentHandlerFactory = DocumentHandlerFactory.newInstance();
    private static ISACParserFactory defaultParserFactory = SACParserFactory.newInstance();
    private Parser parser = null;
    private DocumentHandlerFactory documentHandlerFactory;
    private ISACParserFactory parserFactory;
    private ConditionFactory conditionFactory = null;
    private SelectorFactory selectorFactory = null;

    public CSSStyleSheet parseStyleSheet(InputSource inputSource) throws IOException {
        ExtendedDocumentHandler extendedDocumentHandler = this.getDocumentHandlerFactory().makeDocumentHandler();
        Parser parser = this.getParser();
        parser.setDocumentHandler((DocumentHandler)extendedDocumentHandler);
        parser.parseStyleSheet(inputSource);
        return (CSSStyleSheet)extendedDocumentHandler.getNodeRoot();
    }

    public CSSStyleDeclaration parseStyleDeclaration(InputSource inputSource) throws IOException {
        CSSStyleDeclarationImpl cSSStyleDeclarationImpl = new CSSStyleDeclarationImpl(null);
        this.parseStyleDeclaration(cSSStyleDeclarationImpl, inputSource);
        return cSSStyleDeclarationImpl;
    }

    public void parseStyleDeclaration(CSSStyleDeclaration cSSStyleDeclaration, InputSource inputSource) throws IOException {
        Stack<CSSStyleDeclaration> stack = new Stack<CSSStyleDeclaration>();
        stack.push(cSSStyleDeclaration);
        ExtendedDocumentHandler extendedDocumentHandler = this.getDocumentHandlerFactory().makeDocumentHandler();
        extendedDocumentHandler.setNodeStack(stack);
        Parser parser = this.getParser();
        parser.setDocumentHandler((DocumentHandler)extendedDocumentHandler);
        parser.parseStyleDeclaration(inputSource);
    }

    public CSSValue parsePropertyValue(InputSource inputSource) throws IOException {
        Parser parser = this.getParser();
        ExtendedDocumentHandler extendedDocumentHandler = this.getDocumentHandlerFactory().makeDocumentHandler();
        parser.setDocumentHandler((DocumentHandler)extendedDocumentHandler);
        return CSSValueFactory.newValue(parser.parsePropertyValue(inputSource));
    }

    public CSSRule parseRule(InputSource inputSource) throws IOException {
        return null;
    }

    public SelectorList parseSelectors(InputSource inputSource) throws IOException {
        return null;
    }

    public void setParentStyleSheet(CSSStyleSheet cSSStyleSheet) {
    }

    public DocumentHandlerFactory getDocumentHandlerFactory() {
        if (this.documentHandlerFactory == null) {
            return defaultDocumentHandlerFactory;
        }
        return this.documentHandlerFactory;
    }

    public void setDocumentHandlerFactory(DocumentHandlerFactory documentHandlerFactory) {
        this.documentHandlerFactory = documentHandlerFactory;
    }

    public Parser getParser() {
        if (this.parser == null) {
            try {
                this.parser = this.getSACParserFactory().makeParser();
                if (this.conditionFactory != null) {
                    this.parser.setConditionFactory(this.conditionFactory);
                }
                if (this.selectorFactory != null) {
                    this.parser.setSelectorFactory(this.selectorFactory);
                }
            }
            catch (Exception exception) {
                throw new ParserNotFoundException(exception);
            }
        }
        return this.parser;
    }

    public void setParser(Parser parser) {
        this.parser = parser;
    }

    public ISACParserFactory getSACParserFactory() {
        if (this.parserFactory == null) {
            return defaultParserFactory;
        }
        return this.parserFactory;
    }

    public void setSACParserFactory(ISACParserFactory iSACParserFactory) {
        this.parserFactory = iSACParserFactory;
    }

    public ConditionFactory getConditionFactory() {
        return this.conditionFactory;
    }

    public void setConditionFactory(ConditionFactory conditionFactory) {
        this.conditionFactory = conditionFactory;
    }

    public SelectorFactory getSelectorFactory() {
        return this.selectorFactory;
    }

    public void setSelectorFactory(SelectorFactory selectorFactory) {
        this.selectorFactory = selectorFactory;
    }
}

