/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.impl.engine;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.ui.css.core.dom.CSSStylableElement;
import org.eclipse.e4.ui.css.core.dom.ExtendedDocumentCSS;
import org.eclipse.e4.ui.css.core.dom.IElementProvider;
import org.eclipse.e4.ui.css.core.dom.parsers.CSSParser;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyCompositeHandler;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler2;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler2Delegate;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandlerProvider;
import org.eclipse.e4.ui.css.core.dom.properties.converters.ICSSValueConverter;
import org.eclipse.e4.ui.css.core.dom.selectors.IDynamicPseudoClassesHandler;
import org.eclipse.e4.ui.css.core.engine.CSSElementContext;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.engine.CSSErrorHandler;
import org.eclipse.e4.ui.css.core.exceptions.UnsupportedPropertyException;
import org.eclipse.e4.ui.css.core.impl.dom.DocumentCSSImpl;
import org.eclipse.e4.ui.css.core.impl.dom.ViewCSSImpl;
import org.eclipse.e4.ui.css.core.impl.engine.CSSElementContextImpl;
import org.eclipse.e4.ui.css.core.impl.sac.ExtendedSelector;
import org.eclipse.e4.ui.css.core.resources.CSSResourcesHelpers;
import org.eclipse.e4.ui.css.core.resources.IResourcesRegistry;
import org.eclipse.e4.ui.css.core.util.impl.resources.ResourcesLocatorManager;
import org.eclipse.e4.ui.css.core.util.resources.IResourcesLocatorManager;
import org.eclipse.e4.ui.css.core.utils.StringUtils;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Selector;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.DocumentCSS;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.stylesheets.StyleSheet;

public abstract class AbstractCSSEngine
implements CSSEngine {
    private static final IResourcesLocatorManager defaultResourcesLocatorManager = ResourcesLocatorManager.INSTANCE;
    private ExtendedDocumentCSS documentCSS;
    private ViewCSS viewCSS;
    private IElementProvider elementProvider;
    protected boolean computeDefaultStyle = false;
    private Map elementsWithDynamicPseudoClasses = null;
    private Map elementsContext = null;
    private CSSErrorHandler errorHandler;
    private IResourcesLocatorManager resourcesLocatorManager;
    private Map dynamicPseudoClassesHandler = new HashMap();
    private IResourcesRegistry resourcesRegistry;
    private List propertyHandlerProviders = new ArrayList();
    private Map currentCSSPropertiesApplyed = new HashMap();
    private boolean throwError;
    private Map valueConverters = null;

    public AbstractCSSEngine() {
        this(new DocumentCSSImpl());
    }

    public AbstractCSSEngine(ExtendedDocumentCSS extendedDocumentCSS) {
        this.documentCSS = extendedDocumentCSS;
        this.viewCSS = new ViewCSSImpl(extendedDocumentCSS);
    }

    public StyleSheet parseStyleSheet(Reader reader) throws IOException {
        InputSource inputSource = new InputSource();
        inputSource.setCharacterStream(reader);
        return this.parseStyleSheet(inputSource);
    }

    public StyleSheet parseStyleSheet(InputStream inputStream) throws IOException {
        InputSource inputSource = new InputSource();
        inputSource.setByteStream(inputStream);
        return this.parseStyleSheet(inputSource);
    }

    public StyleSheet parseStyleSheet(InputSource inputSource) throws IOException {
        this.checkInputSource(inputSource);
        CSSParser cSSParser = this.makeCSSParser();
        CSSStyleSheet cSSStyleSheet = cSSParser.parseStyleSheet(inputSource);
        if (this.documentCSS instanceof ExtendedDocumentCSS) {
            this.documentCSS.addStyleSheet(cSSStyleSheet);
        }
        return cSSStyleSheet;
    }

    private void checkInputSource(InputSource inputSource) throws IOException {
        Reader reader = inputSource.getCharacterStream();
        InputStream inputStream = inputSource.getByteStream();
        if (reader == null && inputStream == null) {
            throw new IOException("CharacterStream or ByteStream cannot be null for the InputSource.");
        }
    }

    public CSSStyleDeclaration parseStyleDeclaration(String string) throws IOException {
        StringReader stringReader = new StringReader(string);
        return this.parseStyleDeclaration(stringReader);
    }

    public CSSStyleDeclaration parseStyleDeclaration(Reader reader) throws IOException {
        InputSource inputSource = new InputSource();
        inputSource.setCharacterStream(reader);
        return this.parseStyleDeclaration(inputSource);
    }

    public CSSStyleDeclaration parseStyleDeclaration(InputStream inputStream) throws IOException {
        InputSource inputSource = new InputSource();
        inputSource.setByteStream(inputStream);
        return this.parseStyleDeclaration(inputSource);
    }

    public CSSStyleDeclaration parseStyleDeclaration(InputSource inputSource) throws IOException {
        this.checkInputSource(inputSource);
        CSSParser cSSParser = this.makeCSSParser();
        CSSStyleDeclaration cSSStyleDeclaration = cSSParser.parseStyleDeclaration(inputSource);
        return cSSStyleDeclaration;
    }

    public CSSValue parsePropertyValue(Reader reader) throws IOException {
        InputSource inputSource = new InputSource();
        inputSource.setCharacterStream(reader);
        return this.parsePropertyValue(inputSource);
    }

    public CSSValue parsePropertyValue(InputStream inputStream) throws IOException {
        InputSource inputSource = new InputSource();
        inputSource.setByteStream(inputStream);
        return this.parsePropertyValue(inputSource);
    }

    public CSSValue parsePropertyValue(String string) throws IOException {
        StringReader stringReader = new StringReader(string);
        return this.parsePropertyValue(stringReader);
    }

    public CSSValue parsePropertyValue(InputSource inputSource) throws IOException {
        this.checkInputSource(inputSource);
        CSSParser cSSParser = this.makeCSSParser();
        return cSSParser.parsePropertyValue(inputSource);
    }

    public void applyStyles(Object object, boolean bl) {
        this.applyStyles(object, bl, this.computeDefaultStyle);
    }

    public void applyStyles(Object object, boolean bl, boolean bl2) {
        Element element = this.getElement(object);
        if (element != null) {
            NodeList nodeList;
            CSSStyleDeclaration cSSStyleDeclaration = this.viewCSS.getComputedStyle(element, null);
            if (bl2) {
                if (bl) {
                    this.computeDefaultStyle = bl2;
                }
                this.applyDefaultStyleDeclaration(object, false, cSSStyleDeclaration, null);
            }
            this.initializeDynamicPseudoClassesIfNeeded(object);
            String[] stringArray = this.getStaticPseudoInstances(element);
            if (stringArray != null) {
                int n = 0;
                while (n < stringArray.length) {
                    String string = stringArray[n];
                    CSSStyleDeclaration cSSStyleDeclaration2 = this.viewCSS.getComputedStyle(element, string);
                    if (bl2) {
                        this.applyDefaultStyleDeclaration(object, false, cSSStyleDeclaration2, string);
                    }
                    if (cSSStyleDeclaration2 != null) {
                        this.applyStyleDeclaration(object, cSSStyleDeclaration2, string);
                    }
                    ++n;
                }
            }
            if (cSSStyleDeclaration != null) {
                this.applyStyleDeclaration(object, cSSStyleDeclaration, null);
            }
            try {
                this.applyInlineStyle(element, false);
            }
            catch (Exception exception) {
                this.handleExceptions(exception);
            }
            if (bl && (nodeList = element.getChildNodes()) != null) {
                int n = 0;
                while (n < nodeList.getLength()) {
                    this.applyStyles(nodeList.item(n), bl);
                    ++n;
                }
                this.onStylesAppliedToChildNodes(element, nodeList);
            }
        }
    }

    protected String[] getStaticPseudoInstances(Element element) {
        if (element instanceof CSSStylableElement) {
            CSSStylableElement cSSStylableElement = (CSSStylableElement)element;
            return cSSStylableElement.getStaticPseudoInstances();
        }
        return null;
    }

    protected void onStylesAppliedToChildNodes(Element element, NodeList nodeList) {
        if (element instanceof CSSStylableElement) {
            ((CSSStylableElement)element).onStylesApplied(nodeList);
        }
    }

    public void applyStyleDeclaration(Object object, CSSStyleDeclaration cSSStyleDeclaration, String string) {
        this.currentCSSPropertiesApplyed.clear();
        ArrayList<ICSSPropertyHandler2> arrayList = null;
        int n = 0;
        while (n < cSSStyleDeclaration.getLength()) {
            block13: {
                String object2 = cSSStyleDeclaration.item(n);
                CSSValue cSSValue = cSSStyleDeclaration.getPropertyCSSValue(object2);
                try {
                    ICSSPropertyHandler iCSSPropertyHandler = this.applyCSSProperty(object, object2, cSSValue, string);
                    ICSSPropertyHandler2 iCSSPropertyHandler2 = null;
                    if (iCSSPropertyHandler instanceof ICSSPropertyHandler2) {
                        iCSSPropertyHandler2 = (ICSSPropertyHandler2)((Object)iCSSPropertyHandler);
                    } else if (iCSSPropertyHandler instanceof ICSSPropertyHandler2Delegate) {
                        iCSSPropertyHandler2 = ((ICSSPropertyHandler2Delegate)((Object)iCSSPropertyHandler)).getCSSPropertyHandler2();
                    }
                    if (iCSSPropertyHandler2 != null) {
                        if (arrayList == null) {
                            arrayList = new ArrayList<ICSSPropertyHandler2>();
                        }
                        if (!arrayList.contains(iCSSPropertyHandler2)) {
                            arrayList.add(iCSSPropertyHandler2);
                        }
                    }
                }
                catch (Exception exception) {
                    if (!this.throwError && (this.throwError || exception instanceof UnsupportedPropertyException)) break block13;
                    this.handleExceptions(exception);
                }
            }
            ++n;
        }
        if (arrayList != null) {
            for (ICSSPropertyHandler2 iCSSPropertyHandler2 : arrayList) {
                try {
                    iCSSPropertyHandler2.onAllCSSPropertiesApplyed(object, this);
                }
                catch (Exception exception) {
                    this.handleExceptions(exception);
                }
            }
        }
    }

    public CSSStyleDeclaration parseAndApplyStyleDeclaration(Object object, Reader reader) throws IOException {
        CSSStyleDeclaration cSSStyleDeclaration = this.parseStyleDeclaration(reader);
        this.applyStyleDeclaration(object, cSSStyleDeclaration, null);
        return cSSStyleDeclaration;
    }

    public CSSStyleDeclaration parseAndApplyStyleDeclaration(Object object, InputStream inputStream) throws IOException {
        CSSStyleDeclaration cSSStyleDeclaration = this.parseStyleDeclaration(inputStream);
        this.applyStyleDeclaration(object, cSSStyleDeclaration, null);
        return cSSStyleDeclaration;
    }

    public CSSStyleDeclaration parseAndApplyStyleDeclaration(Object object, InputSource inputSource) throws IOException {
        CSSStyleDeclaration cSSStyleDeclaration = this.parseStyleDeclaration(inputSource);
        this.applyStyleDeclaration(object, cSSStyleDeclaration, null);
        return cSSStyleDeclaration;
    }

    public CSSStyleDeclaration parseAndApplyStyleDeclaration(Object object, String string) throws IOException {
        CSSStyleDeclaration cSSStyleDeclaration = this.parseStyleDeclaration(string);
        this.applyStyleDeclaration(object, cSSStyleDeclaration, null);
        return cSSStyleDeclaration;
    }

    public void applyInlineStyle(Object object, boolean bl) throws IOException {
        Element element = this.getElement(object);
        if (element != null) {
            Object object2;
            String string;
            if (element instanceof CSSStylableElement && (string = (object2 = (CSSStylableElement)element).getCSSStyle()) != null && string.length() > 0) {
                this.parseAndApplyStyleDeclaration(object2.getNativeWidget(), string);
            }
            if (bl && (object2 = element.getChildNodes()) != null) {
                int n = 0;
                while (n < object2.getLength()) {
                    this.applyInlineStyle(object2.item(n), bl);
                    ++n;
                }
            }
        }
    }

    public CSSStyleDeclaration getDefaultStyleDeclaration(Object object, String string) {
        return this.getDefaultStyleDeclaration(object, null, string);
    }

    public CSSStyleDeclaration getDefaultStyleDeclaration(Object object, CSSStyleDeclaration cSSStyleDeclaration, String string) {
        CSSStyleDeclaration cSSStyleDeclaration2 = null;
        for (ICSSPropertyHandlerProvider iCSSPropertyHandlerProvider : this.propertyHandlerProviders) {
            try {
                cSSStyleDeclaration2 = iCSSPropertyHandlerProvider.getDefaultCSSStyleDeclaration(this, object, cSSStyleDeclaration, string);
            }
            catch (Exception exception) {
                this.handleExceptions(exception);
            }
        }
        return cSSStyleDeclaration2;
    }

    public void applyDefaultStyleDeclaration(Object object, boolean bl) {
        this.applyDefaultStyleDeclaration(object, bl, null, null);
    }

    public void applyDefaultStyleDeclaration(Object object, boolean bl, CSSStyleDeclaration cSSStyleDeclaration, String string) {
        Element element = this.getElement(object);
        if (element != null) {
            Object object2;
            if (element instanceof CSSStylableElement) {
                object2 = (CSSStylableElement)element;
                CSSStyleDeclaration cSSStyleDeclaration2 = object2.getDefaultStyleDeclaration(string);
                CSSStyleDeclaration cSSStyleDeclaration3 = this.getDefaultStyleDeclaration(object, cSSStyleDeclaration, string);
                if (cSSStyleDeclaration2 != null) {
                    try {
                        this.throwError = false;
                        this.applyStyleDeclaration(object, cSSStyleDeclaration3, string);
                    }
                    finally {
                        this.throwError = true;
                    }
                }
            }
            if (bl && (object2 = element.getChildNodes()) != null) {
                int n = 0;
                while (n < object2.getLength()) {
                    this.applyDefaultStyleDeclaration(object2.item(n), bl);
                    ++n;
                }
                this.onStylesAppliedToChildNodes(element, (NodeList)object2);
            }
        }
    }

    public ICSSPropertyHandler applyCSSProperty(Object object, String string, CSSValue cSSValue, String string2) throws Exception {
        block6: {
            if (this.currentCSSPropertiesApplyed.containsKey(string)) {
                return null;
            }
            Collection collection = this.getCSSPropertyHandlers(string);
            if (collection == null) {
                if (this.throwError) {
                    throw new UnsupportedPropertyException(string);
                }
                return null;
            }
            try {
                for (ICSSPropertyHandler iCSSPropertyHandler : collection) {
                    boolean bl = iCSSPropertyHandler.applyCSSProperty(object, string, cSSValue, string2, this);
                    if (!bl) continue;
                    this.currentCSSPropertiesApplyed.put(string, string);
                    return iCSSPropertyHandler;
                }
            }
            catch (Exception exception) {
                if (!this.throwError && (this.throwError || exception instanceof UnsupportedPropertyException)) break block6;
                this.handleExceptions(exception);
            }
        }
        return null;
    }

    public String retrieveCSSProperty(Object object, String string, String string2) {
        Collection collection;
        block4: {
            collection = this.getCSSPropertyHandlers(string);
            if (collection != null) break block4;
            return null;
        }
        try {
            for (ICSSPropertyHandler iCSSPropertyHandler : collection) {
                String string3 = iCSSPropertyHandler.retrieveCSSProperty(object, string, string2, this);
                if (StringUtils.isEmpty(string3)) continue;
                return string3;
            }
        }
        catch (Exception exception) {
            this.handleExceptions(exception);
        }
        return null;
    }

    public String[] getCSSCompositePropertiesNames(String string) {
        Collection collection;
        block4: {
            collection = this.getCSSPropertyHandlers(string);
            if (collection != null) break block4;
            return null;
        }
        try {
            for (ICSSPropertyHandler iCSSPropertyHandler : collection) {
                ICSSPropertyCompositeHandler iCSSPropertyCompositeHandler;
                if (!(iCSSPropertyHandler instanceof ICSSPropertyCompositeHandler) || !(iCSSPropertyCompositeHandler = (ICSSPropertyCompositeHandler)iCSSPropertyHandler).isCSSPropertyComposite(string)) continue;
                return iCSSPropertyCompositeHandler.getCSSPropertiesNames(string);
            }
        }
        catch (Exception exception) {
            this.handleExceptions(exception);
        }
        return null;
    }

    protected Collection getCSSPropertyHandlers(String string) throws Exception {
        ArrayList arrayList = null;
        for (ICSSPropertyHandlerProvider iCSSPropertyHandlerProvider : this.propertyHandlerProviders) {
            ArrayList arrayList2 = iCSSPropertyHandlerProvider.getCSSPropertyHandlers(string);
            if (arrayList == null) {
                arrayList = arrayList2;
                continue;
            }
            arrayList = new ArrayList(arrayList);
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }

    public void registerDynamicPseudoClassHandler(String string, IDynamicPseudoClassesHandler iDynamicPseudoClassesHandler) {
        this.dynamicPseudoClassesHandler.put(string, iDynamicPseudoClassesHandler);
    }

    protected void initializeDynamicPseudoClassesIfNeeded(Object object) {
        if (this.dynamicPseudoClassesHandler == null || this.dynamicPseudoClassesHandler.values().size() < 1) {
            return;
        }
        Element element = this.getElement(object);
        if (element == null) {
            return;
        }
        if (this.isElementsWithDynamicPseudoClassesInitialized(element)) {
            return;
        }
        List list = this.documentCSS.queryConditionSelector(10);
        if (list == null) {
            return;
        }
        for (Selector selector : list) {
            IDynamicPseudoClassesHandler iDynamicPseudoClassesHandler;
            ConditionalSelector conditionalSelector = (ConditionalSelector)selector;
            String string = ((AttributeCondition)conditionalSelector.getCondition()).getValue();
            if (!((ExtendedSelector)conditionalSelector.getSimpleSelector()).match(element, string) || (iDynamicPseudoClassesHandler = (IDynamicPseudoClassesHandler)this.dynamicPseudoClassesHandler.get(string)) == null) continue;
            iDynamicPseudoClassesHandler.intialize(element, this);
            this.addElementsWithDynamicPseudoClasses(element);
        }
    }

    protected void addElementsWithDynamicPseudoClasses(Element element) {
        if (this.elementsWithDynamicPseudoClasses == null) {
            this.elementsWithDynamicPseudoClasses = new HashMap();
        }
        this.elementsWithDynamicPseudoClasses.put(element, element);
    }

    protected boolean isElementsWithDynamicPseudoClassesInitialized(Element element) {
        if (this.elementsWithDynamicPseudoClasses == null) {
            return false;
        }
        return this.elementsWithDynamicPseudoClasses.get(element) != null;
    }

    public IElementProvider getElementProvider() {
        return this.elementProvider;
    }

    public void setElementProvider(IElementProvider iElementProvider) {
        this.elementProvider = iElementProvider;
    }

    public Element getElement(Object object) {
        Element element = null;
        CSSElementContext cSSElementContext = this.getCSSElementContext(object);
        if (cSSElementContext != null && !cSSElementContext.elementMustBeRefreshed(this.elementProvider)) {
            return cSSElementContext.getElement();
        }
        if (object instanceof Element) {
            element = (Element)object;
        } else if (this.elementProvider != null) {
            element = this.elementProvider.getElement(object, this);
        }
        if (element != null) {
            if (cSSElementContext == null) {
                cSSElementContext = new CSSElementContextImpl();
                this.getElementsContext().put(this.getNativeWidget(object), cSSElementContext);
            }
            cSSElementContext.setElementProvider(this.elementProvider);
            cSSElementContext.setElement(element);
        }
        return element;
    }

    public Object getDocument() {
        return null;
    }

    public CSSElementContext getCSSElementContext(Object object) {
        Object object2 = this.getNativeWidget(object);
        return (CSSElementContext)this.getElementsContext().get(object2);
    }

    public Object getNativeWidget(Object object) {
        Object object2 = object;
        if (object instanceof CSSStylableElement) {
            object2 = ((CSSStylableElement)object2).getNativeWidget();
        }
        return object2;
    }

    protected Map getElementsContext() {
        if (this.elementsContext == null) {
            this.elementsContext = new HashMap();
        }
        return this.elementsContext;
    }

    public void handleExceptions(Exception exception) {
        if (this.errorHandler != null) {
            this.errorHandler.error(exception);
        }
    }

    public CSSErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(CSSErrorHandler cSSErrorHandler) {
        this.errorHandler = cSSErrorHandler;
    }

    public IResourcesLocatorManager getResourcesLocatorManager() {
        if (this.resourcesLocatorManager == null) {
            return defaultResourcesLocatorManager;
        }
        return this.resourcesLocatorManager;
    }

    public void setResourcesLocatorManager(IResourcesLocatorManager iResourcesLocatorManager) {
        this.resourcesLocatorManager = iResourcesLocatorManager;
    }

    public DocumentCSS getDocumentCSS() {
        return this.documentCSS;
    }

    public ViewCSS getViewCSS() {
        return this.viewCSS;
    }

    public void dispose() {
        this.reset();
        this.elementsContext = null;
        if (this.resourcesRegistry != null) {
            this.resourcesRegistry.dispose();
        }
    }

    public void reset() {
        this.documentCSS.removeAllStyleSheets();
        if (this.elementsWithDynamicPseudoClasses != null) {
            Collection collection = this.elementsWithDynamicPseudoClasses.values();
            for (Element element : collection) {
                Collection collection2 = this.dynamicPseudoClassesHandler.values();
                for (IDynamicPseudoClassesHandler iDynamicPseudoClassesHandler : collection2) {
                    iDynamicPseudoClassesHandler.dispose(element, this);
                }
            }
            this.elementsWithDynamicPseudoClasses = null;
        }
    }

    public IResourcesRegistry getResourcesRegistry() {
        return this.resourcesRegistry;
    }

    public void setResourcesRegistry(IResourcesRegistry iResourcesRegistry) {
        this.resourcesRegistry = iResourcesRegistry;
    }

    public void registerCSSPropertyHandlerProvider(ICSSPropertyHandlerProvider iCSSPropertyHandlerProvider) {
        this.propertyHandlerProviders.add(iCSSPropertyHandlerProvider);
    }

    public void unregisterCSSPropertyHandlerProvider(ICSSPropertyHandlerProvider iCSSPropertyHandlerProvider) {
        this.propertyHandlerProviders.remove(iCSSPropertyHandlerProvider);
    }

    public void registerCSSValueConverter(ICSSValueConverter iCSSValueConverter) {
        if (this.valueConverters == null) {
            this.valueConverters = new HashMap();
        }
        this.valueConverters.put(iCSSValueConverter.getToType(), iCSSValueConverter);
    }

    public void unregisterCSSValueConverter(ICSSValueConverter iCSSValueConverter) {
        if (this.valueConverters == null) {
            return;
        }
        this.valueConverters.remove(iCSSValueConverter);
    }

    public ICSSValueConverter getCSSValueConverter(Object object) {
        if (this.valueConverters != null) {
            return (ICSSValueConverter)this.valueConverters.get(object);
        }
        return null;
    }

    public Object convert(CSSValue cSSValue, Object object, Object object2) throws Exception {
        ICSSValueConverter iCSSValueConverter;
        Object object3 = null;
        String string = CSSResourcesHelpers.getCSSValueKey(cSSValue);
        IResourcesRegistry iResourcesRegistry = this.getResourcesRegistry();
        if (iResourcesRegistry != null && string != null) {
            object3 = iResourcesRegistry.getResource(object, string);
        }
        if (object3 == null && (iCSSValueConverter = this.getCSSValueConverter(object)) != null && (object3 = iCSSValueConverter.convert(cSSValue, (CSSEngine)this, object2)) != null && iResourcesRegistry != null && string != null) {
            iResourcesRegistry.registerResource(object, string, object3);
        }
        return object3;
    }

    public String convert(Object object, Object object2, Object object3) throws Exception {
        if (object == null) {
            return null;
        }
        ICSSValueConverter iCSSValueConverter = this.getCSSValueConverter(object2);
        if (iCSSValueConverter != null) {
            return iCSSValueConverter.convert(object, (CSSEngine)this, object3);
        }
        return null;
    }

    public abstract CSSParser makeCSSParser();
}

