/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.impl.engine;

import org.eclipse.e4.ui.css.core.dom.ExtendedDocumentCSS;
import org.eclipse.e4.ui.css.core.dom.parsers.CSSParser;
import org.eclipse.e4.ui.css.core.dom.parsers.CSSParserFactory;
import org.eclipse.e4.ui.css.core.dom.parsers.ICSSParserFactory;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler;
import org.eclipse.e4.ui.css.core.dom.properties.converters.CSSValueBooleanConverterImpl;
import org.eclipse.e4.ui.css.core.dom.properties.providers.CSSPropertyHandlerLazyProviderImpl;
import org.eclipse.e4.ui.css.core.dom.properties.providers.CSSPropertyHandlerSimpleProviderImpl;
import org.eclipse.e4.ui.css.core.impl.engine.AbstractCSSEngine;
import org.eclipse.e4.ui.css.core.impl.sac.CSSConditionFactoryImpl;
import org.eclipse.e4.ui.css.core.impl.sac.CSSSelectorFactoryImpl;
import org.w3c.css.sac.ConditionFactory;

public class CSSEngineImpl
extends AbstractCSSEngine {
    public static final ConditionFactory CONDITIONFACTORY_INSTANCE = new CSSConditionFactoryImpl(null, "class", null, "id");
    private CSSPropertyHandlerSimpleProviderImpl handlerProvider = null;
    private CSSPropertyHandlerLazyProviderImpl lazyHandlerProvider = null;

    public CSSEngineImpl() {
        super.registerCSSValueConverter(CSSValueBooleanConverterImpl.INSTANCE);
    }

    public CSSEngineImpl(ExtendedDocumentCSS extendedDocumentCSS) {
        super(extendedDocumentCSS);
        super.registerCSSValueConverter(CSSValueBooleanConverterImpl.INSTANCE);
    }

    public CSSParser makeCSSParser() {
        ICSSParserFactory iCSSParserFactory = CSSParserFactory.newInstance();
        CSSParser cSSParser = iCSSParserFactory.makeCSSParser();
        cSSParser.setSelectorFactory(CSSSelectorFactoryImpl.INSTANCE);
        cSSParser.setConditionFactory(CONDITIONFACTORY_INSTANCE);
        return cSSParser;
    }

    public void registerCSSPropertyHandler(Class clazz, ICSSPropertyHandler iCSSPropertyHandler) {
        this.initHandlerProviderIfNeed();
        this.handlerProvider.registerCSSPropertyHandler(clazz, iCSSPropertyHandler);
    }

    private void initHandlerProviderIfNeed() {
        if (this.handlerProvider == null) {
            this.handlerProvider = new CSSPropertyHandlerSimpleProviderImpl();
            super.registerCSSPropertyHandlerProvider(this.handlerProvider);
        }
    }

    public void registerCSSProperty(String string, Class clazz) {
        this.initHandlerProviderIfNeed();
        this.handlerProvider.registerCSSProperty(string, clazz);
    }

    private void initLazyHandlerProviderIfNeed() {
        if (this.lazyHandlerProvider == null) {
            this.lazyHandlerProvider = new CSSPropertyHandlerLazyProviderImpl();
            super.registerCSSPropertyHandlerProvider(this.lazyHandlerProvider);
        }
    }

    public void registerPackage(String string) {
        this.initLazyHandlerProviderIfNeed();
        this.lazyHandlerProvider.registerPackage(string);
    }
}

