/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.impl.sac;

import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.e4.ui.css.core.dom.CSSProperty;
import org.eclipse.e4.ui.css.core.impl.dom.CSSImportRuleImpl;
import org.eclipse.e4.ui.css.core.impl.dom.CSSPageRuleImpl;
import org.eclipse.e4.ui.css.core.impl.dom.CSSPropertyImpl;
import org.eclipse.e4.ui.css.core.impl.dom.CSSRuleListImpl;
import org.eclipse.e4.ui.css.core.impl.dom.CSSStyleDeclarationImpl;
import org.eclipse.e4.ui.css.core.impl.dom.CSSStyleRuleImpl;
import org.eclipse.e4.ui.css.core.impl.dom.CSSStyleSheetImpl;
import org.eclipse.e4.ui.css.core.impl.dom.CSSUnknownRuleImpl;
import org.eclipse.e4.ui.css.core.impl.dom.CSSValueFactory;
import org.eclipse.e4.ui.css.core.impl.dom.MediaListImpl;
import org.eclipse.e4.ui.css.core.sac.ExtendedDocumentHandler;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleSheet;

public class CSSDocumentHandlerImpl
implements ExtendedDocumentHandler {
    private static Log logger = LogFactory.getLog(CSSDocumentHandlerImpl.class);
    private Stack nodeStack;
    private Object nodeRoot = null;
    private CSSStyleSheet parentStyleSheet;
    private boolean ignore;

    public Object getRoot() {
        return this.nodeRoot;
    }

    public void startDocument(InputSource inputSource) throws CSSException {
        if (this.getNodeStack().empty()) {
            CSSStyleSheetImpl cSSStyleSheetImpl = new CSSStyleSheetImpl();
            this.parentStyleSheet = cSSStyleSheetImpl;
            CSSRuleListImpl cSSRuleListImpl = new CSSRuleListImpl();
            cSSStyleSheetImpl.setRuleList(cSSRuleListImpl);
            this.getNodeStack().push(cSSStyleSheetImpl);
            this.getNodeStack().push(cSSRuleListImpl);
        }
    }

    public void endDocument(InputSource inputSource) throws CSSException {
        this.getNodeStack().pop();
        this.nodeRoot = this.getNodeStack().pop();
    }

    public void comment(String string) throws CSSException {
    }

    public void ignorableAtRule(String string) throws CSSException {
        CSSUnknownRuleImpl cSSUnknownRuleImpl = new CSSUnknownRuleImpl(this.parentStyleSheet, null, string);
        if (!this.getNodeStack().empty()) {
            ((CSSRuleListImpl)this.getNodeStack().peek()).add(cSSUnknownRuleImpl);
        } else {
            this.nodeRoot = cSSUnknownRuleImpl;
        }
    }

    public void namespaceDeclaration(String string, String string2) throws CSSException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Declare namespace [prefix=" + string + ", uri=" + string2 + "]"));
        }
    }

    public void importStyle(String string, SACMediaList sACMediaList, String string2) throws CSSException {
        CSSImportRuleImpl cSSImportRuleImpl = new CSSImportRuleImpl(this.parentStyleSheet, null, string, new MediaListImpl(sACMediaList));
        if (!this.getNodeStack().empty()) {
            ((CSSRuleListImpl)this.getNodeStack().peek()).add(cSSImportRuleImpl);
        } else {
            this.nodeRoot = cSSImportRuleImpl;
        }
    }

    public void startMedia(SACMediaList sACMediaList) throws CSSException {
        this.ignore = true;
    }

    public void endMedia(SACMediaList sACMediaList) throws CSSException {
        this.ignore = false;
    }

    public void startPage(String string, String string2) throws CSSException {
        CSSPageRuleImpl cSSPageRuleImpl = new CSSPageRuleImpl(this.parentStyleSheet, null, string, string2);
        if (!this.getNodeStack().empty()) {
            ((CSSRuleListImpl)this.getNodeStack().peek()).add(cSSPageRuleImpl);
        }
        CSSStyleDeclarationImpl cSSStyleDeclarationImpl = new CSSStyleDeclarationImpl(cSSPageRuleImpl);
        cSSPageRuleImpl.setStyle(cSSStyleDeclarationImpl);
        this.getNodeStack().push(cSSPageRuleImpl);
        this.getNodeStack().push(cSSStyleDeclarationImpl);
    }

    public void endPage(String string, String string2) throws CSSException {
        this.getNodeStack().pop();
        this.nodeRoot = this.getNodeStack().pop();
    }

    public void startFontFace() throws CSSException {
        this.ignore = true;
    }

    public void endFontFace() throws CSSException {
        this.ignore = false;
    }

    public void startSelector(SelectorList selectorList) throws CSSException {
        CSSStyleRuleImpl cSSStyleRuleImpl = new CSSStyleRuleImpl(this.parentStyleSheet, null, selectorList);
        if (!this.getNodeStack().empty()) {
            ((CSSRuleListImpl)this.getNodeStack().peek()).add(cSSStyleRuleImpl);
        }
        CSSStyleDeclarationImpl cSSStyleDeclarationImpl = new CSSStyleDeclarationImpl(cSSStyleRuleImpl);
        cSSStyleRuleImpl.setStyle(cSSStyleDeclarationImpl);
        this.getNodeStack().push(cSSStyleRuleImpl);
        this.getNodeStack().push(cSSStyleDeclarationImpl);
    }

    public void endSelector(SelectorList selectorList) throws CSSException {
        this.getNodeStack().pop();
        this.nodeRoot = this.getNodeStack().pop();
    }

    public void property(String string, LexicalUnit lexicalUnit, boolean bl) throws CSSException {
        if (!this.ignore) {
            CSSStyleDeclarationImpl cSSStyleDeclarationImpl = (CSSStyleDeclarationImpl)this.getNodeStack().peek();
            cSSStyleDeclarationImpl.addProperty(this.getCSSProperty(cSSStyleDeclarationImpl, string, lexicalUnit, bl));
        }
    }

    protected CSSProperty getCSSProperty(CSSStyleDeclaration cSSStyleDeclaration, String string, LexicalUnit lexicalUnit, boolean bl) {
        return new CSSPropertyImpl(string, CSSValueFactory.newValue(lexicalUnit), bl);
    }

    public Object getNodeRoot() {
        return this.nodeRoot;
    }

    public void setNodeStack(Stack stack) {
        this.nodeStack = stack;
    }

    public Stack getNodeStack() {
        if (this.nodeStack == null) {
            this.nodeStack = new Stack();
        }
        return this.nodeStack;
    }
}

