/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.resources;

import org.eclipse.e4.ui.css.core.css2.CSS2ColorHelper;
import org.eclipse.e4.ui.css.core.dom.properties.css2.CSS2FontProperties;
import org.eclipse.e4.ui.css.core.resources.IResourcesRegistry;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.RGBColor;

public class CSSResourcesHelpers {
    public static String getCSSValueKey(CSSValue cSSValue) {
        if (cSSValue instanceof CSS2FontProperties) {
            return CSSResourcesHelpers.getCSSFontPropertiesKey((CSS2FontProperties)cSSValue);
        }
        if (cSSValue.getCssValueType() == 1) {
            return CSSResourcesHelpers.getCSSPrimitiveValueKey((CSSPrimitiveValue)cSSValue);
        }
        return null;
    }

    public static String getCSSPrimitiveValueKey(CSSPrimitiveValue cSSPrimitiveValue) {
        switch (cSSPrimitiveValue.getPrimitiveType()) {
            case 20: 
            case 21: {
                RGBColor rGBColor;
                String string = cSSPrimitiveValue.getStringValue();
                if (CSS2ColorHelper.isColorName(string) && (rGBColor = CSS2ColorHelper.getRGBColor(string)) != null) {
                    return CSSResourcesHelpers.getCSSRGBColorKey(rGBColor);
                }
                return cSSPrimitiveValue.getStringValue();
            }
            case 25: {
                RGBColor rGBColor = cSSPrimitiveValue.getRGBColorValue();
                return CSSResourcesHelpers.getCSSRGBColorKey(rGBColor);
            }
        }
        return null;
    }

    public static String getCSSRGBColorKey(RGBColor rGBColor) {
        if (rGBColor == null) {
            return null;
        }
        String string = String.valueOf((int)rGBColor.getGreen().getFloatValue((short)1)) + "_";
        string = String.valueOf(string) + (int)rGBColor.getRed().getFloatValue((short)1) + "_";
        string = String.valueOf(string) + (int)rGBColor.getBlue().getFloatValue((short)1);
        return string;
    }

    public static String getCSSFontPropertiesKey(CSS2FontProperties cSS2FontProperties) {
        return cSS2FontProperties.getFamily() + "_" + cSS2FontProperties.getSize() + "_" + cSS2FontProperties.getStyle() + "_" + cSS2FontProperties.getWeight();
    }

    public static Object getResource(IResourcesRegistry iResourcesRegistry, Object object, CSSPrimitiveValue cSSPrimitiveValue) {
        String string = CSSResourcesHelpers.getCSSPrimitiveValueKey(cSSPrimitiveValue);
        return CSSResourcesHelpers.getResource(iResourcesRegistry, object, string);
    }

    public static Object getResource(IResourcesRegistry iResourcesRegistry, Object object, String string) {
        if (string == null) {
            return null;
        }
        if (iResourcesRegistry != null) {
            return iResourcesRegistry.getResource(object, string);
        }
        return null;
    }

    public static void registerResource(IResourcesRegistry iResourcesRegistry, Object object, CSSPrimitiveValue cSSPrimitiveValue, Object object2) {
        String string;
        if (iResourcesRegistry != null && (string = CSSResourcesHelpers.getCSSPrimitiveValueKey(cSSPrimitiveValue)) != null) {
            iResourcesRegistry.registerResource(object, string, object2);
        }
    }

    public static void registerResource(IResourcesRegistry iResourcesRegistry, Object object, String string, Object object2) {
        if (string == null) {
            return;
        }
        if (iResourcesRegistry != null) {
            iResourcesRegistry.registerResource(object, string, object2);
        }
    }
}

