/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.serializers;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.serializers.CSSSerializerConfiguration;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSStyleDeclaration;

public class CSSSerializer {
    public void serialize(Writer writer, CSSEngine cSSEngine, Object object, boolean bl) throws IOException {
        this.serialize(writer, cSSEngine, object, bl, null);
    }

    public void serialize(Writer writer, CSSEngine cSSEngine, Object object, boolean bl, CSSSerializerConfiguration cSSSerializerConfiguration) throws IOException {
        HashMap hashMap = new HashMap();
        this.serialize(writer, cSSEngine, object, bl, hashMap, cSSSerializerConfiguration);
        boolean bl2 = true;
        for (Map.Entry entry : hashMap.entrySet()) {
            String string = (String)entry.getKey();
            CSSStyleDeclaration cSSStyleDeclaration = (CSSStyleDeclaration)entry.getValue();
            if (cSSStyleDeclaration == null) continue;
            int n = cSSStyleDeclaration.getLength();
            this.startSelector(writer, string, bl2);
            bl2 = false;
            int n2 = 0;
            while (n2 < n) {
                String string2 = cSSStyleDeclaration.item(n2);
                String string3 = cSSStyleDeclaration.getPropertyValue(string2);
                this.property(writer, string2, string3);
                ++n2;
            }
            this.endSelector(writer, string);
        }
    }

    protected void serialize(Writer writer, CSSEngine cSSEngine, Object object, boolean bl, Map map, CSSSerializerConfiguration cSSSerializerConfiguration) throws IOException {
        Element element = cSSEngine.getElement(object);
        if (element != null) {
            int n;
            Object object2;
            String string = element.getLocalName();
            CSSStyleDeclaration cSSStyleDeclaration = cSSEngine.getDefaultStyleDeclaration(object, null);
            if (cSSSerializerConfiguration != null) {
                object2 = cSSSerializerConfiguration.getAttributesFilter();
                n = 0;
                while (n < ((String[])object2).length) {
                    String string2 = object2[n];
                    String string3 = element.getAttribute(string2);
                    if (string3 != null && string3.length() > 0) {
                        if (string3.indexOf(".") != -1) {
                            string3 = "'" + string3 + "'";
                        }
                        string = String.valueOf(string) + "[" + string2 + "=" + string3 + "]";
                        break;
                    }
                    ++n;
                }
            }
            map.put(string, cSSStyleDeclaration);
            if (bl && (object2 = element.getChildNodes()) != null) {
                n = 0;
                while (n < object2.getLength()) {
                    this.serialize(writer, cSSEngine, object2.item(n), bl, map, cSSSerializerConfiguration);
                    ++n;
                }
            }
        }
    }

    protected void startSelector(Writer writer, String string, boolean bl) throws IOException {
        if (!bl) {
            writer.write("\n\n");
        }
        writer.write(String.valueOf(string) + " {");
    }

    protected void endSelector(Writer writer, String string) throws IOException {
        writer.write("\n}");
    }

    private void property(Writer writer, String string, String string2) throws IOException {
        writer.write("\n\t" + string + ":" + string2 + ";");
    }
}

