/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.util.impl.resources;

import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.ui.css.core.util.impl.resources.FileResourcesLocatorImpl;
import org.eclipse.e4.ui.css.core.util.impl.resources.HttpResourcesLocatorImpl;
import org.eclipse.e4.ui.css.core.util.resources.IResourceLocator;
import org.eclipse.e4.ui.css.core.util.resources.IResourcesLocatorManager;
import org.eclipse.e4.ui.css.core.utils.StringUtils;

public class ResourcesLocatorManager
implements IResourcesLocatorManager {
    public static final IResourcesLocatorManager INSTANCE = new ResourcesLocatorManager();
    private List uriResolvers = null;

    public ResourcesLocatorManager() {
        this.registerResourceLocator(new HttpResourcesLocatorImpl());
        this.registerResourceLocator(new FileResourcesLocatorImpl());
    }

    public void registerResourceLocator(IResourceLocator iResourceLocator) {
        if (this.uriResolvers == null) {
            this.uriResolvers = new ArrayList();
        }
        this.uriResolvers.add(iResourceLocator);
    }

    public void unregisterResourceLocator(IResourceLocator iResourceLocator) {
        if (this.uriResolvers == null) {
            return;
        }
        this.uriResolvers.remove(iResourceLocator);
    }

    public String resolve(String string) {
        if (StringUtils.isEmpty(string)) {
            return null;
        }
        if (this.uriResolvers == null) {
            return null;
        }
        for (IResourceLocator iResourceLocator : this.uriResolvers) {
            String string2 = iResourceLocator.resolve(string);
            if (string2 == null) continue;
            return string2;
        }
        return null;
    }

    public InputStream getInputStream(String string) throws Exception {
        if (StringUtils.isEmpty(string)) {
            return null;
        }
        if (this.uriResolvers == null) {
            return null;
        }
        for (IResourceLocator iResourceLocator : this.uriResolvers) {
            InputStream inputStream;
            String string2 = iResourceLocator.resolve(string);
            if (string2 == null || (inputStream = iResourceLocator.getInputStream(string)) == null) continue;
            return inputStream;
        }
        return null;
    }

    public Reader getReader(String string) throws Exception {
        if (StringUtils.isEmpty(string)) {
            return null;
        }
        if (this.uriResolvers == null) {
            return null;
        }
        for (IResourceLocator iResourceLocator : this.uriResolvers) {
            Reader reader;
            String string2 = iResourceLocator.resolve(string);
            if (string2 == null || (reader = iResourceLocator.getReader(string)) == null) continue;
            return reader;
        }
        return null;
    }
}

