/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.demo.javascript;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.WeakHashMap;
import org.eclipse.e4.core.services.IContributionFactorySpi;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.demo.javascript.JSUtil;
import org.mozilla.javascript.Scriptable;
import org.osgi.framework.Bundle;

public class JSContributionFactory
implements IContributionFactorySpi {
    private JSUtil js;
    private WeakHashMap contributionDatas = new WeakHashMap();

    public JSContributionFactory() {
        this.js = new JSUtil();
    }

    private static String readString(InputStream inputStream) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        while ((n = bufferedInputStream.read()) != -1) {
            stringBuffer.append((char)n);
        }
        bufferedInputStream.close();
        return stringBuffer.toString();
    }

    public Object create(Bundle bundle, String string, IEclipseContext iEclipseContext) {
        ContributionData contributionData = new ContributionData();
        contributionData.bundle = bundle;
        contributionData.name = string;
        contributionData.context = iEclipseContext;
        Object object = contributionData.updateContribution(this.js, null);
        ContributionWrapper contributionWrapper = new ContributionWrapper(object);
        this.contributionDatas.put(contributionWrapper, contributionData);
        return contributionWrapper;
    }

    public Object call(Object object, String string, IEclipseContext iEclipseContext, Object object2) {
        ContributionWrapper contributionWrapper = (ContributionWrapper)object;
        ContributionData contributionData = (ContributionData)this.contributionDatas.get(contributionWrapper);
        contributionWrapper.contribution = contributionData.updateContribution(this.js, contributionWrapper.contribution);
        Object object3 = this.js.get(contributionWrapper.contribution, String.valueOf(string) + "args");
        int n = this.js.length(object3);
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = iEclipseContext.get((String)this.js.get(object3, n2));
            ++n2;
        }
        Object object4 = this.js.get(contributionWrapper.contribution, string);
        if (object4 == null || !(object4 instanceof Scriptable)) {
            if (object2 != null) {
                return object2;
            }
            throw new RuntimeException("could not find function " + string + " in " + contributionData.name);
        }
        Object object5 = this.js.call(object4, contributionWrapper.contribution, objectArray);
        return object5;
    }

    private static class ContributionData {
        Bundle bundle;
        String name;
        String script;
        IEclipseContext context;

        private ContributionData() {
        }

        private Object updateContribution(JSUtil jSUtil, Object object) {
            try {
                InputStream inputStream = this.bundle.getResource(this.name).openStream();
                String string = JSContributionFactory.readString(inputStream);
                if (this.script != null && this.script.equals(string)) {
                    return object;
                }
                this.script = string;
                object = jSUtil.eval(this.script);
                Object object2 = jSUtil.get(object, "initargs");
                if (object2 instanceof Scriptable) {
                    int n = jSUtil.length(object2);
                    Object[] objectArray = new Object[n];
                    int n2 = 0;
                    while (n2 < n) {
                        objectArray[n2] = this.context.get((String)jSUtil.get(object2, n2));
                        ++n2;
                    }
                    jSUtil.call(jSUtil.get(object, "init"), object, objectArray);
                }
                return object;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return null;
            }
        }
    }

    private static class ContributionWrapper {
        Object contribution;

        public ContributionWrapper(Object object) {
            this.contribution = object;
        }
    }
}

