/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.demo.javascript;

import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;

public class JSUtil {
    private Context jsContext = Context.enter();
    private ImporterTopLevel jsScope = new ImporterTopLevel(this.jsContext);

    public Object eval(String string) {
        Object object = this.jsContext.evaluateString((Scriptable)this.jsScope, "[" + string + "][0]", "eval", 0, null);
        return object;
    }

    public Object get(Object object, String string) {
        if (object instanceof Scriptable) {
            return ((Scriptable)object).get(string, (Scriptable)((IdScriptableObject)object));
        }
        return null;
    }

    public Object get(Object object, int n) {
        return ((IdScriptableObject)object).get(n, (Scriptable)((IdScriptableObject)object));
    }

    public int length(Object object) {
        Number number = (Number)this.get(object, "length");
        return number == null ? 0 : number.intValue();
    }

    public Object call(Object object, Object object2, Object[] objectArray) {
        return ((BaseFunction)object).call(this.jsContext, (Scriptable)this.jsScope, (Scriptable)object2, objectArray);
    }

    public static void main(String[] stringArray) {
        JSUtil jSUtil = new JSUtil();
        Object object = jSUtil.eval("{args:['foo','bar'], f:function(foo, x){return foo.incremented(x);}}");
        System.out.println(object);
        Object object2 = jSUtil.get(object, "args");
        System.out.println(object2);
        System.out.println("length: " + jSUtil.length(object2));
        Object object3 = jSUtil.get(object, "f");
        System.out.println(object3);
        System.out.println(jSUtil.get(object2, 0));
        System.out.println(jSUtil.get(object2, 1));
        Object object4 = jSUtil.call(object3, null, new Object[]{new Foo(), 6});
        System.out.println(object4);
    }

    private static class Foo {
        private Foo() {
        }

        public int incremented(int n) {
            return n + 1;
        }
    }
}

