/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.demo.modifier;

import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.e4.demo.modifier.EMFScriptable;
import org.eclipse.e4.demo.modifier.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ElementView {
    private Realm realm = Realm.getDefault();
    private IObservableValue selectedElement = new WritableValue(this.realm);
    private IObservableValue jsText = new ComputedValue(this.realm){

        protected Object calculate() {
            return ElementView.this.formatJSField((EObject)ElementView.this.selectedElement.getValue());
        }
    };
    private Text jsInputField;
    private Context jsContext;
    private ImporterTopLevel jsScope;

    public ElementView(Composite composite) {
        this.jsInputField = new Text(composite, 2818);
        Observables.pipe((IObservableValue)this.jsText, (IObservableValue)SWTObservables.observeText((Control)this.jsInputField));
        Button button = new Button(composite, 8);
        button.setText("Run Script");
        button.setBounds(10, 320, 100, 25);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                ElementView.this.runJS(ElementView.this.jsInputField.getText());
            }
        });
        GridLayoutFactory.fillDefaults().generateLayout(composite);
        this.initJS();
    }

    protected String formatJSField(EObject eObject) {
        if (eObject == null) {
            return "";
        }
        String string = this.jsInputField.getLineDelimiter();
        String string2 = "// " + eObject.eClass().getName() + " is selected...\r\n" + "me = selectedElement;" + string + "out.println(me);" + string;
        for (EStructuralFeature eStructuralFeature : eObject.eClass().getEAllStructuralFeatures()) {
            System.err.println(eStructuralFeature.getEType().getInstanceClass());
            Object object = eObject.eGet(eStructuralFeature);
            if (!(object instanceof String) && !(object instanceof Boolean) && !(object instanceof Number)) continue;
            System.err.println("FEATURE: " + eStructuralFeature.getName());
            String string3 = String.valueOf(eStructuralFeature.getName().substring(0, 1).toUpperCase()) + eStructuralFeature.getName().substring(1);
            string3 = eStructuralFeature.getName();
            String string4 = object instanceof String ? "me." + string3 + "=\"" + object + "\"" : "me." + string3 + "=" + object;
            string2 = String.valueOf(string2) + string4 + string;
        }
        return string2;
    }

    @Inject
    public void setInput(final EObject eObject) {
        if (eObject == null) {
            return;
        }
        this.realm.asyncExec(new Runnable(){

            public void run() {
                ElementView.this.selectedElement.setValue((Object)eObject);
            }
        });
    }

    protected void runJS(String string) {
        try {
            ScriptableObject.putProperty((Scriptable)this.jsScope, (String)"selectedElement", (Object)((Object)new EMFScriptable((EObject)this.selectedElement.getValue())));
            System.err.println("SCOPE: " + this.jsScope);
            System.err.println("SCRIPT: " + string);
            Object object = this.jsContext.evaluateString((Scriptable)this.jsScope, string, "LCV Evaluator", 0, null);
            System.out.println("after eval: result = " + object.toString());
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            System.out.println("Exception!!");
            this.initJS();
        }
    }

    private void initJS() {
        if (this.jsContext != null) {
            Context.exit();
        }
        this.jsContext = Context.enter();
        this.jsScope = new ImporterTopLevel(this.jsContext);
        Object object = Context.javaToJS((Object)System.out, (Scriptable)this.jsScope);
        ScriptableObject.putProperty((Scriptable)this.jsScope, (String)"out", (Object)object);
    }
}

