/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.resources.mapping.ResourceChangeValidator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceAction;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchPartLabelProvider;

public class CloseResourceAction
extends WorkspaceAction
implements IResourceChangeListener {
    public static final String ID = "org.eclipse.ui.CloseResourceAction";
    private String[] modelProviderIds;

    public CloseResourceAction(Shell shell) {
        super(shell, IDEWorkbenchMessages.CloseResourceAction_text);
        this.initAction();
    }

    protected CloseResourceAction(Shell shell, String string) {
        super(shell, string);
    }

    public CloseResourceAction(IShellProvider iShellProvider) {
        super(iShellProvider, IDEWorkbenchMessages.CloseResourceAction_text);
        this.initAction();
    }

    protected CloseResourceAction(IShellProvider iShellProvider, String string) {
        super(iShellProvider, string);
    }

    private void initAction() {
        this.setId(ID);
        this.setToolTipText(IDEWorkbenchMessages.CloseResourceAction_toolTip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.close_resource_action_context");
    }

    List getDirtyEditors(List list) {
        ArrayList<IEditorPart> arrayList = new ArrayList<IEditorPart>(0);
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = 0;
        while (n < iWorkbenchWindowArray.length) {
            IWorkbenchPage[] iWorkbenchPageArray = iWorkbenchWindowArray[n].getPages();
            int n2 = 0;
            while (n2 < iWorkbenchPageArray.length) {
                IWorkbenchPage iWorkbenchPage = iWorkbenchPageArray[n2];
                IEditorPart[] iEditorPartArray = iWorkbenchPage.getDirtyEditors();
                int n3 = 0;
                while (n3 < iEditorPartArray.length) {
                    IEditorPart iEditorPart = iEditorPartArray[n3];
                    IFile iFile = ResourceUtil.getFile(iEditorPart.getEditorInput());
                    if (iFile != null && list.contains(iFile.getProject())) {
                        arrayList.add(iEditorPart);
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        return arrayList;
    }

    List getEditorsToSave(List list) {
        IFile iFile;
        IEditorPart iEditorPart;
        if (list.isEmpty()) {
            return new ArrayList(0);
        }
        ArrayList<IEditorPart> arrayList = new ArrayList<IEditorPart>(0);
        ArrayList<IFile> arrayList2 = new ArrayList<IFile>(0);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            iEditorPart = (IEditorPart)iterator.next();
            iFile = ResourceUtil.getFile(iEditorPart.getEditorInput());
            if (iFile == null || arrayList2.contains(iFile)) continue;
            arrayList2.add(iFile);
            arrayList.add(iEditorPart);
        }
        iEditorPart = new AdaptableList(arrayList);
        iFile = new ListSelectionDialog(this.getShell(), (Object)iEditorPart, (IStructuredContentProvider)new WorkbenchContentProvider(), (ILabelProvider)new WorkbenchPartLabelProvider(), IDEWorkbenchMessages.EditorManager_saveResourcesMessage);
        iFile.setInitialSelections(arrayList.toArray(new Object[arrayList.size()]));
        iFile.setTitle(IDEWorkbenchMessages.EditorManager_saveResourcesTitle);
        int n = iFile.open();
        if (n == 1) {
            return null;
        }
        return Arrays.asList(iFile.getResult());
    }

    protected String getOperationMessage() {
        return IDEWorkbenchMessages.CloseResourceAction_operationMessage;
    }

    protected String getProblemsMessage() {
        return IDEWorkbenchMessages.CloseResourceAction_problemMessage;
    }

    protected String getProblemsTitle() {
        return IDEWorkbenchMessages.CloseResourceAction_title;
    }

    protected void invokeOperation(IResource iResource, IProgressMonitor iProgressMonitor) throws CoreException {
        ((IProject)iResource).close(iProgressMonitor);
    }

    public void run() {
        if (!this.saveDirtyEditors()) {
            return;
        }
        if (!this.validateClose()) {
            return;
        }
        ISchedulingRule iSchedulingRule = null;
        IResourceRuleFactory iResourceRuleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        Iterator iterator = this.getSelectedResources().iterator();
        while (iterator.hasNext()) {
            IProject iProject = (IProject)iterator.next();
            iSchedulingRule = MultiRule.combine(iSchedulingRule, (ISchedulingRule)iResourceRuleFactory.modifyRule((IResource)iProject));
        }
        this.runInBackground(iSchedulingRule);
    }

    boolean saveDirtyEditors() {
        List list = this.getSelectedResources();
        if (list == null || list.isEmpty()) {
            return false;
        }
        final List list2 = this.getDirtyEditors(list);
        final List list3 = this.getEditorsToSave(list2);
        if (list3 == null) {
            return false;
        }
        Shell shell = this.getShell();
        Display display = shell == null ? PlatformUI.getWorkbench().getDisplay() : shell.getDisplay();
        BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

            public void run() {
                Iterator iterator = list2.iterator();
                while (iterator.hasNext()) {
                    IEditorPart iEditorPart = (IEditorPart)iterator.next();
                    IWorkbenchPage iWorkbenchPage = iEditorPart.getEditorSite().getPage();
                    if (list3.contains(iEditorPart)) {
                        iEditorPart.doSave((IProgressMonitor)new NullProgressMonitor());
                    }
                    iWorkbenchPage.closeEditor(iEditorPart, false);
                }
            }
        });
        return true;
    }

    protected boolean shouldPerformResourcePruning() {
        return false;
    }

    protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
        if (!this.selectionIsOfType(4)) {
            return false;
        }
        Iterator iterator = this.getSelectedResources().iterator();
        while (iterator.hasNext()) {
            IProject iProject = (IProject)iterator.next();
            if (!iProject.isOpen()) continue;
            return true;
        }
        return false;
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        IResourceDelta iResourceDelta;
        List list = this.getSelectedResources();
        if (this.selectionIsOfType(4) && (iResourceDelta = iResourceChangeEvent.getDelta()) != null) {
            IResourceDelta[] iResourceDeltaArray = iResourceDelta.getAffectedChildren(4);
            int n = 0;
            while (n < iResourceDeltaArray.length) {
                IResourceDelta iResourceDelta2 = iResourceDeltaArray[n];
                if ((iResourceDelta2.getFlags() & 0x4000) != 0 && list.contains(iResourceDelta2.getResource())) {
                    this.selectionChanged(this.getStructuredSelection());
                    return;
                }
                ++n;
            }
        }
    }

    public String[] getModelProviderIds() {
        return this.modelProviderIds;
    }

    public void setModelProviderIds(String[] stringArray) {
        this.modelProviderIds = stringArray;
    }

    private boolean validateClose() {
        IResourceChangeDescriptionFactory iResourceChangeDescriptionFactory = ResourceChangeValidator.getValidator().createDeltaFactory();
        List list = this.getActionResources();
        Object object = list.iterator();
        while (object.hasNext()) {
            IResource iResource = (IResource)object.next();
            if (!(iResource instanceof IProject)) continue;
            IProject iProject = (IProject)iResource;
            iResourceChangeDescriptionFactory.close(iProject);
        }
        object = list.size() == 1 ? NLS.bind((String)IDEWorkbenchMessages.CloseResourceAction_warningForOne, (Object)((IResource)list.get(0)).getName()) : IDEWorkbenchMessages.CloseResourceAction_warningForMultiple;
        return IDE.promptToConfirm(this.getShell(), IDEWorkbenchMessages.CloseResourceAction_confirm, (String)object, iResourceChangeDescriptionFactory.getDelta(), this.getModelProviderIds(), false);
    }
}

