/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CloseResourceAction;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.misc.DisjointSet;

public class CloseUnrelatedProjectsAction
extends CloseResourceAction {
    public static final String ID = "org.eclipse.ui.CloseUnrelatedProjectsAction";
    private final List projectsToClose = new ArrayList();
    private boolean selectionDirty = true;
    private List oldSelection = Collections.EMPTY_LIST;

    private static DisjointSet buildConnectedComponents(IProject[] iProjectArray) {
        DisjointSet disjointSet = new DisjointSet();
        int n = 0;
        while (n < iProjectArray.length) {
            disjointSet.makeSet(iProjectArray[n]);
            ++n;
        }
        n = 0;
        while (n < iProjectArray.length) {
            try {
                IProject[] iProjectArray2 = iProjectArray[n].getReferencedProjects();
                int n2 = 0;
                while (n2 < iProjectArray2.length) {
                    Object object = disjointSet.findSet(iProjectArray[n]);
                    Object object2 = disjointSet.findSet(iProjectArray2[n2]);
                    if (object != null && object2 != null && object != object2) {
                        disjointSet.union(object, object2);
                    }
                    ++n2;
                }
            }
            catch (CoreException coreException) {}
            ++n;
        }
        return disjointSet;
    }

    public CloseUnrelatedProjectsAction(Shell shell) {
        super(shell, IDEWorkbenchMessages.CloseUnrelatedProjectsAction_text);
        this.initAction();
    }

    public CloseUnrelatedProjectsAction(IShellProvider iShellProvider) {
        super(iShellProvider, IDEWorkbenchMessages.CloseUnrelatedProjectsAction_text);
        this.initAction();
    }

    private void initAction() {
        this.setId(ID);
        this.setToolTipText(IDEWorkbenchMessages.CloseUnrelatedProjectsAction_toolTip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.close_unrelated_projects_action_context");
    }

    protected void clearCache() {
        super.clearCache();
        this.oldSelection = Collections.EMPTY_LIST;
        this.selectionDirty = true;
    }

    private void computeRelated(List list) {
        DisjointSet disjointSet = CloseUnrelatedProjectsAction.buildConnectedComponents(ResourcesPlugin.getWorkspace().getRoot().getProjects());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            disjointSet.removeSet(iterator.next());
        }
        this.projectsToClose.clear();
        disjointSet.toList(this.projectsToClose);
    }

    protected List getSelectedResources() {
        if (this.selectionDirty) {
            List list = super.getSelectedResources();
            if (!this.oldSelection.equals(list)) {
                this.oldSelection = list;
                this.computeRelated(list);
            }
            this.selectionDirty = false;
        }
        return this.projectsToClose;
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        IResourceDelta iResourceDelta;
        if (this.selectionIsOfType(4) && (iResourceDelta = iResourceChangeEvent.getDelta()) != null) {
            IResourceDelta[] iResourceDeltaArray = iResourceDelta.getAffectedChildren(4);
            int n = 0;
            while (n < iResourceDeltaArray.length) {
                IResourceDelta iResourceDelta2 = iResourceDeltaArray[n];
                if ((iResourceDelta2.getFlags() & 0x84000) != 0) {
                    this.selectionChanged(this.getStructuredSelection());
                    return;
                }
                ++n;
            }
        }
    }
}

