/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.ide.undo.AbstractWorkspaceOperation;
import org.eclipse.ui.ide.undo.CopyResourcesOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.ide.dialogs.IDEResourceInfoUtils;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.wizards.datatransfer.FileStoreStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class CopyFilesAndFoldersOperation {
    private MultiStatus errorStatus;
    private Shell messageShell;
    private boolean canceled = false;
    private boolean createGroupsAndLinks = false;
    private boolean createLinks = false;
    private String relativeVariable = null;
    private boolean alwaysOverwrite = false;
    private String[] modelProviderIds;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static IPath getAutoNewNameFor(IPath iPath, IWorkspace iWorkspace) {
        int n = 1;
        String string = iPath.lastSegment();
        IPath iPath2 = iPath.removeLastSegments(1);
        while (true) {
            String string2 = n > 1 ? NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_copyNameTwoArgs, (Object)new Integer(n), (Object)string) : NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_copyNameOneArg, (Object)string);
            IPath iPath3 = iPath2.append(string2);
            if (!iWorkspace.getRoot().exists(iPath3)) {
                return iPath3;
            }
            ++n;
        }
    }

    public CopyFilesAndFoldersOperation(Shell shell) {
        this.messageShell = shell;
    }

    protected boolean canPerformAutoRename() {
        return true;
    }

    protected String getDeepCheckQuestion(IResource iResource) {
        return NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_deepCopyQuestion, (Object)iResource.getFullPath().makeRelative());
    }

    IStatus checkExist(IFileStore[] iFileStoreArray) {
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, this.getProblemsMessage(), null);
        int n = 0;
        while (n < iFileStoreArray.length) {
            if (!iFileStoreArray[n].fetchInfo().exists()) {
                String string = NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_resourceDeleted, (Object)iFileStoreArray[n].getName());
                Status status = new Status(4, "org.eclipse.ui", 0, string, null);
                multiStatus.add((IStatus)status);
            }
            ++n;
        }
        return multiStatus;
    }

    IStatus checkExist(IResource[] iResourceArray) {
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, this.getProblemsMessage(), null);
        int n = 0;
        while (n < iResourceArray.length) {
            IResource iResource = iResourceArray[n];
            if (iResource != null && !iResource.isGroup()) {
                IFileInfo iFileInfo;
                URI uRI = iResource.getLocationURI();
                String string = null;
                if (!(uRI == null || (iFileInfo = IDEResourceInfoUtils.getFileInfo(uRI)) != null && iFileInfo.exists())) {
                    string = iResource.isLinked() ? NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_missingLinkTarget, (Object)iResource.getName()) : NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_resourceDeleted, (Object)iResource.getName());
                }
                if (string != null) {
                    iFileInfo = new Status(4, "org.eclipse.ui", 0, string, null);
                    multiStatus.add((IStatus)iFileInfo);
                }
            }
            ++n;
        }
        return multiStatus;
    }

    private int checkOverwrite(final IResource iResource, final IResource iResource2) {
        final int[] nArray = new int[1];
        Runnable runnable = new Runnable(){

            public void run() {
                MessageDialog messageDialog;
                String string;
                int[] nArray2 = new int[]{2, 4, 3, 1};
                String[] stringArray = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
                if (iResource2.getType() == 2) {
                    if (CopyFilesAndFoldersOperation.this.homogenousResources(iResource, iResource2)) {
                        string = NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_overwriteMergeQuestion, (Object)iResource2.getFullPath().makeRelative());
                    } else {
                        string = iResource2.isLinked() ? NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_overwriteNoMergeLinkQuestion, (Object)iResource2.getFullPath().makeRelative()) : NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_overwriteNoMergeNoLinkQuestion, (Object)iResource2.getFullPath().makeRelative());
                        nArray2 = new int[]{2, 3, 1};
                        stringArray = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
                    }
                } else {
                    messageDialog = new MessageDialog[]{IDEResourceInfoUtils.getLocationText(iResource2), IDEResourceInfoUtils.getDateStringValue(iResource2), IDEResourceInfoUtils.getLocationText(iResource), IDEResourceInfoUtils.getDateStringValue(iResource)};
                    string = NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_overwriteWithDetailsQuestion, (Object[])messageDialog);
                }
                messageDialog = new MessageDialog(CopyFilesAndFoldersOperation.this.messageShell, IDEWorkbenchMessages.CopyFilesAndFoldersOperation_resourceExists, null, string, 3, stringArray, 0);
                messageDialog.open();
                nArray[0] = messageDialog.getReturnCode() == -1 ? 1 : nArray2[messageDialog.getReturnCode()];
            }
        };
        this.messageShell.getDisplay().syncExec(runnable);
        return nArray[0];
    }

    private void collectExistingReadonlyFiles(IPath iPath, IResource[] iResourceArray, ArrayList arrayList) {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        int n = 0;
        while (n < iResourceArray.length) {
            IResource iResource = iResourceArray[n];
            IPath iPath2 = iPath.append(iResource.getName());
            IResource iResource2 = iWorkspaceRoot.findMember(iPath2);
            if (iResource2 != null) {
                IFolder iFolder;
                IFolder iFolder2 = this.getFolder(iResource2);
                if (iFolder2 != null) {
                    iFolder = this.getFolder(iResource);
                    if (iFolder != null) {
                        try {
                            this.collectExistingReadonlyFiles(iPath2, iFolder.members(), arrayList);
                        }
                        catch (CoreException coreException) {
                            this.recordError(coreException);
                        }
                    }
                } else {
                    iFolder = this.getFile(iResource2);
                    if (iFolder != null) {
                        IFile iFile;
                        if (iFolder.isReadOnly()) {
                            arrayList.add(iFolder);
                        }
                        if (this.getValidateConflictSource() && (iFile = this.getFile(iResource)) != null) {
                            arrayList.add(iFile);
                        }
                    }
                }
            }
            ++n;
        }
    }

    protected void copy(IResource[] iResourceArray, IPath iPath, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor.beginTask(IDEWorkbenchMessages.CopyFilesAndFoldersOperation_CopyResourcesTask, iResourceArray.length);
        int n = 0;
        while (n < iResourceArray.length) {
            IFile iFile;
            IResource iResource = iResourceArray[n];
            IPath iPath2 = iPath.append(iResource.getName());
            IWorkspace iWorkspace = iResource.getWorkspace();
            IWorkspaceRoot iWorkspaceRoot = iWorkspace.getRoot();
            IResource iResource2 = iWorkspaceRoot.findMember(iPath2);
            if (iResource.getType() == 2 && iResource2 != null) {
                if (this.homogenousResources(iResource, iResource2)) {
                    iFile = ((IContainer)iResource).members();
                    this.copy((IResource[])iFile, iPath2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                } else {
                    this.delete(iResource2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 0));
                    iResource.copy(iPath2, 32, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                }
            } else {
                if (iResource2 != null && this.homogenousResources(iResource, iResource2)) {
                    this.copyExisting(iResource, iResource2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                } else {
                    if (iResource2 != null) {
                        this.delete(iResource2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 0));
                    }
                    if ((this.createLinks || this.createGroupsAndLinks) && !iResource.isLinked() && !iResource.isGroup()) {
                        if (iResource.getType() == 1) {
                            iFile = iWorkspaceRoot.getFile(iPath2);
                            iFile.createLink(this.createRelativePath(iFile.getProject().getPathVariableManager(), iResource.getLocationURI()), 0, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                        } else {
                            iFile = iWorkspaceRoot.getFolder(iPath2);
                            if (this.createGroupsAndLinks) {
                                iFile.createGroup(0, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                                IResource[] iResourceArray2 = ((IContainer)iResource).members();
                                if (iResourceArray2.length > 0) {
                                    this.copy(iResourceArray2, iPath2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                                }
                            } else {
                                iFile.createLink(this.createRelativePath(iFile.getProject().getPathVariableManager(), iResource.getLocationURI()), 0, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                            }
                        }
                    } else {
                        iResource.copy(iPath2, 32, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                    }
                }
                if (iProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
            }
            ++n;
        }
    }

    private URI createRelativePath(IPathVariableManager iPathVariableManager, URI uRI) {
        IPath iPath;
        if (this.relativeVariable == null) {
            return uRI;
        }
        IPath iPath2 = URIUtil.toPath((URI)uRI);
        try {
            iPath = iPathVariableManager.convertToRelative(iPath2, true, this.relativeVariable);
        }
        catch (CoreException coreException) {
            return uRI;
        }
        return URIUtil.toURI((IPath)iPath);
    }

    private void copyExisting(IResource iResource, IResource iResource2, IProgressMonitor iProgressMonitor) throws CoreException {
        IFile iFile;
        IFile iFile2 = this.getFile(iResource2);
        if (iFile2 != null && (iFile = this.getFile(iResource)) != null) {
            iFile2.setContents(iFile.getContents(), 2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 0));
        }
    }

    public IResource[] copyResources(IResource[] iResourceArray, IContainer iContainer) {
        return this.copyResources(iResourceArray, iContainer, true, null);
    }

    public IResource[] copyResourcesInCurrentThread(IResource[] iResourceArray, IContainer iContainer, IProgressMonitor iProgressMonitor) {
        return this.copyResources(iResourceArray, iContainer, false, iProgressMonitor);
    }

    private IResource[] copyResources(final IResource[] iResourceArray, IContainer iContainer, boolean bl, IProgressMonitor iProgressMonitor) {
        final IPath iPath = iContainer.getFullPath();
        final IResource[][] iResourceArray2 = new IResource[1][0];
        IStatus iStatus = this.checkExist(iResourceArray);
        if (iStatus.getSeverity() != 0) {
            this.displayError(iStatus);
            return iResourceArray2[0];
        }
        String string = this.validateDestination(iContainer, iResourceArray);
        if (string != null) {
            this.displayError(string);
            return iResourceArray2[0];
        }
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) {
                CopyFilesAndFoldersOperation.this.copyResources(iResourceArray, iPath, iResourceArray2, iProgressMonitor);
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(bl, true, iRunnableWithProgress);
        }
        catch (InterruptedException interruptedException) {
            return iResourceArray2[0];
        }
        catch (InvocationTargetException invocationTargetException) {
            this.display(invocationTargetException);
        }
        if (this.errorStatus != null) {
            this.displayError((IStatus)this.errorStatus);
            this.errorStatus = null;
        }
        return iResourceArray2[0];
    }

    protected boolean isMove() {
        return false;
    }

    private void display(InvocationTargetException invocationTargetException) {
        IDEWorkbenchPlugin.getDefault().getLog().log(StatusUtil.newStatus(4, MessageFormat.format((String)"Exception in {0}.performCopy(): {1}", (Object[])new Object[]{this.getClass().getName(), invocationTargetException.getTargetException()}), null));
        this.displayError(NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_internalError, (Object)invocationTargetException.getTargetException().getMessage()));
    }

    public void copyFiles(URI[] uRIArray, IContainer iContainer) {
        IFileStore[] iFileStoreArray = this.buildFileStores(uRIArray);
        if (iFileStoreArray == null) {
            return;
        }
        this.copyFileStores(iContainer, iFileStoreArray, true, null);
    }

    public void copyFilesInCurrentThread(URI[] uRIArray, IContainer iContainer, IProgressMonitor iProgressMonitor) {
        IFileStore[] iFileStoreArray = this.buildFileStores(uRIArray);
        if (iFileStoreArray == null) {
            return;
        }
        this.copyFileStores(iContainer, iFileStoreArray, false, iProgressMonitor);
    }

    private IFileStore[] buildFileStores(URI[] uRIArray) {
        IFileStore[] iFileStoreArray = new IFileStore[uRIArray.length];
        int n = 0;
        while (n < uRIArray.length) {
            IFileStore iFileStore;
            try {
                iFileStore = EFS.getStore((URI)uRIArray[n]);
            }
            catch (CoreException coreException) {
                StatusManager.getManager().handle(coreException, "org.eclipse.ui.ide");
                this.reportFileInfoNotFound(uRIArray[n].toString());
                return null;
            }
            if (iFileStore == null) {
                this.reportFileInfoNotFound(uRIArray[n].toString());
                return null;
            }
            iFileStoreArray[n] = iFileStore;
            ++n;
        }
        return iFileStoreArray;
    }

    public void copyFiles(String[] stringArray, IContainer iContainer) {
        IFileStore[] iFileStoreArray = this.buildFileStores(stringArray);
        if (iFileStoreArray == null) {
            return;
        }
        this.copyFileStores(iContainer, iFileStoreArray, true, null);
    }

    public void copyFilesInCurrentThread(String[] stringArray, IContainer iContainer, IProgressMonitor iProgressMonitor) {
        IFileStore[] iFileStoreArray = this.buildFileStores(stringArray);
        if (iFileStoreArray == null) {
            return;
        }
        this.copyFileStores(iContainer, iFileStoreArray, false, iProgressMonitor);
    }

    private IFileStore[] buildFileStores(String[] stringArray) {
        IFileStore[] iFileStoreArray = new IFileStore[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            IFileStore iFileStore = IDEResourceInfoUtils.getFileStore(stringArray[n]);
            if (iFileStore == null) {
                this.reportFileInfoNotFound(stringArray[n]);
                return null;
            }
            iFileStoreArray[n] = iFileStore;
            ++n;
        }
        return iFileStoreArray;
    }

    private void reportFileInfoNotFound(final String string) {
        this.messageShell.getDisplay().syncExec(new Runnable(){

            public void run() {
                ErrorDialog.openError((Shell)CopyFilesAndFoldersOperation.this.messageShell, (String)CopyFilesAndFoldersOperation.this.getProblemsTitle(), (String)NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_infoNotFound, (Object)string), null);
            }
        });
    }

    private void copyFileStores(IContainer iContainer, final IFileStore[] iFileStoreArray, boolean bl, IProgressMonitor iProgressMonitor) {
        IStatus iStatus = this.checkExist(iFileStoreArray);
        if (iStatus.getSeverity() != 0) {
            this.displayError(iStatus);
            return;
        }
        String string = this.validateImportDestinationInternal(iContainer, iFileStoreArray);
        if (string != null) {
            this.displayError(string);
            return;
        }
        final IPath iPath = iContainer.getFullPath();
        if (bl) {
            WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

                public void execute(IProgressMonitor iProgressMonitor) {
                    CopyFilesAndFoldersOperation.this.copyFileStores(iFileStoreArray, iPath, iProgressMonitor);
                }
            };
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)workspaceModifyOperation);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            catch (InvocationTargetException invocationTargetException) {
                this.display(invocationTargetException);
            }
        } else {
            this.copyFileStores(iFileStoreArray, iPath, iProgressMonitor);
        }
        if (this.errorStatus != null) {
            this.displayError((IStatus)this.errorStatus);
            this.errorStatus = null;
        }
    }

    private void displayError(final IStatus iStatus) {
        this.messageShell.getDisplay().syncExec(new Runnable(){

            public void run() {
                ErrorDialog.openError((Shell)CopyFilesAndFoldersOperation.this.messageShell, (String)CopyFilesAndFoldersOperation.this.getProblemsTitle(), null, (IStatus)iStatus);
            }
        });
    }

    IResource createLinkedResourceHandle(IContainer iContainer, IResource iResource) {
        IWorkspace iWorkspace = iContainer.getWorkspace();
        IWorkspaceRoot iWorkspaceRoot = iWorkspace.getRoot();
        IPath iPath = iContainer.getFullPath().append(iResource.getName());
        Object object = iResource.getType() == 2 ? iWorkspaceRoot.getFolder(iPath) : iWorkspaceRoot.getFile(iPath);
        return object;
    }

    boolean delete(IResource iResource, IProgressMonitor iProgressMonitor) {
        boolean bl = false;
        if (iResource.getType() == 4) {
            IProject iProject = (IProject)iResource;
            try {
                iProject.delete(true, bl, iProgressMonitor);
            }
            catch (CoreException coreException) {
                this.recordError(coreException);
                return false;
            }
        }
        int n = 2;
        if (bl) {
            n |= 1;
        }
        try {
            iResource.delete(n, iProgressMonitor);
        }
        catch (CoreException coreException) {
            this.recordError(coreException);
            return false;
        }
        return true;
    }

    private void displayError(final String string) {
        this.messageShell.getDisplay().syncExec(new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)CopyFilesAndFoldersOperation.this.messageShell, (String)CopyFilesAndFoldersOperation.this.getProblemsTitle(), (String)string);
            }
        });
    }

    protected IFile getFile(IResource iResource) {
        if (iResource instanceof IFile) {
            return (IFile)iResource;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IFile)iResource.getAdapter((Class)clazz);
    }

    protected File[] getFiles(String[] stringArray) {
        File[] fileArray = new File[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            fileArray[n] = new File(stringArray[n]);
            ++n;
        }
        return fileArray;
    }

    protected IFolder getFolder(IResource iResource) {
        if (iResource instanceof IFolder) {
            return (IFolder)iResource;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.core.resources.IFolder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IFolder)iResource.getAdapter((Class)clazz);
    }

    private IPath getNewNameFor(final IPath iPath, final IWorkspace iWorkspace) {
        final IResource iResource = iWorkspace.getRoot().findMember(iPath);
        final IPath iPath2 = iResource.getFullPath().removeLastSegments(1);
        final String[] stringArray = new String[]{""};
        this.messageShell.getDisplay().syncExec(new Runnable(){

            public void run() {
                IInputValidator iInputValidator = new IInputValidator(this, iResource, iWorkspace, iPath2){
                    final /* synthetic */ 7 this$1;
                    private final /* synthetic */ IResource val$resource;
                    private final /* synthetic */ IWorkspace val$workspace;
                    private final /* synthetic */ IPath val$prefix;
                    {
                        this.this$1 = var1_1;
                        this.val$resource = iResource;
                        this.val$workspace = iWorkspace;
                        this.val$prefix = iPath;
                    }

                    public String isValid(String string) {
                        if (this.val$resource.getName().equals(string)) {
                            return IDEWorkbenchMessages.CopyFilesAndFoldersOperation_nameMustBeDifferent;
                        }
                        IStatus iStatus = this.val$workspace.validateName(string, this.val$resource.getType());
                        if (!iStatus.isOK()) {
                            return iStatus.getMessage();
                        }
                        if (this.val$workspace.getRoot().exists(this.val$prefix.append(string))) {
                            return IDEWorkbenchMessages.CopyFilesAndFoldersOperation_nameExists;
                        }
                        return null;
                    }
                };
                InputDialog inputDialog = new InputDialog(CopyFilesAndFoldersOperation.this.messageShell, IDEWorkbenchMessages.CopyFilesAndFoldersOperation_inputDialogTitle, NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_inputDialogMessage, (Object)iResource.getName()), CopyFilesAndFoldersOperation.getAutoNewNameFor(iPath, iWorkspace).lastSegment().toString(), iInputValidator);
                inputDialog.setBlockOnOpen(true);
                inputDialog.open();
                stringArray[0] = inputDialog.getReturnCode() == 1 ? null : inputDialog.getValue();
            }
        });
        if (stringArray[0] == null) {
            throw new OperationCanceledException();
        }
        return iPath2.append(stringArray[0]);
    }

    protected String getOperationTitle() {
        return IDEWorkbenchMessages.CopyFilesAndFoldersOperation_operationTitle;
    }

    protected String getProblemsMessage() {
        return IDEWorkbenchMessages.CopyFilesAndFoldersOperation_problemMessage;
    }

    protected String getProblemsTitle() {
        return IDEWorkbenchMessages.CopyFilesAndFoldersOperation_copyFailedTitle;
    }

    protected boolean getValidateConflictSource() {
        return false;
    }

    protected boolean homogenousResources(IResource iResource, IResource iResource2) {
        boolean bl = iResource.isLinked();
        boolean bl2 = iResource2.isLinked();
        return bl && bl2 || !bl && !bl2;
    }

    private boolean isAccessible(IResource iResource) {
        switch (iResource.getType()) {
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 4: {
                return ((IProject)iResource).isOpen();
            }
        }
        return false;
    }

    boolean isDestinationSameAsSource(IResource[] iResourceArray, IContainer iContainer) {
        IPath iPath = iContainer.getLocation();
        int n = 0;
        while (n < iResourceArray.length) {
            IResource iResource = iResourceArray[n];
            if (iResource.getParent().equals((Object)iContainer)) {
                return true;
            }
            if (iPath != null) {
                IPath iPath2 = iResource.getLocation();
                IPath iPath3 = iPath.append(iResource.getName());
                if (iPath2 != null && iPath2.isPrefixOf(iPath3)) {
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    private boolean performCopy(IResource[] iResourceArray, IPath iPath, IProgressMonitor iProgressMonitor) {
        try {
            AbstractWorkspaceOperation abstractWorkspaceOperation = this.getUndoableCopyOrMoveOperation(iResourceArray, iPath);
            abstractWorkspaceOperation.setModelProviderIds(this.getModelProviderIds());
            if (abstractWorkspaceOperation instanceof CopyResourcesOperation) {
                CopyResourcesOperation copyResourcesOperation = (CopyResourcesOperation)abstractWorkspaceOperation;
                copyResourcesOperation.setCreateGroups(this.createGroupsAndLinks);
                copyResourcesOperation.setCreateLinks(this.createLinks);
                copyResourcesOperation.setRelativeVariable(this.relativeVariable);
            }
            PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)abstractWorkspaceOperation, iProgressMonitor, WorkspaceUndoUtil.getUIInfoAdapter(this.messageShell));
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof CoreException) {
                this.recordError((CoreException)executionException.getCause());
            } else {
                IDEWorkbenchPlugin.log(executionException.getMessage(), executionException);
                this.displayError(executionException.getMessage());
            }
            return false;
        }
        return true;
    }

    private boolean performCopyWithAutoRename(IResource[] iResourceArray, IPath iPath, IProgressMonitor iProgressMonitor) {
        IWorkspace iWorkspace = iResourceArray[0].getWorkspace();
        IPath[] iPathArray = new IPath[iResourceArray.length];
        try {
            int n = 0;
            while (n < iResourceArray.length) {
                IResource iResource = iResourceArray[n];
                iPathArray[n] = iPath.append(iResource.getName());
                if (iWorkspace.getRoot().exists(iPathArray[n])) {
                    iPathArray[n] = this.getNewNameFor(iPathArray[n], iWorkspace);
                }
                ++n;
            }
            CopyResourcesOperation copyResourcesOperation = new CopyResourcesOperation(iResourceArray, iPathArray, IDEWorkbenchMessages.CopyFilesAndFoldersOperation_copyTitle);
            copyResourcesOperation.setModelProviderIds(this.getModelProviderIds());
            PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)copyResourcesOperation, iProgressMonitor, WorkspaceUndoUtil.getUIInfoAdapter(this.messageShell));
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof CoreException) {
                this.recordError((CoreException)executionException.getCause());
            } else {
                IDEWorkbenchPlugin.log(executionException.getMessage(), executionException);
                this.displayError(executionException.getMessage());
            }
            return false;
        }
        return true;
    }

    private void performFileImport(IFileStore[] iFileStoreArray, IContainer iContainer, IProgressMonitor iProgressMonitor) {
        IOverwriteQuery iOverwriteQuery = new IOverwriteQuery(){

            public String queryOverwrite(String string) {
                if (CopyFilesAndFoldersOperation.this.alwaysOverwrite) {
                    return "ALL";
                }
                String[] stringArray = new String[]{"CANCEL"};
                String string2 = NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_overwriteQuestion, (Object)string);
                String[] stringArray2 = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
                CopyFilesAndFoldersOperation.this.messageShell.getDisplay().syncExec(new Runnable(this, string2, stringArray2, stringArray){
                    final /* synthetic */ 9 this$1;
                    private final /* synthetic */ String val$msg;
                    private final /* synthetic */ String[] val$options;
                    private final /* synthetic */ String[] val$returnCode;
                    {
                        this.this$1 = var1_1;
                        this.val$msg = string;
                        this.val$options = stringArray;
                        this.val$returnCode = stringArray2;
                    }

                    public void run() {
                        MessageDialog messageDialog = new MessageDialog(CopyFilesAndFoldersOperation.access$0(9.access$0(this.this$1)), IDEWorkbenchMessages.CopyFilesAndFoldersOperation_question, null, this.val$msg, 3, this.val$options, 0);
                        messageDialog.open();
                        int n = messageDialog.getReturnCode();
                        String[] stringArray = new String[]{"YES", "ALL", "NO", "CANCEL"};
                        this.val$returnCode[0] = n == -1 ? "CANCEL" : stringArray[n];
                    }
                });
                if (stringArray[0] == "ALL") {
                    CopyFilesAndFoldersOperation.this.alwaysOverwrite = true;
                } else if (stringArray[0] == "CANCEL") {
                    CopyFilesAndFoldersOperation.this.canceled = true;
                }
                return stringArray[0];
            }

            static /* synthetic */ CopyFilesAndFoldersOperation access$0(9 var0) {
                return var0.CopyFilesAndFoldersOperation.this;
            }
        };
        ImportOperation importOperation = new ImportOperation(iContainer.getFullPath(), iFileStoreArray[0].getParent(), FileStoreStructureProvider.INSTANCE, iOverwriteQuery, Arrays.asList(iFileStoreArray));
        importOperation.setContext(this.messageShell);
        importOperation.setCreateContainerStructure(false);
        importOperation.setCreateGroups(this.createGroupsAndLinks);
        importOperation.setCreateLinks(this.createLinks);
        importOperation.setRelativeVariable(this.relativeVariable);
        try {
            importOperation.run(iProgressMonitor);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof CoreException) {
                this.displayError(((CoreException)invocationTargetException.getTargetException()).getStatus());
            } else {
                this.display(invocationTargetException);
            }
            return;
        }
        IStatus iStatus = importOperation.getStatus();
        if (!iStatus.isOK()) {
            if (this.errorStatus == null) {
                this.errorStatus = new MultiStatus("org.eclipse.ui", 4, this.getProblemsMessage(), null);
            }
            this.errorStatus.merge(iStatus);
        }
    }

    private void recordError(CoreException coreException) {
        if (this.errorStatus == null) {
            this.errorStatus = new MultiStatus("org.eclipse.ui", 4, this.getProblemsMessage(), (Throwable)coreException);
        }
        this.errorStatus.merge(coreException.getStatus());
    }

    public String validateDestination(IContainer iContainer, IResource[] iResourceArray) {
        if (!this.isAccessible((IResource)iContainer)) {
            return IDEWorkbenchMessages.CopyFilesAndFoldersOperation_destinationAccessError;
        }
        IContainer iContainer2 = null;
        URI uRI = iContainer.getLocationURI();
        int n = 0;
        while (n < iResourceArray.length) {
            String string;
            IResource iResource = iResourceArray[n];
            if (iContainer2 == null) {
                iContainer2 = iResource.getParent();
            } else if (!iContainer2.equals((Object)iResource.getParent())) {
                return IDEWorkbenchMessages.CopyFilesAndFoldersOperation_parentNotEqual;
            }
            if (!(!iContainer.isGroup() || iResource.isLinked() || iResource.isGroup() || this.createLinks || this.createGroupsAndLinks)) {
                return NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_sourceCannotBeCopiedIntoAGroup, (Object)iResource.getName());
            }
            URI uRI2 = iResource.getLocationURI();
            if (uRI2 == null) {
                if (iResource.isLinked()) {
                    return NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_missingPathVariable, (Object)iResource.getName());
                }
                return NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_resourceDeleted, (Object)iResource.getName());
            }
            if (!iContainer.isGroup()) {
                if (uRI2.equals(uRI)) {
                    return NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_sameSourceAndDest, (Object)iResource.getName());
                }
                if (new Path(uRI2.toString()).isPrefixOf((IPath)new Path(uRI.toString()))) {
                    return IDEWorkbenchMessages.CopyFilesAndFoldersOperation_destinationDescendentError;
                }
            }
            if ((string = this.validateLinkedResource(iContainer, iResource)) != null) {
                return string;
            }
            ++n;
        }
        return null;
    }

    private boolean validateEdit(IContainer iContainer, IResource[] iResourceArray) {
        ArrayList arrayList = new ArrayList();
        this.collectExistingReadonlyFiles(iContainer.getFullPath(), iResourceArray, arrayList);
        if (arrayList.size() > 0) {
            IFile[] iFileArray = arrayList.toArray(new IFile[arrayList.size()]);
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            IStatus iStatus = iWorkspace.validateEdit(iFileArray, (Object)this.messageShell);
            this.canceled = !iStatus.isOK();
            return iStatus.isOK();
        }
        return true;
    }

    public String validateImportDestination(IContainer iContainer, String[] stringArray) {
        IFileStore[] iFileStoreArray = new IFileStore[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            IFileStore iFileStore = IDEResourceInfoUtils.getFileStore(stringArray[n]);
            if (iFileStore == null) {
                return NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_infoNotFound, (Object)stringArray[n]);
            }
            iFileStoreArray[n] = iFileStore;
            ++n;
        }
        return this.validateImportDestinationInternal(iContainer, iFileStoreArray);
    }

    private String validateImportDestinationInternal(IContainer iContainer, IFileStore[] iFileStoreArray) {
        if (!this.isAccessible((IResource)iContainer)) {
            return IDEWorkbenchMessages.CopyFilesAndFoldersOperation_destinationAccessError;
        }
        if (!iContainer.isGroup()) {
            IFileStore iFileStore;
            try {
                iFileStore = EFS.getStore((URI)iContainer.getLocationURI());
            }
            catch (CoreException coreException) {
                IDEWorkbenchPlugin.log(coreException.getLocalizedMessage(), coreException);
                return NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_internalError, (Object)coreException.getLocalizedMessage());
            }
            int n = 0;
            while (n < iFileStoreArray.length) {
                IFileStore iFileStore2 = iFileStoreArray[n];
                IFileStore iFileStore3 = iFileStore2.getParent();
                if (iFileStore2 != null) {
                    if (iFileStore.equals(iFileStore2) || iFileStore3 != null && iFileStore.equals(iFileStore3)) {
                        return NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_importSameSourceAndDest, (Object)iFileStore2.getName());
                    }
                    IFileStore iFileStore4 = iFileStore.getParent();
                    if (iFileStore2.isParentOf(iFileStore4)) {
                        return IDEWorkbenchMessages.CopyFilesAndFoldersOperation_destinationDescendentError;
                    }
                }
                ++n;
            }
        }
        return null;
    }

    private String validateLinkedResource(IContainer iContainer, IResource iResource) {
        IResource iResource2;
        if (!iResource.isLinked() || iResource.isGroup()) {
            return null;
        }
        IWorkspace iWorkspace = iContainer.getWorkspace();
        IStatus iStatus = iWorkspace.validateLinkLocation(iResource2 = this.createLinkedResourceHandle(iContainer, iResource), iResource.getRawLocation());
        if (iStatus.getSeverity() == 4) {
            return iStatus.getMessage();
        }
        IPath iPath = iResource.getLocation();
        if (!iResource.getProject().equals((Object)iContainer.getProject()) && iResource.getType() == 2 && iPath != null) {
            try {
                IResource[] iResourceArray = iContainer.members();
                int n = 0;
                while (n < iResourceArray.length) {
                    if (iPath.equals((Object)iResourceArray[n].getLocation()) && iResource.getName().equals(iResourceArray[n].getName())) {
                        return NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_sameSourceAndDest, (Object)iResource.getName());
                    }
                    ++n;
                }
            }
            catch (CoreException coreException) {
                this.displayError(NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_internalError, (Object)coreException.getMessage()));
            }
        }
        return null;
    }

    private IResource[] validateNoNameCollisions(IContainer iContainer, IResource[] iResourceArray) {
        IPath iPath;
        IPath iPath2;
        IResource iResource;
        ArrayList<IResource> arrayList = new ArrayList<IResource>();
        IWorkspaceRoot iWorkspaceRoot = iContainer.getWorkspace().getRoot();
        int n = 3;
        int n2 = 0;
        while (n2 < iResourceArray.length) {
            iResource = iResourceArray[n2];
            iPath2 = iContainer.getFullPath().append(iResource.getName());
            iPath = iResource.getFullPath();
            IResource iResource2 = iWorkspaceRoot.findMember(iPath2);
            if (iResource2 != null && iPath2.isPrefixOf(iPath)) {
                this.displayError(NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_overwriteProblem, (Object)iPath2, (Object)iPath));
                this.canceled = true;
                return null;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < iResourceArray.length) {
            iResource = iResourceArray[n2];
            iPath2 = iContainer.getFullPath().append(iResource.getName());
            iPath = iWorkspaceRoot.findMember(iPath2);
            if (iPath != null) {
                if (n != 4 || iPath.getType() == 2 && !this.homogenousResources(iResource, (IResource)iContainer)) {
                    n = this.checkOverwrite(iResource, (IResource)iPath);
                }
                if (n == 2 || n == 4) {
                    arrayList.add(iResource);
                } else if (n == 1) {
                    this.canceled = true;
                    return null;
                }
            } else {
                arrayList.add(iResource);
            }
            ++n2;
        }
        return arrayList.toArray(new IResource[arrayList.size()]);
    }

    private void copyResources(IResource[] iResourceArray, IPath iPath, IResource[][] iResourceArray2, IProgressMonitor iProgressMonitor) {
        IResource[] iResourceArray3 = iResourceArray;
        iProgressMonitor.beginTask("", 100);
        iProgressMonitor.setTaskName(this.getOperationTitle());
        iProgressMonitor.worked(10);
        boolean bl = false;
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (iWorkspaceRoot.exists(iPath)) {
            IContainer iContainer = (IContainer)iWorkspaceRoot.findMember(iPath);
            if (this.isDestinationSameAsSource(iResourceArray3, iContainer) && this.canPerformAutoRename()) {
                bl = true;
            } else {
                if ((iResourceArray3 = this.validateNoNameCollisions(iContainer, iResourceArray3)) == null) {
                    if (this.canceled) {
                        return;
                    }
                    this.displayError(IDEWorkbenchMessages.CopyFilesAndFoldersOperation_nameCollision);
                    return;
                }
                if (!this.validateEdit(iContainer, iResourceArray3)) {
                    return;
                }
            }
        }
        this.errorStatus = null;
        if (iResourceArray3.length > 0) {
            if (bl) {
                this.performCopyWithAutoRename(iResourceArray3, iPath, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 90));
            } else {
                this.performCopy(iResourceArray3, iPath, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 90));
            }
        }
        iProgressMonitor.done();
        iResourceArray2[0] = iResourceArray3;
    }

    private void copyFileStores(IFileStore[] iFileStoreArray, IPath iPath, IProgressMonitor iProgressMonitor) {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (iWorkspaceRoot.exists(iPath)) {
            IContainer iContainer = (IContainer)iWorkspaceRoot.findMember(iPath);
            this.performFileImport(iFileStoreArray, iContainer, iProgressMonitor);
        }
    }

    public String[] getModelProviderIds() {
        return this.modelProviderIds;
    }

    public void setModelProviderIds(String[] stringArray) {
        this.modelProviderIds = stringArray;
    }

    public void createGroupAndLinks(String[] stringArray, IContainer iContainer) {
        IFileStore[] iFileStoreArray = this.buildFileStores(stringArray);
        if (iFileStoreArray == null) {
            return;
        }
        this.createGroupsAndLinks = true;
        this.copyFileStores(iContainer, iFileStoreArray, true, null);
    }

    public void linkFiles(String[] stringArray, IContainer iContainer) {
        IFileStore[] iFileStoreArray = this.buildFileStores(stringArray);
        if (iFileStoreArray == null) {
            return;
        }
        this.createLinks = true;
        this.copyFileStores(iContainer, iFileStoreArray, true, null);
    }

    public void setCreateGroups(boolean bl) {
        this.createGroupsAndLinks = bl;
    }

    public void setCreateLinks(boolean bl) {
        this.createLinks = bl;
    }

    public void setRelativeVariable(String string) {
        this.relativeVariable = string;
    }

    protected AbstractWorkspaceOperation getUndoableCopyOrMoveOperation(IResource[] iResourceArray, IPath iPath) {
        return new CopyResourcesOperation(iResourceArray, iPath, IDEWorkbenchMessages.CopyFilesAndFoldersOperation_copyTitle);
    }
}

