/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.dialogs.ProjectLocationSelectionDialog;
import org.eclipse.ui.ide.undo.CopyProjectOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CopyProjectAction
extends SelectionListenerAction {
    private static String COPY_TOOL_TIP = IDEWorkbenchMessages.CopyProjectAction_toolTip;
    private static String COPY_TITLE = IDEWorkbenchMessages.CopyProjectAction_title;
    private static String PROBLEMS_TITLE = IDEWorkbenchMessages.CopyProjectAction_copyFailedTitle;
    public static final String ID = "org.eclipse.ui.CopyProjectAction";
    protected Shell shell;
    protected IShellProvider shellProvider;
    protected IStatus errorStatus;
    private String[] modelProviderIds;

    public CopyProjectAction(Shell shell) {
        this(shell, COPY_TITLE);
    }

    public CopyProjectAction(IShellProvider iShellProvider) {
        this(iShellProvider, COPY_TITLE);
    }

    CopyProjectAction(final Shell shell, String string) {
        super(string);
        Assert.isNotNull((Object)shell);
        this.shellProvider = new IShellProvider(){

            public Shell getShell() {
                return shell;
            }
        };
        this.initAction();
    }

    CopyProjectAction(IShellProvider iShellProvider, String string) {
        super(string);
        Assert.isNotNull((Object)iShellProvider);
        this.shellProvider = iShellProvider;
        this.initAction();
    }

    private void initAction() {
        this.shell = this.shellProvider.getShell();
        this.setToolTipText(COPY_TOOL_TIP);
        this.setId(ID);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.copy_project_action_context");
    }

    protected IProjectDescription createDescription(IProject iProject, String string, IPath iPath) throws CoreException {
        IProjectDescription iProjectDescription = iProject.getDescription();
        iProjectDescription.setName(string);
        if (iPath.equals((Object)Platform.getLocation())) {
            iProjectDescription.setLocation(null);
        } else {
            iProjectDescription.setLocation(iPath);
        }
        return iProjectDescription;
    }

    void displayError(String string) {
        MessageDialog.openError((Shell)this.shellProvider.getShell(), (String)this.getErrorsTitle(), (String)string);
    }

    protected String getErrorsTitle() {
        return PROBLEMS_TITLE;
    }

    protected AbstractUIPlugin getPlugin() {
        return (AbstractUIPlugin)Platform.getPlugin((String)"org.eclipse.ui");
    }

    boolean performCopy(final IProject iProject, final String string, final URI uRI) {
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) {
                CopyProjectOperation copyProjectOperation = new CopyProjectOperation(iProject, string, uRI, CopyProjectAction.this.getText());
                copyProjectOperation.setModelProviderIds(CopyProjectAction.this.getModelProviderIds());
                try {
                    PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)copyProjectOperation, iProgressMonitor, WorkspaceUndoUtil.getUIInfoAdapter(CopyProjectAction.this.shellProvider.getShell()));
                }
                catch (ExecutionException executionException) {
                    if (executionException.getCause() instanceof CoreException) {
                        CopyProjectAction.this.recordError((CoreException)executionException.getCause());
                    }
                    IDEWorkbenchPlugin.log(executionException.getMessage(), executionException);
                    CopyProjectAction.this.displayError(executionException.getMessage());
                }
            }
        };
        try {
            new ProgressMonitorJobsDialog(this.shellProvider.getShell()).run(true, true, iRunnableWithProgress);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            this.displayError(NLS.bind((String)IDEWorkbenchMessages.CopyProjectAction_internalError, (Object)invocationTargetException.getTargetException().getMessage()));
            return false;
        }
        return true;
    }

    protected Object[] queryDestinationParameters(IProject iProject) {
        ProjectLocationSelectionDialog projectLocationSelectionDialog = new ProjectLocationSelectionDialog(this.shellProvider.getShell(), iProject);
        projectLocationSelectionDialog.setTitle(IDEWorkbenchMessages.CopyProjectAction_copyTitle);
        projectLocationSelectionDialog.open();
        return projectLocationSelectionDialog.getResult();
    }

    final void recordError(CoreException coreException) {
        this.errorStatus = coreException.getStatus();
    }

    public void run() {
        this.errorStatus = null;
        IProject iProject = (IProject)this.getSelectedResources().get(0);
        Object[] objectArray = this.queryDestinationParameters(iProject);
        if (objectArray == null) {
            return;
        }
        String string = (String)objectArray[0];
        URI uRI = URIUtil.toURI((String)((String)objectArray[1]));
        boolean bl = this.performCopy(iProject, string, uRI);
        if (!bl) {
            return;
        }
        if (this.errorStatus != null) {
            ErrorDialog.openError((Shell)this.shellProvider.getShell(), (String)this.getErrorsTitle(), null, (IStatus)this.errorStatus);
            this.errorStatus = null;
        }
    }

    protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
        if (!super.updateSelection(iStructuredSelection)) {
            return false;
        }
        if (this.getSelectedNonResources().size() > 0) {
            return false;
        }
        List list = this.getSelectedResources();
        if (list.size() != 1) {
            return false;
        }
        IResource iResource = (IResource)list.get(0);
        return iResource instanceof IProject && ((IProject)iResource).isOpen();
    }

    public String[] getModelProviderIds() {
        return this.modelProviderIds;
    }

    public void setModelProviderIds(String[] stringArray) {
        this.modelProviderIds = stringArray;
    }
}

