/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.resources.mapping.ResourceChangeValidator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ProjectLocationSelectionDialog;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;

public class CopyProjectOperation {
    private MultiStatus errorStatus;
    private Shell parentShell;
    private String[] modelProviderIds;

    protected static boolean validateCopy(Shell shell, IProject iProject, String string, String[] stringArray) {
        IResourceChangeDescriptionFactory iResourceChangeDescriptionFactory = ResourceChangeValidator.getValidator().createDeltaFactory();
        iResourceChangeDescriptionFactory.copy((IResource)iProject, (IPath)new Path(string));
        return IDE.promptToConfirm(shell, IDEWorkbenchMessages.CopyProjectAction_confirm, NLS.bind((String)IDEWorkbenchMessages.CopyProjectAction_warning, (Object)iProject.getName()), iResourceChangeDescriptionFactory.getDelta(), stringArray, false);
    }

    public CopyProjectOperation(Shell shell) {
        this.parentShell = shell;
    }

    public void copyProject(IProject iProject) {
        this.errorStatus = null;
        ProjectLocationSelectionDialog projectLocationSelectionDialog = new ProjectLocationSelectionDialog(this.parentShell, iProject);
        projectLocationSelectionDialog.setTitle(IDEWorkbenchMessages.CopyProjectOperation_copyProject);
        if (projectLocationSelectionDialog.open() != 0) {
            return;
        }
        Object[] objectArray = projectLocationSelectionDialog.getResult();
        if (objectArray == null) {
            return;
        }
        String string = (String)objectArray[0];
        URI uRI = URIUtil.toURI((String)((String)objectArray[1]));
        boolean bl = this.performProjectCopy(iProject, string, uRI);
        if (!bl) {
            return;
        }
        if (this.errorStatus != null) {
            ErrorDialog.openError((Shell)this.parentShell, (String)IDEWorkbenchMessages.CopyProjectOperation_copyFailedTitle, null, (IStatus)this.errorStatus);
            this.errorStatus = null;
        }
    }

    private boolean performProjectCopy(final IProject iProject, final String string, final URI uRI) {
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                org.eclipse.ui.ide.undo.CopyProjectOperation copyProjectOperation = new org.eclipse.ui.ide.undo.CopyProjectOperation(iProject, string, uRI, IDEWorkbenchMessages.CopyProjectOperation_copyProject);
                copyProjectOperation.setModelProviderIds(CopyProjectOperation.this.getModelProviderIds());
                try {
                    PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)copyProjectOperation, iProgressMonitor, WorkspaceUndoUtil.getUIInfoAdapter(CopyProjectOperation.this.parentShell));
                }
                catch (ExecutionException executionException) {
                    if (executionException.getCause() instanceof CoreException) {
                        CopyProjectOperation.this.recordError((CoreException)executionException.getCause());
                    }
                    throw new InvocationTargetException(executionException);
                }
            }
        };
        try {
            new ProgressMonitorJobsDialog(this.parentShell).run(true, true, iRunnableWithProgress);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            final String string2 = invocationTargetException.getTargetException().getMessage();
            this.parentShell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError((Shell)CopyProjectOperation.this.parentShell, (String)IDEWorkbenchMessages.CopyProjectOperation_copyFailedTitle, (String)NLS.bind((String)IDEWorkbenchMessages.CopyProjectOperation_internalError, (Object)string2));
                }
            });
            return false;
        }
        return true;
    }

    private void recordError(CoreException coreException) {
        if (this.errorStatus == null) {
            this.errorStatus = new MultiStatus("org.eclipse.ui", 4, IDEWorkbenchMessages.CopyProjectOperation_copyFailedMessage, (Throwable)coreException);
        }
        this.errorStatus.merge(coreException.getStatus());
    }

    public String[] getModelProviderIds() {
        return this.modelProviderIds;
    }

    public void setModelProviderIds(String[] stringArray) {
        this.modelProviderIds = stringArray;
    }
}

