/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionValidator;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class CopyResourceAction
extends SelectionListenerAction
implements ISelectionValidator {
    public static final String ID = "org.eclipse.ui.CopyResourceAction";
    protected IShellProvider shellProvider;
    protected CopyFilesAndFoldersOperation operation;
    private String[] modelProviderIds;

    public static IPath getNewNameFor(IPath iPath, IWorkspace iWorkspace) {
        return CopyFilesAndFoldersOperation.getAutoNewNameFor(iPath, iWorkspace);
    }

    public CopyResourceAction(Shell shell) {
        this(shell, IDEWorkbenchMessages.CopyResourceAction_title);
    }

    public CopyResourceAction(IShellProvider iShellProvider) {
        this(iShellProvider, IDEWorkbenchMessages.CopyResourceAction_title);
    }

    CopyResourceAction(final Shell shell, String string) {
        super(string);
        Assert.isNotNull((Object)shell);
        this.shellProvider = new IShellProvider(){

            public Shell getShell() {
                return shell;
            }
        };
        this.initAction();
    }

    CopyResourceAction(IShellProvider iShellProvider, String string) {
        super(string);
        Assert.isNotNull((Object)iShellProvider);
        this.shellProvider = iShellProvider;
        this.initAction();
    }

    protected CopyFilesAndFoldersOperation createOperation() {
        return new CopyFilesAndFoldersOperation(this.getShell());
    }

    private void initAction() {
        this.setToolTipText(IDEWorkbenchMessages.CopyResourceAction_toolTip);
        this.setId(ID);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.copy_resource_action_context");
    }

    IContainer getInitialContainer() {
        List list = this.getSelectedResources();
        if (list.size() > 0) {
            IResource iResource = (IResource)list.get(0);
            return iResource.getParent();
        }
        return null;
    }

    protected IResource[] getResources(List list) {
        return list.toArray(new IResource[list.size()]);
    }

    Shell getShell() {
        return this.shellProvider.getShell();
    }

    public String isValid(Object object) {
        IWorkspaceRoot iWorkspaceRoot = IDEWorkbenchPlugin.getPluginWorkspace().getRoot();
        IContainer iContainer = (IContainer)iWorkspaceRoot.findMember((IPath)object);
        if (iContainer != null) {
            CopyFilesAndFoldersOperation copyFilesAndFoldersOperation = this.createOperation();
            List list = this.getSelectedResources();
            IResource[] iResourceArray = list.toArray(new IResource[list.size()]);
            return copyFilesAndFoldersOperation.validateDestination(iContainer, iResourceArray);
        }
        return null;
    }

    IPath queryDestinationResource() {
        ContainerSelectionDialog containerSelectionDialog = new ContainerSelectionDialog(this.shellProvider.getShell(), this.getInitialContainer(), true, IDEWorkbenchMessages.CopyResourceAction_selectDestination);
        containerSelectionDialog.setValidator(this);
        containerSelectionDialog.showClosedProjects(false);
        containerSelectionDialog.open();
        Object[] objectArray = containerSelectionDialog.getResult();
        if (objectArray != null && objectArray.length == 1) {
            return (IPath)objectArray[0];
        }
        return null;
    }

    public void run() {
        try {
            this.operation = this.createOperation();
            this.operation.setModelProviderIds(this.getModelProviderIds());
            List list = this.getSelectedResources();
            IPath iPath = this.queryDestinationResource();
            if (iPath == null) {
                return;
            }
            IWorkspaceRoot iWorkspaceRoot = IDEWorkbenchPlugin.getPluginWorkspace().getRoot();
            IContainer iContainer = (IContainer)iWorkspaceRoot.findMember(iPath);
            if (iContainer == null) {
                return;
            }
            this.runOperation(this.getResources(list), iContainer);
        }
        finally {
            this.operation = null;
        }
    }

    protected void runOperation(IResource[] iResourceArray, IContainer iContainer) {
        this.operation.copyResources(iResourceArray, iContainer);
    }

    protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
        if (!super.updateSelection(iStructuredSelection)) {
            return false;
        }
        if (this.getSelectedNonResources().size() > 0) {
            return false;
        }
        List list = this.getSelectedResources();
        if (list.size() == 0) {
            return false;
        }
        IContainer iContainer = ((IResource)list.get(0)).getParent();
        if (iContainer == null) {
            return false;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IResource iResource = (IResource)iterator.next();
            if (!iResource.exists()) {
                return false;
            }
            if (iResource.getType() == 4) {
                return false;
            }
            IContainer iContainer2 = iResource.getParent();
            if (iContainer2 == null || iContainer2.equals((Object)iContainer)) continue;
            return false;
        }
        return true;
    }

    public String[] getModelProviderIds() {
        return this.modelProviderIds;
    }

    public void setModelProviderIds(String[] stringArray) {
        this.modelProviderIds = stringArray;
    }
}

