/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.wizards.newresource.BasicNewFileResourceWizard;

public class CreateFileAction
extends SelectionListenerAction {
    public static final String ID = "org.eclipse.ui.CreateFileAction";
    protected IShellProvider shellProvider;

    public CreateFileAction(final Shell shell) {
        super(IDEWorkbenchMessages.CreateFileAction_text);
        Assert.isNotNull((Object)shell);
        this.shellProvider = new IShellProvider(){

            public Shell getShell() {
                return shell;
            }
        };
        this.initAction();
    }

    public CreateFileAction(IShellProvider iShellProvider) {
        super(IDEWorkbenchMessages.CreateFileAction_toolTip);
        Assert.isNotNull((Object)iShellProvider);
        this.shellProvider = iShellProvider;
        this.initAction();
    }

    private void initAction() {
        this.setToolTipText(IDEWorkbenchMessages.CreateFileAction_toolTip);
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
        this.setId(ID);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.create_file_action_context");
    }

    public void run() {
        BasicNewFileResourceWizard basicNewFileResourceWizard = new BasicNewFileResourceWizard();
        basicNewFileResourceWizard.init(PlatformUI.getWorkbench(), this.getStructuredSelection());
        basicNewFileResourceWizard.setNeedsProgressMonitor(true);
        WizardDialog wizardDialog = new WizardDialog(this.shellProvider.getShell(), (IWizard)basicNewFileResourceWizard);
        wizardDialog.create();
        wizardDialog.getShell().setText(IDEWorkbenchMessages.CreateFileAction_title);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)wizardDialog.getShell(), "org.eclipse.ui.ide.new_file_wizard_context");
        wizardDialog.open();
    }

    protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
        if (!super.updateSelection(iStructuredSelection)) {
            return false;
        }
        Iterator iterator = this.getSelectedResources().iterator();
        while (iterator.hasNext()) {
            IResource iResource = (IResource)iterator.next();
            if (this.resourceIsType(iResource, 6) && iResource.isAccessible()) continue;
            return false;
        }
        return true;
    }
}

