/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.ide.undo.DeleteResourcesOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.actions.LTKLauncher;
import org.eclipse.ui.progress.WorkbenchJob;

public class DeleteResourceAction
extends SelectionListenerAction {
    public static final String ID = "org.eclipse.ui.DeleteResourceAction";
    private IShellProvider shellProvider = null;
    private boolean deleteContent = false;
    protected boolean fTestingMode = false;
    private String[] modelProviderIds;

    public DeleteResourceAction(final Shell shell) {
        super(IDEWorkbenchMessages.DeleteResourceAction_text);
        Assert.isNotNull((Object)shell);
        this.initAction();
        this.setShellProvider(new IShellProvider(){

            public Shell getShell() {
                return shell;
            }
        });
    }

    public DeleteResourceAction(IShellProvider iShellProvider) {
        super(IDEWorkbenchMessages.DeleteResourceAction_text);
        Assert.isNotNull((Object)iShellProvider);
        this.initAction();
        this.setShellProvider(iShellProvider);
    }

    private void initAction() {
        this.setToolTipText(IDEWorkbenchMessages.DeleteResourceAction_toolTip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.delete_resource_action_context");
        this.setId(ID);
    }

    private void setShellProvider(IShellProvider iShellProvider) {
        this.shellProvider = iShellProvider;
    }

    private boolean canDelete(IResource[] iResourceArray) {
        if (!this.containsOnlyProjects(iResourceArray) && !this.containsOnlyNonProjects(iResourceArray)) {
            return false;
        }
        if (iResourceArray.length == 0) {
            return false;
        }
        int n = 0;
        while (n < iResourceArray.length) {
            IResource iResource = iResourceArray[n];
            if (iResource.isPhantom()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean containsLinkedResource(IResource[] iResourceArray) {
        int n = 0;
        while (n < iResourceArray.length) {
            IResource iResource = iResourceArray[n];
            if (iResource.isLinked()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean containsOnlyNonProjects(IResource[] iResourceArray) {
        int n = this.getSelectedResourceTypes(iResourceArray);
        if (n == 0) {
            return false;
        }
        return (n & 4) == 0;
    }

    private boolean containsOnlyProjects(IResource[] iResourceArray) {
        int n = this.getSelectedResourceTypes(iResourceArray);
        return n == 4;
    }

    private boolean confirmDelete(IResource[] iResourceArray) {
        if (this.containsOnlyProjects(iResourceArray)) {
            return this.confirmDeleteProjects(iResourceArray);
        }
        return this.confirmDeleteNonProjects(iResourceArray);
    }

    private boolean confirmDeleteNonProjects(IResource[] iResourceArray) {
        String string;
        String string2;
        if (iResourceArray.length == 1) {
            string2 = IDEWorkbenchMessages.DeleteResourceAction_title1;
            IResource iResource = iResourceArray[0];
            string = iResource.isLinked() ? NLS.bind((String)IDEWorkbenchMessages.DeleteResourceAction_confirmLinkedResource1, (Object)iResource.getName()) : NLS.bind((String)IDEWorkbenchMessages.DeleteResourceAction_confirm1, (Object)iResource.getName());
        } else {
            string2 = IDEWorkbenchMessages.DeleteResourceAction_titleN;
            string = this.containsLinkedResource(iResourceArray) ? NLS.bind((String)IDEWorkbenchMessages.DeleteResourceAction_confirmLinkedResourceN, (Object)new Integer(iResourceArray.length)) : NLS.bind((String)IDEWorkbenchMessages.DeleteResourceAction_confirmN, (Object)new Integer(iResourceArray.length));
        }
        return MessageDialog.openQuestion((Shell)this.shellProvider.getShell(), (String)string2, (String)string);
    }

    private boolean confirmDeleteProjects(IResource[] iResourceArray) {
        DeleteProjectDialog deleteProjectDialog = new DeleteProjectDialog(this.shellProvider.getShell(), iResourceArray);
        deleteProjectDialog.setTestingMode(this.fTestingMode);
        int n = deleteProjectDialog.open();
        this.deleteContent = deleteProjectDialog.getDeleteContent();
        return n == 0;
    }

    private IResource[] getSelectedResourcesArray() {
        List list = this.getSelectedResources();
        IResource[] iResourceArray = new IResource[list.size()];
        list.toArray(iResourceArray);
        return iResourceArray;
    }

    private int getSelectedResourceTypes(IResource[] iResourceArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < iResourceArray.length) {
            n |= iResourceArray[n2].getType();
            ++n2;
        }
        return n;
    }

    public void run() {
        final IResource[] iResourceArray = this.getSelectedResourcesArray();
        if (!this.fTestingMode && LTKLauncher.openDeleteWizard(this.getStructuredSelection())) {
            return;
        }
        if (!this.confirmDelete(iResourceArray)) {
            return;
        }
        Job job = new Job(IDEWorkbenchMessages.DeleteResourceAction_checkJobName){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                if (iResourceArray.length == 0) {
                    return Status.CANCEL_STATUS;
                }
                DeleteResourceAction.this.scheduleDeleteJob(iResourceArray);
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object object) {
                if (IDEWorkbenchMessages.DeleteResourceAction_jobName.equals(object)) {
                    return true;
                }
                return super.belongsTo(object);
            }
        };
        job.schedule();
    }

    private void scheduleDeleteJob(final IResource[] iResourceArray) {
        Job job = new Job(IDEWorkbenchMessages.DeleteResourceAction_jobName){

            public IStatus run(IProgressMonitor iProgressMonitor) {
                try {
                    DeleteResourcesOperation deleteResourcesOperation = new DeleteResourcesOperation(iResourceArray, IDEWorkbenchMessages.DeleteResourceAction_operationLabel, DeleteResourceAction.this.deleteContent);
                    deleteResourcesOperation.setModelProviderIds(DeleteResourceAction.this.getModelProviderIds());
                    if (DeleteResourceAction.this.deleteContent && DeleteResourceAction.this.containsOnlyProjects(iResourceArray)) {
                        WorkbenchJob workbenchJob = new WorkbenchJob(this, "Status checking", deleteResourcesOperation){
                            final /* synthetic */ 5 this$1;
                            private final /* synthetic */ DeleteResourcesOperation val$op;
                            {
                                this.this$1 = var1_1;
                                this.val$op = deleteResourcesOperation;
                            }

                            public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                                return this.val$op.computeExecutionStatus(iProgressMonitor);
                            }
                        };
                        workbenchJob.setSystem(true);
                        workbenchJob.schedule();
                        try {
                            workbenchJob.join();
                        }
                        catch (InterruptedException interruptedException) {}
                        if (workbenchJob.getResult().isOK()) {
                            return deleteResourcesOperation.execute(iProgressMonitor, WorkspaceUndoUtil.getUIInfoAdapter(DeleteResourceAction.this.shellProvider.getShell()));
                        }
                        return workbenchJob.getResult();
                    }
                    return PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)deleteResourcesOperation, iProgressMonitor, WorkspaceUndoUtil.getUIInfoAdapter(DeleteResourceAction.this.shellProvider.getShell()));
                }
                catch (ExecutionException executionException) {
                    if (executionException.getCause() instanceof CoreException) {
                        return ((CoreException)executionException.getCause()).getStatus();
                    }
                    return new Status(4, "org.eclipse.ui.ide", executionException.getMessage(), (Throwable)executionException);
                }
            }

            public boolean belongsTo(Object object) {
                if (IDEWorkbenchMessages.DeleteResourceAction_jobName.equals(object)) {
                    return true;
                }
                return super.belongsTo(object);
            }
        };
        job.setUser(true);
        job.schedule();
    }

    protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
        return super.updateSelection(iStructuredSelection) && this.canDelete(this.getSelectedResourcesArray());
    }

    public String[] getModelProviderIds() {
        return this.modelProviderIds;
    }

    public void setModelProviderIds(String[] stringArray) {
        this.modelProviderIds = stringArray;
    }

    static class DeleteProjectDialog
    extends MessageDialog {
        private IResource[] projects;
        private boolean deleteContent = false;
        private boolean fIsTesting = false;
        private Button radio1;
        private Button radio2;
        private SelectionListener selectionListener = new SelectionAdapter(this){
            final /* synthetic */ DeleteProjectDialog this$1;
            {
                this.this$1 = deleteProjectDialog;
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                if (button.getSelection()) {
                    DeleteProjectDialog.access$1(this.this$1, button == DeleteProjectDialog.access$0(this.this$1));
                }
            }
        };

        DeleteProjectDialog(Shell shell, IResource[] iResourceArray) {
            super(shell, DeleteProjectDialog.getTitle(iResourceArray), null, DeleteProjectDialog.getMessage(iResourceArray), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
            this.projects = iResourceArray;
        }

        static String getTitle(IResource[] iResourceArray) {
            if (iResourceArray.length == 1) {
                return IDEWorkbenchMessages.DeleteResourceAction_titleProject1;
            }
            return IDEWorkbenchMessages.DeleteResourceAction_titleProjectN;
        }

        static String getMessage(IResource[] iResourceArray) {
            if (iResourceArray.length == 1) {
                IProject iProject = (IProject)iResourceArray[0];
                return NLS.bind((String)IDEWorkbenchMessages.DeleteResourceAction_confirmProject1, (Object)iProject.getName());
            }
            return NLS.bind((String)IDEWorkbenchMessages.DeleteResourceAction_confirmProjectN, (Object)new Integer(iResourceArray.length));
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.ide.delete_project_dialog_context");
        }

        protected Control createCustomArea(Composite composite) {
            IProject iProject;
            Composite composite2 = new Composite(composite, 0);
            composite2.setLayout((Layout)new GridLayout());
            this.radio1 = new Button(composite2, 16);
            this.radio1.addSelectionListener(this.selectionListener);
            String string = this.projects.length == 1 ? ((iProject = (IProject)this.projects[0]) == null || iProject.getLocation() == null ? IDEWorkbenchMessages.DeleteResourceAction_deleteContentsN : NLS.bind((String)IDEWorkbenchMessages.DeleteResourceAction_deleteContents1, (Object)iProject.getLocation().toOSString())) : IDEWorkbenchMessages.DeleteResourceAction_deleteContentsN;
            this.radio1.setText(string);
            this.radio1.setFont(composite.getFont());
            iProject = new Label(composite2, 16384);
            iProject.setText(IDEWorkbenchMessages.DeleteResourceAction_deleteContentsDetails);
            iProject.setFont(composite.getFont());
            GC gC = new GC((Drawable)iProject);
            gC.setFont(iProject.getParent().getFont());
            FontMetrics fontMetrics = gC.getFontMetrics();
            gC.dispose();
            GridData gridData = new GridData();
            gridData.horizontalIndent = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)21);
            iProject.setLayoutData((Object)gridData);
            iProject.addMouseListener((MouseListener)new MouseAdapter(this){
                final /* synthetic */ DeleteProjectDialog this$1;
                {
                    this.this$1 = deleteProjectDialog;
                }

                public void mouseUp(MouseEvent mouseEvent) {
                    DeleteProjectDialog.access$1(this.this$1, true);
                    DeleteProjectDialog.access$0(this.this$1).setSelection(DeleteProjectDialog.access$2(this.this$1));
                    DeleteProjectDialog.access$3(this.this$1).setSelection(!DeleteProjectDialog.access$2(this.this$1));
                }
            });
            new Label(composite2, 16384);
            this.radio2 = new Button(composite2, 16);
            this.radio2.addSelectionListener(this.selectionListener);
            String string2 = IDEWorkbenchMessages.DeleteResourceAction_doNotDeleteContents;
            this.radio2.setText(string2);
            this.radio2.setFont(composite.getFont());
            this.radio1.setSelection(this.deleteContent);
            this.radio2.setSelection(!this.deleteContent);
            return composite2;
        }

        boolean getDeleteContent() {
            return this.deleteContent;
        }

        public int open() {
            if (this.fIsTesting) {
                this.deleteContent = true;
                return 0;
            }
            return super.open();
        }

        void setTestingMode(boolean bl) {
            this.fIsTesting = bl;
        }

        static /* synthetic */ Button access$0(DeleteProjectDialog deleteProjectDialog) {
            return deleteProjectDialog.radio1;
        }

        static /* synthetic */ void access$1(DeleteProjectDialog deleteProjectDialog, boolean bl) {
            deleteProjectDialog.deleteContent = bl;
        }

        static /* synthetic */ boolean access$2(DeleteProjectDialog deleteProjectDialog) {
            return deleteProjectDialog.deleteContent;
        }

        static /* synthetic */ Button access$3(DeleteProjectDialog deleteProjectDialog) {
            return deleteProjectDialog.radio2;
        }
    }
}

