/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.ide.IDEInternalWorkbenchImages;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.actions.BuildUtilities;
import org.eclipse.ui.statushandlers.StatusManager;

public class GlobalBuildAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private int buildType;
    private IWorkbenchWindow workbenchWindow;

    public GlobalBuildAction(IWorkbench iWorkbench, Shell shell, int n) {
        this(iWorkbench.getActiveWorkbenchWindow(), n);
        Assert.isNotNull((Object)shell);
    }

    public GlobalBuildAction(IWorkbenchWindow iWorkbenchWindow, int n) {
        Assert.isNotNull((Object)iWorkbenchWindow);
        this.workbenchWindow = iWorkbenchWindow;
        this.setBuildType(n);
    }

    private void setBuildType(int n) {
        switch (n) {
            case 9: 
            case 10: {
                this.setText(IDEWorkbenchMessages.GlobalBuildAction_text);
                this.setToolTipText(IDEWorkbenchMessages.GlobalBuildAction_toolTip);
                this.setId("build");
                this.workbenchWindow.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.global_incremental_build_action_context");
                this.setImageDescriptor(IDEInternalWorkbenchImages.getImageDescriptor("IMG_ETOOL_BUILD_EXEC"));
                this.setDisabledImageDescriptor(IDEInternalWorkbenchImages.getImageDescriptor("IMG_ETOOL_BUILD_EXEC_DISABLED"));
                this.setActionDefinitionId("org.eclipse.ui.project.buildAll");
                break;
            }
            case 6: {
                this.setText(IDEWorkbenchMessages.GlobalBuildAction_rebuildText);
                this.setToolTipText(IDEWorkbenchMessages.GlobalBuildAction_rebuildToolTip);
                this.setId("rebuildAll");
                this.workbenchWindow.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.global_full_build_action_context");
                this.setActionDefinitionId("org.eclipse.ui.project.rebuildAll");
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid build type");
            }
        }
        this.buildType = n;
    }

    private Shell getShell() {
        return this.workbenchWindow.getShell();
    }

    private String getOperationMessage() {
        if (this.buildType == 10) {
            return IDEWorkbenchMessages.GlobalBuildAction_buildOperationTitle;
        }
        return IDEWorkbenchMessages.GlobalBuildAction_rebuildAllOperationTitle;
    }

    public void doBuild() {
        this.doBuildOperation();
    }

    void doBuildOperation() {
        Job job = new Job(IDEWorkbenchMessages.GlobalBuildAction_jobTitle){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, IDEWorkbenchMessages.GlobalBuildAction_buildProblems, null);
                iProgressMonitor.beginTask(GlobalBuildAction.this.getOperationMessage(), 100);
                try {
                    try {
                        ResourcesPlugin.getWorkspace().build(GlobalBuildAction.this.buildType, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
                    }
                    catch (CoreException coreException) {
                        multiStatus.add(coreException.getStatus());
                        iProgressMonitor.done();
                    }
                }
                finally {
                    iProgressMonitor.done();
                }
                return multiStatus;
            }

            public boolean belongsTo(Object object) {
                return ResourcesPlugin.FAMILY_MANUAL_BUILD == object;
            }
        };
        job.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        job.setUser(true);
        job.schedule();
    }

    IProject[] getWorkspaceProjects() {
        return ResourcesPlugin.getWorkspace().getRoot().getProjects();
    }

    public void run() {
        if (this.workbenchWindow == null) {
            return;
        }
        IProject[] iProjectArray = this.getWorkspaceProjects();
        if (iProjectArray.length < 1) {
            return;
        }
        if (!this.verifyBuildersAvailable(iProjectArray)) {
            return;
        }
        if (!this.verifyNoManualRunning()) {
            return;
        }
        BuildUtilities.saveEditors(null);
        this.doBuildOperation();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean verifyBuildersAvailable(IProject[] iProjectArray) {
        try {
            int n = 0;
            while (true) {
                if (n >= iProjectArray.length) {
                    return false;
                }
                if (iProjectArray[n].isAccessible() && iProjectArray[n].getDescription().getBuildSpec().length > 0) {
                    return true;
                }
                ++n;
            }
        }
        catch (CoreException coreException) {
            StatusManager.getManager().handle(coreException, "org.eclipse.ui.ide");
            ErrorDialog.openError((Shell)this.getShell(), (String)IDEWorkbenchMessages.GlobalBuildAction_buildProblems, (String)NLS.bind((String)IDEWorkbenchMessages.GlobalBuildAction_internalError, (Object)coreException.getMessage()), (IStatus)coreException.getStatus());
            return false;
        }
    }

    public void dispose() {
        if (this.workbenchWindow == null) {
            return;
        }
        this.workbenchWindow = null;
    }

    private boolean verifyNoManualRunning() {
        Job[] jobArray = Job.getJobManager().find(ResourcesPlugin.FAMILY_MANUAL_BUILD);
        if (jobArray.length == 0) {
            return true;
        }
        boolean bl = MessageDialog.openQuestion((Shell)this.getShell(), (String)IDEWorkbenchMessages.GlobalBuildAction_BuildRunningTitle, (String)IDEWorkbenchMessages.GlobalBuildAction_BuildRunningMessage);
        if (bl) {
            int n = 0;
            while (n < jobArray.length) {
                Job job = jobArray[n];
                job.cancel();
                ++n;
            }
        }
        return false;
    }
}

