/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.ide.undo.AbstractWorkspaceOperation;
import org.eclipse.ui.ide.undo.MoveResourcesOperation;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class MoveFilesAndFoldersOperation
extends CopyFilesAndFoldersOperation {
    public MoveFilesAndFoldersOperation(Shell shell) {
        super(shell);
    }

    protected boolean canPerformAutoRename() {
        return false;
    }

    protected void copy(IResource[] iResourceArray, IPath iPath, IProgressMonitor iProgressMonitor) throws CoreException {
        int n = 0;
        while (n < iResourceArray.length) {
            IResource iResource = iResourceArray[n];
            IPath iPath2 = iPath.append(iResource.getName());
            IWorkspace iWorkspace = iResource.getWorkspace();
            IWorkspaceRoot iWorkspaceRoot = iWorkspace.getRoot();
            IResource iResource2 = iWorkspaceRoot.findMember(iPath2);
            if (iResource.getType() == 2 && iResource2 != null) {
                if (this.homogenousResources(iResource, iResource2)) {
                    IResource[] iResourceArray2 = ((IContainer)iResource).members();
                    this.copy(iResourceArray2, iPath2, iProgressMonitor);
                    this.delete(iResource, iProgressMonitor);
                } else {
                    this.delete(iResource2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 0));
                    iResource.move(iPath2, 34, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 0));
                }
            } else {
                if (iResource2 != null) {
                    if (this.homogenousResources(iResource, iResource2)) {
                        this.moveExisting(iResource, iResource2, iProgressMonitor);
                    } else {
                        this.delete(iResource2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 0));
                        iResource.move(iPath2, 34, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 0));
                    }
                } else {
                    iResource.move(iPath2, 34, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 0));
                }
                iProgressMonitor.worked(1);
                if (iProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
            }
            ++n;
        }
    }

    protected String getDeepCheckQuestion(IResource iResource) {
        return NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_deepMoveQuestion, (Object)iResource.getFullPath().makeRelative());
    }

    protected String getOperationTitle() {
        return IDEWorkbenchMessages.MoveFilesAndFoldersOperation_operationTitle;
    }

    protected String getProblemsMessage() {
        return IDEWorkbenchMessages.MoveFilesAndFoldersOperation_problemMessage;
    }

    protected String getProblemsTitle() {
        return IDEWorkbenchMessages.MoveFilesAndFoldersOperation_moveFailedTitle;
    }

    protected boolean getValidateConflictSource() {
        return true;
    }

    private void moveExisting(IResource iResource, IResource iResource2, IProgressMonitor iProgressMonitor) throws CoreException {
        IFile iFile;
        IFile iFile2 = this.getFile(iResource2);
        if (iFile2 != null && (iFile = this.getFile(iResource)) != null) {
            iFile2.setContents(iFile.getContents(), 2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 0));
            this.delete((IResource)iFile, iProgressMonitor);
        }
    }

    public String validateDestination(IContainer iContainer, IResource[] iResourceArray) {
        IPath iPath = iContainer.getLocation();
        int n = 0;
        while (n < iResourceArray.length) {
            IResource iResource = iResourceArray[n];
            if (iResource.getParent().equals((Object)iContainer)) {
                return NLS.bind((String)IDEWorkbenchMessages.MoveFilesAndFoldersOperation_sameSourceAndDest, (Object)iResource.getName());
            }
            if (iPath != null) {
                IPath iPath2 = iResource.getLocation();
                IPath iPath3 = iPath.append(iResource.getName());
                if (iPath2 != null && iPath2.isPrefixOf(iPath3)) {
                    return NLS.bind((String)IDEWorkbenchMessages.MoveFilesAndFoldersOperation_sameSourceAndDest, (Object)iResource.getName());
                }
            }
            ++n;
        }
        return super.validateDestination(iContainer, iResourceArray);
    }

    protected boolean isMove() {
        return true;
    }

    protected AbstractWorkspaceOperation getUndoableCopyOrMoveOperation(IResource[] iResourceArray, IPath iPath) {
        return new MoveResourcesOperation(iResourceArray, iPath, IDEWorkbenchMessages.CopyFilesAndFoldersOperation_moveTitle);
    }
}

