/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CopyProjectAction;
import org.eclipse.ui.dialogs.ProjectLocationMoveDialog;
import org.eclipse.ui.ide.undo.MoveProjectOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;

public class MoveProjectAction
extends CopyProjectAction {
    private static String MOVE_TOOL_TIP = IDEWorkbenchMessages.MoveProjectAction_toolTip;
    private static String MOVE_TITLE = IDEWorkbenchMessages.MoveProjectAction_text;
    private static String PROBLEMS_TITLE = IDEWorkbenchMessages.MoveProjectAction_dialogTitle;
    public static final String ID = "org.eclipse.ui.MoveProjectAction";

    public MoveProjectAction(Shell shell) {
        super(shell, MOVE_TITLE);
        this.initAction();
    }

    public MoveProjectAction(IShellProvider iShellProvider) {
        super(iShellProvider, MOVE_TITLE);
        this.initAction();
    }

    private void initAction() {
        this.setToolTipText(MOVE_TOOL_TIP);
        this.setId(ID);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.move_project_action_context");
    }

    protected String getErrorsTitle() {
        return PROBLEMS_TITLE;
    }

    boolean performMove(final IProject iProject, final URI uRI) {
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) {
                MoveProjectOperation moveProjectOperation = new MoveProjectOperation(iProject, uRI, IDEWorkbenchMessages.MoveProjectAction_moveTitle);
                moveProjectOperation.setModelProviderIds(MoveProjectAction.this.getModelProviderIds());
                try {
                    PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)moveProjectOperation, iProgressMonitor, WorkspaceUndoUtil.getUIInfoAdapter(MoveProjectAction.this.shellProvider.getShell()));
                }
                catch (ExecutionException executionException) {
                    if (executionException.getCause() instanceof CoreException) {
                        MoveProjectAction.this.recordError((CoreException)executionException.getCause());
                    }
                    IDEWorkbenchPlugin.log(executionException.getMessage(), executionException);
                    MoveProjectAction.this.displayError(executionException.getMessage());
                }
            }
        };
        try {
            new ProgressMonitorJobsDialog(this.shellProvider.getShell()).run(true, true, iRunnableWithProgress);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            IDEWorkbenchPlugin.log(((Object)((Object)this)).getClass(), "performMove()", invocationTargetException.getTargetException());
            this.displayError(NLS.bind((String)IDEWorkbenchMessages.MoveProjectAction_internalError, (Object)invocationTargetException.getTargetException().getMessage()));
            return false;
        }
        return true;
    }

    protected Object[] queryDestinationParameters(IProject iProject) {
        ProjectLocationMoveDialog projectLocationMoveDialog = new ProjectLocationMoveDialog(this.shellProvider.getShell(), iProject);
        projectLocationMoveDialog.setTitle(IDEWorkbenchMessages.MoveProjectAction_moveTitle);
        projectLocationMoveDialog.open();
        return projectLocationMoveDialog.getResult();
    }

    public void run() {
        this.errorStatus = null;
        IProject iProject = (IProject)this.getSelectedResources().get(0);
        Object[] objectArray = this.queryDestinationParameters(iProject);
        if (objectArray == null) {
            return;
        }
        URI uRI = URIUtil.toURI((String)((String)objectArray[1]));
        boolean bl = this.performMove(iProject, uRI);
        if (!bl) {
            return;
        }
        if (this.errorStatus != null) {
            ErrorDialog.openError((Shell)this.shellProvider.getShell(), (String)PROBLEMS_TITLE, null, (IStatus)this.errorStatus);
            this.errorStatus = null;
        }
    }
}

