/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.actions.CopyResourceAction;
import org.eclipse.ui.actions.MoveFilesAndFoldersOperation;
import org.eclipse.ui.actions.ReadOnlyStateChecker;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.actions.LTKLauncher;

public class MoveResourceAction
extends CopyResourceAction {
    public static final String ID = "org.eclipse.ui.MoveResourceAction";
    protected List destinations;

    public MoveResourceAction(Shell shell) {
        super(shell, IDEWorkbenchMessages.MoveResourceAction_text);
        this.initAction();
    }

    public MoveResourceAction(IShellProvider iShellProvider) {
        super(iShellProvider, IDEWorkbenchMessages.MoveResourceAction_text);
        this.initAction();
    }

    private void initAction() {
        this.setToolTipText(IDEWorkbenchMessages.MoveResourceAction_toolTip);
        this.setId(ID);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.move_resource_action_context");
    }

    protected CopyFilesAndFoldersOperation createOperation() {
        return new MoveFilesAndFoldersOperation(this.getShell());
    }

    protected List getDestinations() {
        return this.destinations;
    }

    protected IResource[] getResources(List list) {
        ReadOnlyStateChecker readOnlyStateChecker = new ReadOnlyStateChecker(this.getShell(), IDEWorkbenchMessages.MoveResourceAction_title, IDEWorkbenchMessages.MoveResourceAction_checkMoveMessage);
        return readOnlyStateChecker.checkReadOnlyResources(super.getResources(list));
    }

    protected void runOperation(IResource[] iResourceArray, IContainer iContainer) {
        this.destinations = new ArrayList();
        IResource[] iResourceArray2 = this.operation.copyResources(iResourceArray, iContainer);
        int n = 0;
        while (n < iResourceArray2.length) {
            this.destinations.add(iContainer.getFullPath().append(iResourceArray2[n].getName()));
            ++n;
        }
    }

    public void run() {
        if (LTKLauncher.openMoveWizard(this.getStructuredSelection())) {
            return;
        }
        super.run();
    }
}

