/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.BaseNewWizardMenu;
import org.eclipse.ui.actions.NewExampleAction;
import org.eclipse.ui.actions.NewProjectAction;
import org.eclipse.ui.internal.actions.NewWizardShortcutAction;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class NewWizardMenu
extends BaseNewWizardMenu {
    private final IAction newExampleAction;
    private final IAction newProjectAction;
    private boolean enabled = true;

    public NewWizardMenu(IWorkbenchWindow iWorkbenchWindow) {
        this(iWorkbenchWindow, null);
    }

    public NewWizardMenu(IWorkbenchWindow iWorkbenchWindow, String string) {
        super(iWorkbenchWindow, string);
        this.newExampleAction = new NewExampleAction(iWorkbenchWindow);
        this.newProjectAction = new NewProjectAction(iWorkbenchWindow);
    }

    public NewWizardMenu(IMenuManager iMenuManager, IWorkbenchWindow iWorkbenchWindow, boolean bl) {
        this(iWorkbenchWindow, null);
        this.fillMenu((IContributionManager)iMenuManager);
    }

    private void fillMenu(IContributionManager iContributionManager) {
        iContributionManager.removeAll();
        IContributionItem[] iContributionItemArray = this.getContributionItems();
        int n = 0;
        while (n < iContributionItemArray.length) {
            iContributionManager.add(iContributionItemArray[n]);
            ++n;
        }
    }

    public void deregisterListeners() {
    }

    private boolean hasExamples() {
        return this.registryHasCategory("org.eclipse.ui.Examples");
    }

    protected void addItems(List list) {
        ArrayList arrayList = new ArrayList();
        this.addShortcuts(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof ActionContributionItem) || !this.isNewProjectWizardAction(((ActionContributionItem)e).getAction())) continue;
            iterator.remove();
            list.add(e);
        }
        list.add(new ActionContributionItem(this.newProjectAction));
        list.add(new Separator());
        if (!arrayList.isEmpty()) {
            list.addAll(arrayList);
            list.add(new Separator());
        }
        if (this.hasExamples()) {
            list.add(new ActionContributionItem(this.newExampleAction));
            list.add(new Separator());
        }
        list.add(new ActionContributionItem(this.getShowDialogAction()));
    }

    private boolean isNewProjectWizardAction(IAction iAction) {
        if (iAction instanceof NewWizardShortcutAction) {
            IWizardDescriptor iWizardDescriptor = ((NewWizardShortcutAction)iAction).getWizardDescriptor();
            String[] stringArray = iWizardDescriptor.getTags();
            int n = 0;
            while (n < stringArray.length) {
                if ("project".equals(stringArray[n])) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    protected IContributionItem[] getContributionItems() {
        if (this.isEnabled()) {
            return super.getContributionItems();
        }
        return new IContributionItem[0];
    }
}

