/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.OpenSystemEditorAction;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.DialogUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.part.FileEditorInput;

public class OpenFileAction
extends OpenSystemEditorAction {
    public static final String ID = "org.eclipse.ui.OpenFileAction";
    private IEditorDescriptor editorDescriptor;

    public OpenFileAction(IWorkbenchPage iWorkbenchPage) {
        this(iWorkbenchPage, null);
    }

    public OpenFileAction(IWorkbenchPage iWorkbenchPage, IEditorDescriptor iEditorDescriptor) {
        super(iWorkbenchPage);
        this.setText(iEditorDescriptor == null ? IDEWorkbenchMessages.OpenFileAction_text : iEditorDescriptor.getLabel());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.open_file_action_context");
        this.setToolTipText(IDEWorkbenchMessages.OpenFileAction_toolTip);
        this.setId(ID);
        this.editorDescriptor = iEditorDescriptor;
    }

    boolean ensureFileLocal(IFile iFile) {
        return true;
    }

    void openFile(IFile iFile) {
        try {
            boolean bl = OpenStrategy.activateOnOpen();
            if (this.editorDescriptor == null) {
                IDE.openEditor(this.getWorkbenchPage(), iFile, bl);
            } else if (this.ensureFileLocal(iFile)) {
                this.getWorkbenchPage().openEditor((IEditorInput)new FileEditorInput(iFile), this.editorDescriptor.getId(), bl);
            }
        }
        catch (PartInitException partInitException) {
            DialogUtil.openError(this.getWorkbenchPage().getWorkbenchWindow().getShell(), IDEWorkbenchMessages.OpenFileAction_openFileShellTitle, partInitException.getMessage(), partInitException);
        }
    }
}

