/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceAction;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class OpenResourceAction
extends WorkspaceAction
implements IResourceChangeListener {
    public static final String ID = "org.eclipse.ui.OpenResourceAction";

    public OpenResourceAction(Shell shell) {
        super(shell, IDEWorkbenchMessages.OpenResourceAction_text);
        this.initAction();
    }

    public OpenResourceAction(IShellProvider iShellProvider) {
        super(iShellProvider, IDEWorkbenchMessages.OpenResourceAction_text);
        this.initAction();
    }

    private void initAction() {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.open_resource_action_context");
        this.setToolTipText(IDEWorkbenchMessages.OpenResourceAction_toolTip);
        this.setId(ID);
    }

    private int countClosedProjects() {
        int n = 0;
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n2 = 0;
        while (n2 < iProjectArray.length) {
            if (!iProjectArray[n2].isOpen()) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    protected String getOperationMessage() {
        return IDEWorkbenchMessages.OpenResourceAction_operationMessage;
    }

    protected String getProblemsMessage() {
        return IDEWorkbenchMessages.OpenResourceAction_problemMessage;
    }

    protected String getProblemsTitle() {
        return IDEWorkbenchMessages.OpenResourceAction_dialogTitle;
    }

    private boolean hasOtherClosedProjects() {
        int n = 0;
        Iterator iterator = this.getSelectedResources().iterator();
        while (iterator.hasNext()) {
            IProject iProject = (IProject)iterator.next();
            if (iProject.isOpen()) continue;
            ++n;
        }
        return n < this.countClosedProjects();
    }

    protected void invokeOperation(IResource iResource, IProgressMonitor iProgressMonitor) throws CoreException {
        ((IProject)iResource).open(iProgressMonitor);
    }

    private boolean promptToOpenWithReferences() {
        String string;
        IPreferenceStore iPreferenceStore = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        String string2 = iPreferenceStore.getString(string = "OPEN_REQUIRED_PROJECTS");
        if ("always".equals(string2)) {
            return true;
        }
        if ("never".equals(string2)) {
            return false;
        }
        String string3 = IDEWorkbenchMessages.OpenResourceAction_openRequiredProjects;
        MessageDialogWithToggle messageDialogWithToggle = MessageDialogWithToggle.openYesNoCancelQuestion((Shell)this.getShell(), (String)IDEWorkbenchMessages.Question, (String)string3, null, (boolean)false, (IPreferenceStore)iPreferenceStore, (String)string);
        int n = messageDialogWithToggle.getReturnCode();
        if (n == 1 || n == -1) {
            throw new OperationCanceledException();
        }
        return messageDialogWithToggle.getReturnCode() == 2;
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        IResourceDelta iResourceDelta;
        List list = this.getSelectedResources();
        if (this.selectionIsOfType(4) && (iResourceDelta = iResourceChangeEvent.getDelta()) != null) {
            IResourceDelta[] iResourceDeltaArray = iResourceDelta.getAffectedChildren(4);
            int n = 0;
            while (n < iResourceDeltaArray.length) {
                IResourceDelta iResourceDelta2 = iResourceDeltaArray[n];
                if ((iResourceDelta2.getFlags() & 0x4000) != 0 && list.contains(iResourceDelta2.getResource())) {
                    this.selectionChanged(this.getStructuredSelection());
                    return;
                }
                ++n;
            }
        }
    }

    public void run() {
        try {
            if (this.hasOtherClosedProjects() && this.promptToOpenWithReferences()) {
                this.runOpenWithReferences();
            }
            ISchedulingRule iSchedulingRule = null;
            IResourceRuleFactory iResourceRuleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
            Iterator iterator = this.getSelectedResources().iterator();
            while (iterator.hasNext()) {
                IProject iProject = (IProject)iterator.next();
                iSchedulingRule = MultiRule.combine(iSchedulingRule, (ISchedulingRule)iResourceRuleFactory.modifyRule((IResource)iProject));
            }
            this.runInBackground(iSchedulingRule);
        }
        catch (OperationCanceledException operationCanceledException) {}
    }

    private void runOpenWithReferences() {
        final ArrayList arrayList = new ArrayList(this.getActionResources());
        WorkspaceJob workspaceJob = new WorkspaceJob(OpenResourceAction.removeMnemonics((String)this.getText())){

            private void doOpenWithReferences(IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException {
                if (!iProject.exists() || iProject.isOpen()) {
                    return;
                }
                iProject.open((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1000));
                IProject[] iProjectArray = iProject.getReferencedProjects();
                int n = 0;
                while (n < iProjectArray.length) {
                    this.doOpenWithReferences(iProjectArray[n], iProgressMonitor);
                    ++n;
                }
            }

            public IStatus runInWorkspace(IProgressMonitor iProgressMonitor) throws CoreException {
                try {
                    iProgressMonitor.beginTask("", OpenResourceAction.this.countClosedProjects() * 1000);
                    iProgressMonitor.setTaskName(OpenResourceAction.this.getOperationMessage());
                    Iterator iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        this.doOpenWithReferences((IProject)iterator.next(), iProgressMonitor);
                    }
                }
                finally {
                    iProgressMonitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        workspaceJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        workspaceJob.setUser(true);
        workspaceJob.schedule();
    }

    protected boolean shouldPerformResourcePruning() {
        return false;
    }

    protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
        if (!this.selectionIsOfType(4)) {
            return false;
        }
        Iterator iterator = this.getSelectedResources().iterator();
        while (iterator.hasNext()) {
            IProject iProject = (IProject)iterator.next();
            if (iProject.isOpen()) continue;
            return true;
        }
        return false;
    }
}

