/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.internal.ide.DialogUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.part.FileEditorInput;

public class OpenSystemEditorAction
extends SelectionListenerAction {
    public static final String ID = "org.eclipse.ui.OpenSystemEditorAction";
    private IWorkbenchPage workbenchPage;

    public OpenSystemEditorAction(IWorkbenchPage iWorkbenchPage) {
        super(IDEWorkbenchMessages.OpenSystemEditorAction_text);
        this.setToolTipText(IDEWorkbenchMessages.OpenSystemEditorAction_toolTip);
        this.setId(ID);
        iWorkbenchPage.getWorkbenchWindow().getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.open_system_editor_action_context");
        if (iWorkbenchPage == null) {
            throw new IllegalArgumentException();
        }
        this.workbenchPage = iWorkbenchPage;
    }

    final IWorkbenchPage getWorkbenchPage() {
        return this.workbenchPage;
    }

    void openFile(IFile iFile) {
        try {
            this.getWorkbenchPage().openEditor((IEditorInput)new FileEditorInput(iFile), "org.eclipse.ui.systemExternalEditor");
        }
        catch (PartInitException partInitException) {
            DialogUtil.openError(this.getWorkbenchPage().getWorkbenchWindow().getShell(), IDEWorkbenchMessages.OpenSystemEditorAction_dialogTitle, partInitException.getMessage(), partInitException);
        }
    }

    public void run() {
        Iterator iterator = this.getSelectedResources().iterator();
        while (iterator.hasNext()) {
            IResource iResource = (IResource)iterator.next();
            if (!(iResource instanceof IFile)) continue;
            this.openFile((IFile)iResource);
        }
    }

    protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
        return super.updateSelection(iStructuredSelection) && this.selectionIsOfType(1);
    }
}

