/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.EditorSelectionDialog;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.ide.DialogUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.part.FileEditorInput;

public class OpenWithMenu
extends ContributionItem {
    private IWorkbenchPage page;
    private IAdaptable file;
    private IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
    private static Hashtable imageCache = new Hashtable(11);
    public static final String ID = "org.eclipse.ui.OpenWithMenu";
    private static final int MATCH_BOTH = 3;
    private static final Comparator comparer = new Comparator(){
        private Collator collator = Collator.getInstance();

        public int compare(Object object, Object object2) {
            String string = ((IEditorDescriptor)object).getLabel();
            String string2 = ((IEditorDescriptor)object2).getLabel();
            return this.collator.compare(string, string2);
        }
    };
    static /* synthetic */ Class class$0;

    public OpenWithMenu(IWorkbenchPage iWorkbenchPage) {
        this(iWorkbenchPage, null);
    }

    public OpenWithMenu(IWorkbenchPage iWorkbenchPage, IAdaptable iAdaptable) {
        super(ID);
        this.page = iWorkbenchPage;
        this.file = iAdaptable;
    }

    private Image getImage(IEditorDescriptor iEditorDescriptor) {
        ImageDescriptor imageDescriptor = this.getImageDescriptor(iEditorDescriptor);
        if (imageDescriptor == null) {
            return null;
        }
        Image image = (Image)imageCache.get(imageDescriptor);
        if (image == null) {
            image = imageDescriptor.createImage();
            imageCache.put(imageDescriptor, image);
        }
        return image;
    }

    private ImageDescriptor getImageDescriptor(IEditorDescriptor iEditorDescriptor) {
        ImageDescriptor imageDescriptor = null;
        imageDescriptor = iEditorDescriptor == null ? this.registry.getImageDescriptor(this.getFileResource().getName()) : iEditorDescriptor.getImageDescriptor();
        if (imageDescriptor == null && iEditorDescriptor.getId().equals("org.eclipse.ui.systemExternalEditor")) {
            imageDescriptor = this.registry.getSystemExternalEditorImageDescriptor(this.getFileResource().getName());
        }
        return imageDescriptor;
    }

    private void createMenuItem(Menu menu, final IEditorDescriptor iEditorDescriptor, IEditorDescriptor iEditorDescriptor2) {
        final MenuItem menuItem = new MenuItem(menu, 16);
        boolean bl = iEditorDescriptor2 != null && iEditorDescriptor.getId().equals(iEditorDescriptor2.getId());
        menuItem.setSelection(bl);
        menuItem.setText(iEditorDescriptor.getLabel());
        Image image = this.getImage(iEditorDescriptor);
        if (image != null) {
            menuItem.setImage(image);
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        if (!menuItem.getSelection()) break;
                        OpenWithMenu.this.openEditor(iEditorDescriptor, false);
                    }
                }
            }
        };
        menuItem.addListener(13, listener);
    }

    private void createOtherMenuItem(final Menu menu) {
        final IFile iFile = this.getFileResource();
        if (iFile == null) {
            return;
        }
        new MenuItem(menu, 2);
        MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setText(IDEWorkbenchMessages.OpenWithMenu_Other);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        IEditorDescriptor iEditorDescriptor;
                        EditorSelectionDialog editorSelectionDialog = new EditorSelectionDialog(menu.getShell());
                        editorSelectionDialog.setMessage(NLS.bind((String)IDEWorkbenchMessages.OpenWithMenu_OtherDialogDescription, (Object)iFile.getName()));
                        if (editorSelectionDialog.open() != 0 || (iEditorDescriptor = editorSelectionDialog.getSelectedEditor()) == null) break;
                        OpenWithMenu.this.openEditor(iEditorDescriptor, iEditorDescriptor.isOpenExternal());
                    }
                }
            }
        };
        menuItem.addListener(13, listener);
    }

    public void fill(Menu menu, int n) {
        IFile iFile = this.getFileResource();
        if (iFile == null) {
            return;
        }
        IEditorDescriptor iEditorDescriptor = this.registry.findEditor("org.eclipse.ui.DefaultTextEditor");
        IEditorDescriptor iEditorDescriptor2 = IDE.getDefaultEditor(iFile);
        IEditorDescriptor[] iEditorDescriptorArray = this.registry.getEditors(iFile.getName(), IDE.getContentType(iFile));
        Collections.sort(Arrays.asList(iEditorDescriptorArray), comparer);
        boolean bl = false;
        ArrayList<IEditorDescriptor> arrayList = new ArrayList<IEditorDescriptor>();
        int n2 = 0;
        while (n2 < iEditorDescriptorArray.length) {
            IEditorDescriptor iEditorDescriptor3 = iEditorDescriptorArray[n2];
            if (!arrayList.contains(iEditorDescriptor3)) {
                this.createMenuItem(menu, iEditorDescriptor3, iEditorDescriptor2);
                if (iEditorDescriptor != null && iEditorDescriptor3.getId().equals(iEditorDescriptor.getId())) {
                    bl = true;
                }
                arrayList.add(iEditorDescriptor3);
            }
            ++n2;
        }
        if (iEditorDescriptorArray.length > 0) {
            new MenuItem(menu, 2);
        }
        if (!bl && iEditorDescriptor != null) {
            this.createMenuItem(menu, iEditorDescriptor, iEditorDescriptor2);
        }
        IEditorDescriptor iEditorDescriptor4 = this.registry.findEditor("org.eclipse.ui.systemExternalEditor");
        this.createMenuItem(menu, iEditorDescriptor4, iEditorDescriptor2);
        iEditorDescriptor4 = this.registry.findEditor("org.eclipse.ui.systemInPlaceEditor");
        if (iEditorDescriptor4 != null) {
            this.createMenuItem(menu, iEditorDescriptor4, iEditorDescriptor2);
        }
        this.createDefaultMenuItem(menu, iFile);
        this.createOtherMenuItem(menu);
    }

    private IFile getFileResource() {
        IResource iResource;
        if (this.file instanceof IFile) {
            return (IFile)this.file;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iResource = (IResource)this.file.getAdapter((Class)clazz)) instanceof IFile) {
            return (IFile)iResource;
        }
        return null;
    }

    public boolean isDynamic() {
        return true;
    }

    protected void openEditor(IEditorDescriptor iEditorDescriptor, boolean bl) {
        IFile iFile = this.getFileResource();
        if (iFile == null) {
            return;
        }
        try {
            if (bl) {
                ((WorkbenchPage)this.page).openEditorFromDescriptor((IEditorInput)new FileEditorInput(iFile), iEditorDescriptor, true, null);
            } else {
                String string = iEditorDescriptor == null ? "org.eclipse.ui.systemExternalEditor" : iEditorDescriptor.getId();
                ((WorkbenchPage)this.page).openEditor((IEditorInput)new FileEditorInput(iFile), string, true, 3);
                IDE.setDefaultEditor(iFile, string);
            }
        }
        catch (PartInitException partInitException) {
            DialogUtil.openError(this.page.getWorkbenchWindow().getShell(), IDEWorkbenchMessages.OpenWithMenu_dialogTitle, partInitException.getMessage(), partInitException);
        }
    }

    private void createDefaultMenuItem(Menu menu, final IFile iFile) {
        final MenuItem menuItem = new MenuItem(menu, 16);
        menuItem.setSelection(IDE.getDefaultEditor(iFile) == null);
        menuItem.setText(IDEWorkbenchMessages.DefaultEditorDescription_name);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        if (!menuItem.getSelection()) break;
                        IDE.setDefaultEditor(iFile, null);
                        try {
                            OpenWithMenu.this.openEditor(IDE.getEditorDescriptor(iFile), false);
                            break;
                        }
                        catch (PartInitException partInitException) {
                            DialogUtil.openError(OpenWithMenu.this.page.getWorkbenchWindow().getShell(), IDEWorkbenchMessages.OpenWithMenu_dialogTitle, partInitException.getMessage(), partInitException);
                        }
                    }
                }
            }
        };
        menuItem.addListener(13, listener);
    }
}

