/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.ProductProperties;
import org.eclipse.ui.internal.ide.AboutInfo;
import org.eclipse.ui.internal.ide.FeatureSelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.WelcomeEditorInput;

public class QuickStartAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private static final String EDITOR_ID = "org.eclipse.ui.internal.ide.dialogs.WelcomeEditor";
    private IWorkbenchWindow workbenchWindow;

    public QuickStartAction() {
        this(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
    }

    public QuickStartAction(IWorkbenchWindow iWorkbenchWindow) {
        super(IDEWorkbenchMessages.QuickStart_text);
        if (iWorkbenchWindow == null) {
            throw new IllegalArgumentException();
        }
        this.workbenchWindow = iWorkbenchWindow;
        this.setToolTipText(IDEWorkbenchMessages.QuickStart_toolTip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.quick_start_action_context");
        this.setActionDefinitionId("org.eclipse.ui.help.quickStartAction");
    }

    public void run() {
        if (this.workbenchWindow == null) {
            return;
        }
        try {
            AboutInfo aboutInfo = this.promptForFeature();
            if (aboutInfo != null) {
                this.openWelcomePage(aboutInfo);
            }
        }
        catch (WorkbenchException workbenchException) {
            ErrorDialog.openError((Shell)this.workbenchWindow.getShell(), (String)IDEWorkbenchMessages.QuickStartAction_errorDialogTitle, (String)IDEWorkbenchMessages.QuickStartAction_infoReadError, (IStatus)workbenchException.getStatus());
        }
    }

    private AboutInfo promptForFeature() throws WorkbenchException {
        Object object;
        ArrayList<AboutInfo> arrayList = new ArrayList<AboutInfo>();
        URL uRL = null;
        IProduct iProduct = Platform.getProduct();
        if (iProduct != null) {
            uRL = ProductProperties.getWelcomePageUrl((IProduct)iProduct);
            arrayList.add(new AboutInfo(iProduct));
        }
        AboutInfo[] aboutInfoArray = IDEWorkbenchPlugin.getDefault().getFeatureInfos();
        int n = 0;
        while (n < aboutInfoArray.length) {
            object = aboutInfoArray[n].getWelcomePageURL();
            if (object != null && !object.equals(uRL)) {
                arrayList.add(aboutInfoArray[n]);
            }
            ++n;
        }
        Shell shell = this.workbenchWindow.getShell();
        if (arrayList.size() == 0) {
            MessageDialog.openInformation((Shell)shell, (String)IDEWorkbenchMessages.QuickStartMessageDialog_title, (String)IDEWorkbenchMessages.QuickStartMessageDialog_message);
            return null;
        }
        aboutInfoArray = new AboutInfo[arrayList.size()];
        arrayList.toArray(aboutInfoArray);
        object = new FeatureSelectionDialog(shell, aboutInfoArray, iProduct == null ? null : iProduct.getId(), IDEWorkbenchMessages.WelcomePageSelectionDialog_title, IDEWorkbenchMessages.WelcomePageSelectionDialog_message, "org.eclipse.ui.ide.welcome_page_selection_dialog");
        if (object.open() != 0 || object.getResult().length != 1) {
            return null;
        }
        return (AboutInfo)object.getResult()[0];
    }

    public boolean openWelcomePage(String string) throws WorkbenchException {
        AboutInfo aboutInfo = this.findFeature(string);
        if (aboutInfo == null || aboutInfo.getWelcomePageURL() == null) {
            return false;
        }
        return this.openWelcomePage(aboutInfo);
    }

    private AboutInfo findFeature(String string) throws WorkbenchException {
        AboutInfo[] aboutInfoArray = IDEWorkbenchPlugin.getDefault().getFeatureInfos();
        int n = 0;
        while (n < aboutInfoArray.length) {
            AboutInfo aboutInfo = aboutInfoArray[n];
            if (aboutInfo.getFeatureId().equals(string)) {
                return aboutInfo;
            }
            ++n;
        }
        return null;
    }

    private boolean openWelcomePage(AboutInfo aboutInfo) {
        IWorkbenchPage iWorkbenchPage = null;
        String string = aboutInfo.getWelcomePerspectiveId();
        if (string == null && ((iWorkbenchPage = this.workbenchWindow.getActivePage()) == null || iWorkbenchPage.getPerspective() == null)) {
            string = PlatformUI.getWorkbench().getPerspectiveRegistry().getDefaultPerspective();
        }
        if (string != null) {
            try {
                iWorkbenchPage = PlatformUI.getWorkbench().showPerspective(string, this.workbenchWindow);
            }
            catch (WorkbenchException workbenchException) {
                IDEWorkbenchPlugin.log("Error opening perspective: " + string, workbenchException.getStatus());
                return false;
            }
        }
        if (iWorkbenchPage == null) {
            return false;
        }
        iWorkbenchPage.setEditorAreaVisible(true);
        WelcomeEditorInput welcomeEditorInput = new WelcomeEditorInput(aboutInfo);
        IEditorPart iEditorPart = iWorkbenchPage.findEditor((IEditorInput)welcomeEditorInput);
        if (iEditorPart != null) {
            iWorkbenchPage.activate((IWorkbenchPart)iEditorPart);
            return true;
        }
        try {
            iWorkbenchPage.openEditor((IEditorInput)welcomeEditorInput, EDITOR_ID);
        }
        catch (PartInitException partInitException) {
            IDEWorkbenchPlugin.log("Error opening welcome editor for feature: " + aboutInfo.getFeatureId(), partInitException);
            Status status = new Status(4, "org.eclipse.ui.ide", 1, IDEWorkbenchMessages.QuickStartAction_openEditorException, (Throwable)partInitException);
            ErrorDialog.openError((Shell)this.workbenchWindow.getShell(), (String)IDEWorkbenchMessages.Workbench_openEditorErrorDialogTitle, (String)IDEWorkbenchMessages.Workbench_openEditorErrorDialogMessage, (IStatus)status);
            return false;
        }
        return true;
    }

    public void dispose() {
        if (this.workbenchWindow == null) {
            return;
        }
        this.workbenchWindow = null;
    }
}

