/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class ReadOnlyStateChecker {
    private Shell shell;
    private String titleMessage;
    private String mainMessage;
    private boolean yesToAllSelected = false;
    private boolean cancelSelected = false;
    private boolean ignoreLinkedResources = false;
    private String READ_ONLY_EXCEPTION_MESSAGE = IDEWorkbenchMessages.ReadOnlyCheck_problems;

    public ReadOnlyStateChecker(Shell shell, String string, String string2) {
        this.shell = shell;
        this.titleMessage = string;
        this.mainMessage = string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkAcceptedResource(IResource iResource, List list) throws CoreException {
        if (iResource.getType() == 1) {
            list.add(iResource);
            return true;
        } else if (this.getIgnoreLinkedResources() && iResource.isLinked()) {
            list.add(iResource);
            return true;
        } else {
            IContainer iContainer = (IContainer)iResource;
            if (iContainer.isAccessible()) {
                int n = this.checkReadOnlyResources(iContainer.members(), list);
                if (n != 4) return false;
                list.add(iResource);
                return true;
            } else {
                list.add(iResource);
            }
        }
        return true;
    }

    public IResource[] checkReadOnlyResources(IResource[] iResourceArray) {
        ArrayList arrayList = new ArrayList();
        int n = 1;
        try {
            n = this.checkReadOnlyResources(iResourceArray, arrayList);
        }
        catch (CoreException coreException) {
            this.shell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    ErrorDialog.openError((Shell)ReadOnlyStateChecker.this.shell, (String)ReadOnlyStateChecker.this.READ_ONLY_EXCEPTION_MESSAGE, null, (IStatus)coreException.getStatus());
                }
            });
        }
        if (n == 1) {
            return new IResource[0];
        }
        if (n == 4) {
            return iResourceArray;
        }
        IResource[] iResourceArray2 = new IResource[arrayList.size()];
        arrayList.toArray(iResourceArray2);
        return iResourceArray2;
    }

    private int checkReadOnlyResources(IResource[] iResourceArray, List list) throws CoreException {
        if (this.yesToAllSelected) {
            return 4;
        }
        boolean bl = true;
        ArrayList<IResource> arrayList = new ArrayList<IResource>();
        int n = 0;
        while (n < iResourceArray.length) {
            int n2;
            IResource iResource = iResourceArray[n];
            ResourceAttributes resourceAttributes = iResource.getResourceAttributes();
            if (!this.yesToAllSelected && this.shouldCheck(iResource) && resourceAttributes != null && resourceAttributes.isReadOnly()) {
                boolean bl2;
                n2 = this.queryYesToAllNoCancel(iResource);
                if (n2 == 2 && !(bl2 = this.checkAcceptedResource(iResource, arrayList))) {
                    bl = false;
                }
                if (n2 == 3) {
                    bl = false;
                }
                if (n2 == 1) {
                    this.cancelSelected = true;
                    return 1;
                }
                if (n2 == 4) {
                    this.yesToAllSelected = true;
                    arrayList.add(iResource);
                }
            } else {
                n2 = this.checkAcceptedResource(iResource, arrayList);
                if (this.cancelSelected) {
                    return 1;
                }
                if (n2 == 0) {
                    bl = false;
                }
            }
            ++n;
        }
        if (bl) {
            return 4;
        }
        list.addAll(arrayList);
        return 3;
    }

    private boolean shouldCheck(IResource iResource) {
        return !this.ignoreLinkedResources || !iResource.isLinked();
    }

    private int queryYesToAllNoCancel(IResource iResource) {
        final MessageDialog messageDialog = new MessageDialog(this.shell, this.titleMessage, null, MessageFormat.format((String)this.mainMessage, (Object[])new Object[]{iResource.getName()}), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                messageDialog.open();
            }
        });
        int n = messageDialog.getReturnCode();
        if (n == 0) {
            return 2;
        }
        if (n == 1) {
            return 4;
        }
        if (n == 2) {
            return 3;
        }
        return 1;
    }

    public boolean getIgnoreLinkedResources() {
        return this.ignoreLinkedResources;
    }

    public void setIgnoreLinkedResources(boolean bl) {
        this.ignoreLinkedResources = bl;
    }
}

