/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceAction;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.ide.dialogs.IDEResourceInfoUtils;

public class RefreshAction
extends WorkspaceAction {
    public static final String ID = "org.eclipse.ui.RefreshAction";

    public RefreshAction(Shell shell) {
        super(shell, IDEWorkbenchMessages.RefreshAction_text);
        this.initAction();
    }

    public RefreshAction(IShellProvider iShellProvider) {
        super(iShellProvider, IDEWorkbenchMessages.RefreshAction_text);
        this.initAction();
    }

    private void initAction() {
        this.setToolTipText(IDEWorkbenchMessages.RefreshAction_toolTip);
        this.setId(ID);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.refresh_action_context");
    }

    void checkLocationDeleted(IProject iProject) throws CoreException {
        if (!iProject.exists()) {
            return;
        }
        IFileInfo iFileInfo = IDEResourceInfoUtils.getFileInfo(iProject.getLocationURI());
        if (!iFileInfo.exists()) {
            String string = NLS.bind((String)IDEWorkbenchMessages.RefreshAction_locationDeletedMessage, (Object)iProject.getName(), (Object)iFileInfo.toString());
            final MessageDialog messageDialog = new MessageDialog(this.getShell(), IDEWorkbenchMessages.RefreshAction_dialogTitle, null, string, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
            this.getShell().getDisplay().syncExec(new Runnable(){

                public void run() {
                    messageDialog.open();
                }
            });
            if (messageDialog.getReturnCode() == 0) {
                iProject.delete(true, true, null);
            }
        }
    }

    protected String getOperationMessage() {
        return IDEWorkbenchMessages.RefreshAction_progressMessage;
    }

    protected String getProblemsMessage() {
        return IDEWorkbenchMessages.RefreshAction_problemMessage;
    }

    protected String getProblemsTitle() {
        return IDEWorkbenchMessages.RefreshAction_problemTitle;
    }

    protected List getSelectedResources() {
        ArrayList<IWorkspaceRoot> arrayList = super.getSelectedResources();
        if (arrayList.isEmpty()) {
            arrayList = new ArrayList<IWorkspaceRoot>();
            arrayList.add(ResourcesPlugin.getWorkspace().getRoot());
        }
        return arrayList;
    }

    protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
        return (super.updateSelection(iStructuredSelection) || iStructuredSelection.isEmpty()) && this.getSelectedNonResources().size() == 0;
    }

    public void handleKeyReleased(KeyEvent keyEvent) {
        if (keyEvent.keyCode == 0x100000E && keyEvent.stateMask == 0) {
            this.refreshAll();
        }
    }

    public final void refreshAll() {
        IStructuredSelection iStructuredSelection = this.getStructuredSelection();
        this.selectionChanged((IStructuredSelection)StructuredSelection.EMPTY);
        this.run();
        this.selectionChanged(iStructuredSelection);
    }

    protected final IRunnableWithProgress createOperation(final IStatus[] iStatusArray) {
        ISchedulingRule iSchedulingRule = null;
        IResourceRuleFactory iResourceRuleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        List list = new ArrayList(this.getActionResources());
        if (this.shouldPerformResourcePruning()) {
            list = this.pruneResources(list);
        }
        final ArrayList arrayList = list;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            iSchedulingRule = MultiRule.combine(iSchedulingRule, (ISchedulingRule)iResourceRuleFactory.refreshRule((IResource)iterator.next()));
        }
        return new WorkspaceModifyOperation(iSchedulingRule){

            public void execute(IProgressMonitor iProgressMonitor) {
                MultiStatus multiStatus = null;
                iProgressMonitor.beginTask("", arrayList.size() * 1000);
                iProgressMonitor.setTaskName(RefreshAction.this.getOperationMessage());
                Iterator iterator = arrayList.iterator();
                try {
                    while (iterator.hasNext()) {
                        try {
                            IResource iResource = (IResource)iterator.next();
                            RefreshAction.this.refreshResource(iResource, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1000));
                        }
                        catch (CoreException coreException) {
                            multiStatus = RefreshAction.this.recordError(multiStatus, coreException);
                        }
                        if (!iProgressMonitor.isCanceled()) continue;
                        throw new OperationCanceledException();
                    }
                    if (multiStatus != null) {
                        iStatusArray[0] = multiStatus;
                    }
                }
                finally {
                    iProgressMonitor.done();
                }
            }
        };
    }

    protected void refreshResource(IResource iResource, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iResource.getType() == 4) {
            this.checkLocationDeleted((IProject)iResource);
        } else if (iResource.getType() == 8) {
            IProject[] iProjectArray = ((IWorkspaceRoot)iResource).getProjects();
            int n = 0;
            while (n < iProjectArray.length) {
                this.checkLocationDeleted(iProjectArray[n]);
                ++n;
            }
        }
        iResource.refreshLocal(2, iProgressMonitor);
    }

    public void run() {
        final IStatus[] iStatusArray = new IStatus[]{Status.OK_STATUS};
        final WorkspaceModifyOperation workspaceModifyOperation = (WorkspaceModifyOperation)this.createOperation(iStatusArray);
        WorkspaceJob workspaceJob = new WorkspaceJob("refresh"){

            public IStatus runInWorkspace(IProgressMonitor iProgressMonitor) throws CoreException {
                try {
                    workspaceModifyOperation.run(iProgressMonitor);
                }
                catch (InvocationTargetException invocationTargetException) {
                    String string = NLS.bind((String)IDEWorkbenchMessages.WorkspaceAction_logTitle, (Object)((Object)((Object)this)).getClass().getName(), (Object)invocationTargetException.getTargetException());
                    throw new CoreException(StatusUtil.newStatus(4, string, invocationTargetException.getTargetException()));
                }
                catch (InterruptedException interruptedException) {
                    return Status.CANCEL_STATUS;
                }
                return iStatusArray[0];
            }
        };
        ISchedulingRule iSchedulingRule = workspaceModifyOperation.getRule();
        if (iSchedulingRule != null) {
            workspaceJob.setRule(iSchedulingRule);
        }
        workspaceJob.setUser(true);
        workspaceJob.schedule();
    }
}

