/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.TextActionHandler;
import org.eclipse.ui.actions.WorkspaceAction;
import org.eclipse.ui.ide.undo.MoveResourcesOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.actions.LTKLauncher;

public class RenameResourceAction
extends WorkspaceAction {
    private TreeEditor treeEditor;
    private Tree navigatorTree;
    private Text textEditor;
    private Composite textEditorParent;
    private TextActionHandler textActionHandler;
    private IResource inlinedResource;
    private boolean saving = false;
    public static final String ID = "org.eclipse.ui.RenameResourceAction";
    private IPath newPath;
    private String[] modelProviderIds;
    private static final String CHECK_RENAME_TITLE = IDEWorkbenchMessages.RenameResourceAction_checkTitle;
    private static final String CHECK_RENAME_MESSAGE = IDEWorkbenchMessages.RenameResourceAction_readOnlyCheck;
    private static String RESOURCE_EXISTS_TITLE = IDEWorkbenchMessages.RenameResourceAction_resourceExists;
    private static String RESOURCE_EXISTS_MESSAGE = IDEWorkbenchMessages.RenameResourceAction_overwriteQuestion;
    private static String PROJECT_EXISTS_MESSAGE = IDEWorkbenchMessages.RenameResourceAction_overwriteProjectQuestion;
    private static String PROJECT_EXISTS_TITLE = IDEWorkbenchMessages.RenameResourceAction_projectExists;

    public RenameResourceAction(Shell shell) {
        super(shell, IDEWorkbenchMessages.RenameResourceAction_text);
        this.initAction();
    }

    public RenameResourceAction(IShellProvider iShellProvider) {
        super(iShellProvider, IDEWorkbenchMessages.RenameResourceAction_text);
        this.initAction();
    }

    private void initAction() {
        this.setToolTipText(IDEWorkbenchMessages.RenameResourceAction_toolTip);
        this.setId(ID);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.rename_resource_action_context");
    }

    public RenameResourceAction(Shell shell, Tree tree) {
        this(shell);
        this.navigatorTree = tree;
        this.treeEditor = new TreeEditor(tree);
    }

    public RenameResourceAction(IShellProvider iShellProvider, Tree tree) {
        this(iShellProvider);
        this.navigatorTree = tree;
        this.treeEditor = new TreeEditor(tree);
    }

    private boolean checkOverwrite(final Shell shell, final IResource iResource) {
        final boolean[] blArray = new boolean[1];
        Runnable runnable = new Runnable(){

            public void run() {
                String string = iResource.getFullPath().makeRelative().toString();
                String string2 = RESOURCE_EXISTS_MESSAGE;
                String string3 = RESOURCE_EXISTS_TITLE;
                if (iResource.getType() == 4) {
                    string2 = PROJECT_EXISTS_MESSAGE;
                    string3 = PROJECT_EXISTS_TITLE;
                }
                blArray[0] = MessageDialog.openQuestion((Shell)shell, (String)string3, (String)MessageFormat.format((String)string2, (Object[])new Object[]{string}));
            }
        };
        shell.getDisplay().syncExec(runnable);
        return blArray[0];
    }

    private boolean checkReadOnlyAndNull(IResource iResource) {
        if (iResource == null) {
            return false;
        }
        ResourceAttributes resourceAttributes = iResource.getResourceAttributes();
        if (resourceAttributes != null && resourceAttributes.isReadOnly()) {
            return MessageDialog.openQuestion((Shell)this.getShell(), (String)CHECK_RENAME_TITLE, (String)MessageFormat.format((String)CHECK_RENAME_MESSAGE, (Object[])new Object[]{iResource.getName()}));
        }
        return true;
    }

    Composite createParent() {
        Tree tree = this.getTree();
        Composite composite = new Composite((Composite)tree, 0);
        TreeItem[] treeItemArray = tree.getSelection();
        this.treeEditor.horizontalAlignment = 16384;
        this.treeEditor.grabHorizontal = true;
        this.treeEditor.setEditor((Control)composite, treeItemArray[0]);
        return composite;
    }

    private static int getCellEditorInset(Control control) {
        return 1;
    }

    private void createTextEditor(final IResource iResource) {
        this.textEditorParent = this.createParent();
        this.textEditorParent.setVisible(false);
        final int n = RenameResourceAction.getCellEditorInset((Control)this.textEditorParent);
        if (n > 0) {
            this.textEditorParent.addListener(9, new Listener(){

                public void handleEvent(Event event) {
                    Point point = RenameResourceAction.this.textEditor.getSize();
                    Point point2 = RenameResourceAction.this.textEditorParent.getSize();
                    event.gc.drawRectangle(0, 0, Math.min(point.x + 4, point2.x - 1), point2.y - 1);
                }
            });
        }
        this.textEditor = new Text(this.textEditorParent, 0);
        this.textEditor.setFont(this.navigatorTree.getFont());
        this.textEditorParent.setBackground(this.textEditor.getBackground());
        this.textEditor.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                Point point = RenameResourceAction.this.textEditor.computeSize(-1, -1);
                point.x += point.y;
                Point point2 = RenameResourceAction.this.textEditorParent.getSize();
                RenameResourceAction.this.textEditor.setBounds(2, n, Math.min(point.x, point2.x - 4), point2.y - 2 * n);
                RenameResourceAction.this.textEditorParent.redraw();
            }
        });
        this.textEditor.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                switch (event.detail) {
                    case 2: {
                        RenameResourceAction.this.disposeTextWidget();
                        event.doit = true;
                        event.detail = 0;
                        break;
                    }
                    case 4: {
                        RenameResourceAction.this.saveChangesAndDispose(iResource);
                        event.doit = true;
                        event.detail = 0;
                    }
                }
            }
        });
        this.textEditor.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                RenameResourceAction.this.saveChangesAndDispose(iResource);
            }
        });
        if (this.textActionHandler != null) {
            this.textActionHandler.addText(this.textEditor);
        }
    }

    private void disposeTextWidget() {
        if (this.textActionHandler != null) {
            this.textActionHandler.removeText(this.textEditor);
        }
        if (this.textEditorParent != null) {
            this.textEditorParent.dispose();
            this.textEditorParent = null;
            this.textEditor = null;
            this.treeEditor.setEditor(null, null);
        }
    }

    protected List getActionResources() {
        if (this.inlinedResource == null) {
            return super.getActionResources();
        }
        ArrayList<IResource> arrayList = new ArrayList<IResource>();
        arrayList.add(this.inlinedResource);
        return arrayList;
    }

    protected String getOperationMessage() {
        return IDEWorkbenchMessages.RenameResourceAction_progress;
    }

    protected String getProblemsMessage() {
        return IDEWorkbenchMessages.RenameResourceAction_problemMessage;
    }

    protected String getProblemsTitle() {
        return IDEWorkbenchMessages.RenameResourceAction_problemTitle;
    }

    private Tree getTree() {
        return this.navigatorTree;
    }

    protected String queryNewResourceName(final IResource iResource) {
        final IWorkspace iWorkspace = IDEWorkbenchPlugin.getPluginWorkspace();
        final IPath iPath = iResource.getFullPath().removeLastSegments(1);
        IInputValidator iInputValidator = new IInputValidator(){

            public String isValid(String string) {
                if (iResource.getName().equals(string)) {
                    return IDEWorkbenchMessages.RenameResourceAction_nameMustBeDifferent;
                }
                IStatus iStatus = iWorkspace.validateName(string, iResource.getType());
                if (!iStatus.isOK()) {
                    return iStatus.getMessage();
                }
                if (iWorkspace.getRoot().exists(iPath.append(string))) {
                    return IDEWorkbenchMessages.RenameResourceAction_nameExists;
                }
                return null;
            }
        };
        InputDialog inputDialog = new InputDialog(this.getShell(), IDEWorkbenchMessages.RenameResourceAction_inputDialogTitle, IDEWorkbenchMessages.RenameResourceAction_inputDialogMessage, iResource.getName(), iInputValidator);
        inputDialog.setBlockOnOpen(true);
        int n = inputDialog.open();
        if (n == 0) {
            return inputDialog.getValue();
        }
        return null;
    }

    private void queryNewResourceNameInline(IResource iResource) {
        if (this.textEditorParent == null) {
            this.createTextEditor(iResource);
        }
        this.textEditor.setText(iResource.getName());
        this.textEditorParent.setVisible(true);
        Point point = this.textEditor.computeSize(-1, -1);
        point.x += point.y;
        Point point2 = this.textEditorParent.getSize();
        int n = RenameResourceAction.getCellEditorInset((Control)this.textEditorParent);
        this.textEditor.setBounds(2, n, Math.min(point.x, point2.x - 4), point2.y - 2 * n);
        this.textEditorParent.redraw();
        this.textEditor.selectAll();
        this.textEditor.setFocus();
    }

    public void run() {
        IResource iResource = this.getCurrentResource();
        if (iResource == null || !iResource.exists()) {
            return;
        }
        if (LTKLauncher.openRenameWizard(this.getStructuredSelection())) {
            return;
        }
        if (this.navigatorTree == null) {
            if (!this.checkReadOnlyAndNull(iResource)) {
                return;
            }
            String string = this.queryNewResourceName(iResource);
            if (string == null || string.equals("")) {
                return;
            }
            this.newPath = iResource.getFullPath().removeLastSegments(1).append(string);
            super.run();
        } else {
            this.runWithInlineEditor();
        }
    }

    private void runWithInlineEditor() {
        IResource iResource = this.getCurrentResource();
        if (!this.checkReadOnlyAndNull(iResource)) {
            return;
        }
        this.queryNewResourceNameInline(iResource);
    }

    private IResource getCurrentResource() {
        List list = this.getSelectedResources();
        if (list.size() == 1) {
            return (IResource)list.get(0);
        }
        return null;
    }

    protected void runWithNewPath(IPath iPath, IResource iResource) {
        this.newPath = iPath;
        super.run();
    }

    private void saveChangesAndDispose(IResource iResource) {
        if (this.saving) {
            return;
        }
        this.saving = true;
        this.inlinedResource = iResource;
        final String string = this.textEditor.getText();
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    if (!string.equals(RenameResourceAction.this.inlinedResource.getName())) {
                        IWorkspace iWorkspace = IDEWorkbenchPlugin.getPluginWorkspace();
                        IStatus iStatus = iWorkspace.validateName(string, RenameResourceAction.this.inlinedResource.getType());
                        if (!iStatus.isOK()) {
                            RenameResourceAction.this.displayError(iStatus.getMessage());
                        } else {
                            IPath iPath = RenameResourceAction.this.inlinedResource.getFullPath().removeLastSegments(1).append(string);
                            RenameResourceAction.this.runWithNewPath(iPath, RenameResourceAction.this.inlinedResource);
                        }
                    }
                    RenameResourceAction.this.inlinedResource = null;
                    RenameResourceAction.this.disposeTextWidget();
                    if (RenameResourceAction.this.navigatorTree != null && !RenameResourceAction.this.navigatorTree.isDisposed()) {
                        RenameResourceAction.this.navigatorTree.setFocus();
                    }
                }
                finally {
                    RenameResourceAction.this.saving = false;
                }
            }
        };
        this.getTree().getShell().getDisplay().asyncExec(runnable);
    }

    protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
        this.disposeTextWidget();
        if (iStructuredSelection.size() > 1) {
            return false;
        }
        if (!super.updateSelection(iStructuredSelection)) {
            return false;
        }
        IResource iResource = this.getCurrentResource();
        return iResource != null && iResource.exists();
    }

    public void setTextActionHandler(TextActionHandler textActionHandler) {
        this.textActionHandler = textActionHandler;
    }

    public String[] getModelProviderIds() {
        return this.modelProviderIds;
    }

    public void setModelProviderIds(String[] stringArray) {
        this.modelProviderIds = stringArray;
    }

    protected IRunnableWithProgress createOperation(final IStatus[] iStatusArray) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) {
                IResource[] iResourceArray = RenameResourceAction.this.getActionResources().toArray(new IResource[RenameResourceAction.this.getActionResources().size()]);
                if (iResourceArray.length == 1) {
                    IWorkspaceRoot iWorkspaceRoot = iResourceArray[0].getWorkspace().getRoot();
                    IResource iResource = iWorkspaceRoot.findMember(RenameResourceAction.this.newPath);
                    boolean bl = true;
                    if (iResource != null) {
                        bl = RenameResourceAction.this.checkOverwrite(RenameResourceAction.this.getShell(), iResource);
                    }
                    if (bl) {
                        MoveResourcesOperation moveResourcesOperation = new MoveResourcesOperation(iResourceArray[0], RenameResourceAction.this.newPath, IDEWorkbenchMessages.RenameResourceAction_operationTitle);
                        moveResourcesOperation.setModelProviderIds(RenameResourceAction.this.getModelProviderIds());
                        try {
                            PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)moveResourcesOperation, iProgressMonitor, WorkspaceUndoUtil.getUIInfoAdapter(RenameResourceAction.this.getShell()));
                        }
                        catch (ExecutionException executionException) {
                            iStatusArray[0] = executionException.getCause() instanceof CoreException ? ((CoreException)executionException.getCause()).getStatus() : new Status(4, "org.eclipse.ui", RenameResourceAction.this.getProblemsMessage(), (Throwable)executionException);
                        }
                    }
                }
            }
        };
    }
}

