/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public abstract class SelectionListenerAction
extends BaseSelectionListenerAction {
    private static final List EMPTY_LIST = Arrays.asList(new Object[0]);
    private boolean selectionDirty = true;
    private List resources;
    private List nonResources;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected SelectionListenerAction(String string) {
        super(string);
    }

    protected void clearCache() {
        this.selectionDirty = true;
        this.resources = null;
        this.nonResources = null;
    }

    private final void computeResources() {
        this.resources = null;
        this.nonResources = null;
        Iterator iterator = this.getStructuredSelection().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof IResource) {
                if (this.resources == null) {
                    this.resources = new ArrayList(this.getStructuredSelection().size());
                }
                this.resources.add(e);
                continue;
            }
            if (e instanceof IAdaptable) {
                Object object;
                IAdaptable iAdaptable = (IAdaptable)e;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((object = iAdaptable.getAdapter((Class)clazz)) != null) {
                    if (this.resources == null) {
                        this.resources = new ArrayList(this.getStructuredSelection().size());
                    }
                    this.resources.add(object);
                    continue;
                }
            } else {
                ResourceMapping resourceMapping;
                boolean bl = false;
                IAdapterManager iAdapterManager = Platform.getAdapterManager();
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.mapping.ResourceMapping");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((resourceMapping = (ResourceMapping)iAdapterManager.getAdapter(e, (Class)clazz)) != null) {
                    ResourceTraversal[] resourceTraversalArray = null;
                    try {
                        resourceTraversalArray = resourceMapping.getTraversals(ResourceMappingContext.LOCAL_CONTEXT, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException coreException) {
                        IDEWorkbenchPlugin.log(coreException.getLocalizedMessage(), coreException.getStatus());
                    }
                    if (resourceTraversalArray != null) {
                        int n = 0;
                        while (n < resourceTraversalArray.length) {
                            IResource[] iResourceArray = resourceTraversalArray[n].getResources();
                            if (iResourceArray != null) {
                                bl = true;
                                if (this.resources == null) {
                                    this.resources = new ArrayList(this.getStructuredSelection().size());
                                }
                                int n2 = 0;
                                while (n2 < iResourceArray.length) {
                                    this.resources.add(iResourceArray[n2]);
                                    ++n2;
                                }
                            }
                            ++n;
                        }
                    }
                }
                if (bl) continue;
            }
            if (this.nonResources == null) {
                this.nonResources = new ArrayList(1);
            }
            this.nonResources.add(e);
        }
    }

    protected List getSelectedNonResources() {
        if (this.selectionDirty) {
            this.computeResources();
            this.selectionDirty = false;
        }
        if (this.nonResources == null) {
            return EMPTY_LIST;
        }
        return this.nonResources;
    }

    protected List getSelectedResources() {
        if (this.selectionDirty) {
            this.computeResources();
            this.selectionDirty = false;
        }
        if (this.resources == null) {
            return EMPTY_LIST;
        }
        return this.resources;
    }

    protected boolean resourceIsType(IResource iResource, int n) {
        return (iResource.getType() & n) != 0;
    }

    protected boolean selectionIsOfType(int n) {
        if (this.getSelectedNonResources().size() > 0) {
            return false;
        }
        Iterator iterator = this.getSelectedResources().iterator();
        while (iterator.hasNext()) {
            IResource iResource = (IResource)iterator.next();
            if (this.resourceIsType(iResource, n)) continue;
            return false;
        }
        return true;
    }
}

