/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class TextActionHandler {
    private DeleteActionHandler textDeleteAction = new DeleteActionHandler();
    private CutActionHandler textCutAction = new CutActionHandler();
    private CopyActionHandler textCopyAction = new CopyActionHandler();
    private PasteActionHandler textPasteAction = new PasteActionHandler();
    private SelectAllActionHandler textSelectAllAction = new SelectAllActionHandler();
    private IAction deleteAction;
    private IAction cutAction;
    private IAction copyAction;
    private IAction pasteAction;
    private IAction selectAllAction;
    private IPropertyChangeListener deleteActionListener = new PropertyChangeListener((IAction)this.textDeleteAction);
    private IPropertyChangeListener cutActionListener = new PropertyChangeListener((IAction)this.textCutAction);
    private IPropertyChangeListener copyActionListener = new PropertyChangeListener((IAction)this.textCopyAction);
    private IPropertyChangeListener pasteActionListener = new PropertyChangeListener((IAction)this.textPasteAction);
    private IPropertyChangeListener selectAllActionListener = new PropertyChangeListener((IAction)this.textSelectAllAction);
    private Listener textControlListener = new TextControlListener();
    private Text activeTextControl;
    private MouseAdapter mouseAdapter = new MouseAdapter(){

        public void mouseUp(MouseEvent mouseEvent) {
            TextActionHandler.this.updateActionsEnableState();
        }
    };
    private KeyAdapter keyAdapter = new KeyAdapter(){

        public void keyReleased(KeyEvent keyEvent) {
            TextActionHandler.this.updateActionsEnableState();
        }
    };

    public TextActionHandler(IActionBars iActionBars) {
        iActionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.textCutAction);
        iActionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.textCopyAction);
        iActionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.textPasteAction);
        iActionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.textSelectAllAction);
        iActionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.textDeleteAction);
    }

    public void addText(Text text) {
        if (text == null) {
            return;
        }
        text.addListener(26, this.textControlListener);
        text.addListener(27, this.textControlListener);
        text.addKeyListener((KeyListener)this.keyAdapter);
        text.addMouseListener((MouseListener)this.mouseAdapter);
        if (text.isFocusControl()) {
            this.activeTextControl = text;
            this.updateActionsEnableState();
        }
    }

    public void dispose() {
        this.setCutAction(null);
        this.setCopyAction(null);
        this.setPasteAction(null);
        this.setSelectAllAction(null);
        this.setDeleteAction(null);
    }

    public void removeText(Text text) {
        if (text == null) {
            return;
        }
        text.removeListener(26, this.textControlListener);
        text.removeListener(27, this.textControlListener);
        text.removeMouseListener((MouseListener)this.mouseAdapter);
        text.removeKeyListener((KeyListener)this.keyAdapter);
        this.activeTextControl = null;
        this.updateActionsEnableState();
    }

    public void setCopyAction(IAction iAction) {
        if (this.copyAction == iAction) {
            return;
        }
        if (this.copyAction != null) {
            this.copyAction.removePropertyChangeListener(this.copyActionListener);
        }
        this.copyAction = iAction;
        if (this.copyAction != null) {
            this.copyAction.addPropertyChangeListener(this.copyActionListener);
        }
        this.textCopyAction.updateEnabledState();
    }

    public void setCutAction(IAction iAction) {
        if (this.cutAction == iAction) {
            return;
        }
        if (this.cutAction != null) {
            this.cutAction.removePropertyChangeListener(this.cutActionListener);
        }
        this.cutAction = iAction;
        if (this.cutAction != null) {
            this.cutAction.addPropertyChangeListener(this.cutActionListener);
        }
        this.textCutAction.updateEnabledState();
    }

    public void setPasteAction(IAction iAction) {
        if (this.pasteAction == iAction) {
            return;
        }
        if (this.pasteAction != null) {
            this.pasteAction.removePropertyChangeListener(this.pasteActionListener);
        }
        this.pasteAction = iAction;
        if (this.pasteAction != null) {
            this.pasteAction.addPropertyChangeListener(this.pasteActionListener);
        }
        this.textPasteAction.updateEnabledState();
    }

    public void setSelectAllAction(IAction iAction) {
        if (this.selectAllAction == iAction) {
            return;
        }
        if (this.selectAllAction != null) {
            this.selectAllAction.removePropertyChangeListener(this.selectAllActionListener);
        }
        this.selectAllAction = iAction;
        if (this.selectAllAction != null) {
            this.selectAllAction.addPropertyChangeListener(this.selectAllActionListener);
        }
        this.textSelectAllAction.updateEnabledState();
    }

    public void setDeleteAction(IAction iAction) {
        if (this.deleteAction == iAction) {
            return;
        }
        if (this.deleteAction != null) {
            this.deleteAction.removePropertyChangeListener(this.deleteActionListener);
        }
        this.deleteAction = iAction;
        if (this.deleteAction != null) {
            this.deleteAction.addPropertyChangeListener(this.deleteActionListener);
        }
        this.textDeleteAction.updateEnabledState();
    }

    private void updateActionsEnableState() {
        this.textCutAction.updateEnabledState();
        this.textCopyAction.updateEnabledState();
        this.textPasteAction.updateEnabledState();
        this.textSelectAllAction.updateEnabledState();
        this.textDeleteAction.updateEnabledState();
    }

    private class CopyActionHandler
    extends Action {
        protected CopyActionHandler() {
            super(IDEWorkbenchMessages.Copy);
            this.setId("TextCopyActionHandler");
            this.setEnabled(false);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.text_copy_action_context");
        }

        public void runWithEvent(Event event) {
            if (TextActionHandler.this.activeTextControl != null && !TextActionHandler.this.activeTextControl.isDisposed()) {
                TextActionHandler.this.activeTextControl.copy();
                TextActionHandler.this.updateActionsEnableState();
                return;
            }
            if (TextActionHandler.this.copyAction != null) {
                TextActionHandler.this.copyAction.runWithEvent(event);
                return;
            }
        }

        public void updateEnabledState() {
            if (TextActionHandler.this.activeTextControl != null && !TextActionHandler.this.activeTextControl.isDisposed()) {
                this.setEnabled(TextActionHandler.this.activeTextControl.getSelectionCount() > 0);
                return;
            }
            if (TextActionHandler.this.copyAction != null) {
                this.setEnabled(TextActionHandler.this.copyAction.isEnabled());
                return;
            }
            this.setEnabled(false);
        }
    }

    private class CutActionHandler
    extends Action {
        protected CutActionHandler() {
            super(IDEWorkbenchMessages.Cut);
            this.setId("TextCutActionHandler");
            this.setEnabled(false);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.text_cut_action_context");
        }

        public void runWithEvent(Event event) {
            if (TextActionHandler.this.activeTextControl != null && !TextActionHandler.this.activeTextControl.isDisposed()) {
                TextActionHandler.this.activeTextControl.cut();
                TextActionHandler.this.updateActionsEnableState();
                return;
            }
            if (TextActionHandler.this.cutAction != null) {
                TextActionHandler.this.cutAction.runWithEvent(event);
                return;
            }
        }

        public void updateEnabledState() {
            if (TextActionHandler.this.activeTextControl != null && !TextActionHandler.this.activeTextControl.isDisposed()) {
                this.setEnabled(TextActionHandler.this.activeTextControl.getEditable() && TextActionHandler.this.activeTextControl.getSelectionCount() > 0);
                return;
            }
            if (TextActionHandler.this.cutAction != null) {
                this.setEnabled(TextActionHandler.this.cutAction.isEnabled());
                return;
            }
            this.setEnabled(false);
        }
    }

    private class DeleteActionHandler
    extends Action {
        protected DeleteActionHandler() {
            super(IDEWorkbenchMessages.Delete);
            this.setId("TextDeleteActionHandler");
            this.setEnabled(false);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.text_delete_action_context");
        }

        public void runWithEvent(Event event) {
            if (TextActionHandler.this.activeTextControl != null && !TextActionHandler.this.activeTextControl.isDisposed()) {
                String string = TextActionHandler.this.activeTextControl.getText();
                Point point = TextActionHandler.this.activeTextControl.getSelection();
                if (point.y == point.x) {
                    ++point.y;
                }
                if (point.y > string.length()) {
                    return;
                }
                StringBuffer stringBuffer = new StringBuffer(string.substring(0, point.x));
                stringBuffer.append(string.substring(point.y));
                TextActionHandler.this.activeTextControl.setText(stringBuffer.toString());
                TextActionHandler.this.activeTextControl.setSelection(point.x, point.x);
                TextActionHandler.this.updateActionsEnableState();
                return;
            }
            if (TextActionHandler.this.deleteAction != null) {
                TextActionHandler.this.deleteAction.runWithEvent(event);
                return;
            }
        }

        public void updateEnabledState() {
            if (TextActionHandler.this.activeTextControl != null && !TextActionHandler.this.activeTextControl.isDisposed()) {
                this.setEnabled(TextActionHandler.this.activeTextControl.getEditable() && (TextActionHandler.this.activeTextControl.getSelectionCount() > 0 || TextActionHandler.this.activeTextControl.getCaretPosition() < TextActionHandler.this.activeTextControl.getCharCount()));
                return;
            }
            if (TextActionHandler.this.deleteAction != null) {
                this.setEnabled(TextActionHandler.this.deleteAction.isEnabled());
                return;
            }
            this.setEnabled(false);
        }
    }

    private class PasteActionHandler
    extends Action {
        protected PasteActionHandler() {
            super(IDEWorkbenchMessages.Paste);
            this.setId("TextPasteActionHandler");
            this.setEnabled(false);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.text_paste_action_context");
        }

        public void runWithEvent(Event event) {
            if (TextActionHandler.this.activeTextControl != null && !TextActionHandler.this.activeTextControl.isDisposed()) {
                TextActionHandler.this.activeTextControl.paste();
                TextActionHandler.this.updateActionsEnableState();
                return;
            }
            if (TextActionHandler.this.pasteAction != null) {
                TextActionHandler.this.pasteAction.runWithEvent(event);
                return;
            }
        }

        public void updateEnabledState() {
            if (TextActionHandler.this.activeTextControl != null && !TextActionHandler.this.activeTextControl.isDisposed()) {
                boolean bl = false;
                if (TextActionHandler.this.activeTextControl.getEditable()) {
                    Clipboard clipboard = new Clipboard(TextActionHandler.this.activeTextControl.getDisplay());
                    TransferData[] transferDataArray = clipboard.getAvailableTypes();
                    int n = 0;
                    while (n < transferDataArray.length) {
                        if (TextTransfer.getInstance().isSupportedType(transferDataArray[n])) {
                            bl = true;
                            break;
                        }
                        ++n;
                    }
                    clipboard.dispose();
                }
                this.setEnabled(bl);
                return;
            }
            if (TextActionHandler.this.pasteAction != null) {
                this.setEnabled(TextActionHandler.this.pasteAction.isEnabled());
                return;
            }
            this.setEnabled(false);
        }
    }

    private class PropertyChangeListener
    implements IPropertyChangeListener {
        private IAction actionHandler;

        protected PropertyChangeListener(IAction iAction) {
            this.actionHandler = iAction;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (TextActionHandler.this.activeTextControl != null) {
                return;
            }
            if (propertyChangeEvent.getProperty().equals("enabled")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                this.actionHandler.setEnabled(bl.booleanValue());
            }
        }
    }

    private class SelectAllActionHandler
    extends Action {
        protected SelectAllActionHandler() {
            super(IDEWorkbenchMessages.TextAction_selectAll);
            this.setId("TextSelectAllActionHandler");
            this.setEnabled(false);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.text_select_all_action_context");
        }

        public void runWithEvent(Event event) {
            if (TextActionHandler.this.activeTextControl != null && !TextActionHandler.this.activeTextControl.isDisposed()) {
                TextActionHandler.this.activeTextControl.selectAll();
                TextActionHandler.this.updateActionsEnableState();
                return;
            }
            if (TextActionHandler.this.selectAllAction != null) {
                TextActionHandler.this.selectAllAction.runWithEvent(event);
                return;
            }
        }

        public void updateEnabledState() {
            if (TextActionHandler.this.activeTextControl != null && !TextActionHandler.this.activeTextControl.isDisposed()) {
                this.setEnabled(TextActionHandler.this.activeTextControl.getCharCount() > 0);
                return;
            }
            if (TextActionHandler.this.selectAllAction != null) {
                this.setEnabled(TextActionHandler.this.selectAllAction.isEnabled());
                return;
            }
            this.setEnabled(false);
        }
    }

    private class TextControlListener
    implements Listener {
        private TextControlListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 26: {
                    TextActionHandler.this.activeTextControl = (Text)event.widget;
                    TextActionHandler.this.updateActionsEnableState();
                    break;
                }
                case 27: {
                    TextActionHandler.this.activeTextControl = null;
                    TextActionHandler.this.updateActionsEnableState();
                    break;
                }
            }
        }
    }
}

