/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;

public abstract class WorkspaceAction
extends SelectionListenerAction {
    private final IShellProvider shellProvider;

    protected WorkspaceAction(final Shell shell, String string) {
        super(string);
        Assert.isNotNull((Object)shell);
        this.shellProvider = new IShellProvider(){

            public Shell getShell() {
                return shell;
            }
        };
    }

    protected WorkspaceAction(IShellProvider iShellProvider, String string) {
        super(string);
        Assert.isNotNull((Object)iShellProvider);
        this.shellProvider = iShellProvider;
    }

    void displayError(String string) {
        if (string == null) {
            string = IDEWorkbenchMessages.WorkbenchAction_internalError;
        }
        MessageDialog.openError((Shell)this.shellProvider.getShell(), (String)this.getProblemsTitle(), (String)string);
    }

    final IStatus execute(List list, IProgressMonitor iProgressMonitor) {
        MultiStatus multiStatus = null;
        if (this.shouldPerformResourcePruning()) {
            list = this.pruneResources(list);
        }
        iProgressMonitor.beginTask("", list.size() * 1000);
        iProgressMonitor.setTaskName(this.getOperationMessage());
        Iterator iterator = list.iterator();
        try {
            while (iterator.hasNext()) {
                IResource iResource = (IResource)iterator.next();
                try {
                    this.invokeOperation(iResource, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1000));
                }
                catch (CoreException coreException) {
                    multiStatus = this.recordError(multiStatus, coreException);
                }
                if (!iProgressMonitor.isCanceled()) continue;
                throw new OperationCanceledException();
            }
            IStatus iStatus = multiStatus == null ? Status.OK_STATUS : multiStatus;
            return iStatus;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    protected abstract String getOperationMessage();

    protected String getProblemsMessage() {
        return IDEWorkbenchMessages.WorkbenchAction_problemsMessage;
    }

    protected String getProblemsTitle() {
        return IDEWorkbenchMessages.WorkspaceAction_problemsTitle;
    }

    Shell getShell() {
        return this.shellProvider.getShell();
    }

    protected void invokeOperation(IResource iResource, IProgressMonitor iProgressMonitor) throws CoreException {
    }

    boolean isDescendent(List list, IResource iResource) {
        IContainer iContainer = iResource.getParent();
        return iContainer != null && (list.contains(iContainer) || this.isDescendent(list, (IResource)iContainer));
    }

    List pruneResources(List list) {
        ArrayList arrayList = new ArrayList(list);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            IResource iResource = (IResource)iterator.next();
            if (!this.isDescendent(arrayList, iResource)) continue;
            iterator.remove();
        }
        return arrayList;
    }

    MultiStatus recordError(MultiStatus multiStatus, CoreException coreException) {
        if (multiStatus == null) {
            multiStatus = new MultiStatus("org.eclipse.ui.ide", 4, this.getProblemsMessage(), null);
        }
        multiStatus.merge(coreException.getStatus());
        return multiStatus;
    }

    public void run() {
        IStatus[] iStatusArray = new IStatus[1];
        try {
            new ProgressMonitorJobsDialog(this.shellProvider.getShell()).run(true, true, this.createOperation(iStatusArray));
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            String string = NLS.bind((String)IDEWorkbenchMessages.WorkspaceAction_logTitle, (Object)((Object)((Object)this)).getClass().getName(), (Object)invocationTargetException.getTargetException());
            IDEWorkbenchPlugin.log(string, StatusUtil.newStatus(4, string, invocationTargetException.getTargetException()));
            this.displayError(invocationTargetException.getTargetException().getMessage());
        }
        if (iStatusArray[0] != null && !iStatusArray[0].isOK()) {
            ErrorDialog.openError((Shell)this.shellProvider.getShell(), (String)this.getProblemsTitle(), null, (IStatus)iStatusArray[0]);
        }
    }

    protected boolean shouldPerformResourcePruning() {
        return true;
    }

    protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
        if (!super.updateSelection(iStructuredSelection) || iStructuredSelection.isEmpty()) {
            return false;
        }
        Iterator iterator = this.getSelectedResources().iterator();
        while (iterator.hasNext()) {
            IResource iResource = (IResource)iterator.next();
            if (iResource.isAccessible()) continue;
            return false;
        }
        return true;
    }

    protected List getActionResources() {
        return this.getSelectedResources();
    }

    public void runInBackground(ISchedulingRule iSchedulingRule) {
        this.runInBackground(iSchedulingRule, null);
    }

    public void runInBackground(ISchedulingRule iSchedulingRule, Object object) {
        if (object == null) {
            this.runInBackground(iSchedulingRule, null);
        } else {
            this.runInBackground(iSchedulingRule, new Object[]{object});
        }
    }

    public void runInBackground(ISchedulingRule iSchedulingRule, final Object[] objectArray) {
        final ArrayList arrayList = new ArrayList(this.getActionResources());
        WorkspaceJob workspaceJob = new WorkspaceJob(WorkspaceAction.removeMnemonics((String)this.getText())){

            public boolean belongsTo(Object object) {
                if (objectArray == null || object == null) {
                    return false;
                }
                int n = 0;
                while (n < objectArray.length) {
                    if (object.equals(objectArray[n])) {
                        return true;
                    }
                    ++n;
                }
                return false;
            }

            public IStatus runInWorkspace(IProgressMonitor iProgressMonitor) {
                return WorkspaceAction.this.execute(arrayList, iProgressMonitor);
            }
        };
        if (iSchedulingRule != null) {
            workspaceJob.setRule(iSchedulingRule);
        }
        workspaceJob.setUser(true);
        workspaceJob.schedule();
    }

    protected IRunnableWithProgress createOperation(final IStatus[] iStatusArray) {
        return new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor iProgressMonitor) {
                iStatusArray[0] = WorkspaceAction.this.execute(WorkspaceAction.this.getActionResources(), iProgressMonitor);
            }
        };
    }
}

