/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class ContainerGenerator {
    private IPath containerFullPath;
    private IContainer container;

    public ContainerGenerator(IPath iPath) {
        this.containerFullPath = iPath;
    }

    private IFolder createFolder(IFolder iFolder, IProgressMonitor iProgressMonitor) throws CoreException {
        iFolder.create(false, true, iProgressMonitor);
        if (iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        return iFolder;
    }

    private IFolder createFolderHandle(IContainer iContainer, String string) {
        return iContainer.getFolder((IPath)new Path(string));
    }

    private IProject createProject(IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException {
        try {
            iProgressMonitor.beginTask("", 2000);
            iProject.create((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1000));
            if (iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            iProject.open((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1000));
            if (iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
        }
        finally {
            iProgressMonitor.done();
        }
        return iProject;
    }

    private IProject createProjectHandle(IWorkspaceRoot iWorkspaceRoot, String string) {
        return iWorkspaceRoot.getProject(string);
    }

    public IContainer generateContainer(IProgressMonitor iProgressMonitor) throws CoreException {
        IDEWorkbenchPlugin.getPluginWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                iProgressMonitor.beginTask(IDEWorkbenchMessages.ContainerGenerator_progressMessage, 1000 * ContainerGenerator.this.containerFullPath.segmentCount());
                if (ContainerGenerator.this.container != null) {
                    return;
                }
                IWorkspaceRoot iWorkspaceRoot = ContainerGenerator.this.getWorkspaceRoot();
                ContainerGenerator.this.container = (IContainer)iWorkspaceRoot.findMember(ContainerGenerator.this.containerFullPath);
                if (ContainerGenerator.this.container != null) {
                    return;
                }
                ContainerGenerator.this.container = (IContainer)iWorkspaceRoot;
                int n = 0;
                while (n < ContainerGenerator.this.containerFullPath.segmentCount()) {
                    Object object;
                    String string = ContainerGenerator.this.containerFullPath.segment(n);
                    IResource iResource = ContainerGenerator.this.container.findMember(string);
                    if (iResource != null) {
                        if (iResource.getType() == 1) {
                            object = NLS.bind((String)IDEWorkbenchMessages.ContainerGenerator_pathOccupied, (Object)iResource.getFullPath().makeRelative());
                            throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.ide", 1, (String)object, null));
                        }
                        ContainerGenerator.this.container = (IContainer)iResource;
                        iProgressMonitor.worked(1000);
                    } else if (n == 0) {
                        object = ContainerGenerator.this.createProjectHandle(iWorkspaceRoot, string);
                        ContainerGenerator.this.container = (IContainer)ContainerGenerator.this.createProject(object, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1000));
                    } else {
                        object = ContainerGenerator.this.createFolderHandle(ContainerGenerator.this.container, string);
                        ContainerGenerator.this.container = (IContainer)ContainerGenerator.this.createFolder((IFolder)object, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1000));
                    }
                    ++n;
                }
            }
        }, null, 0, iProgressMonitor);
        return this.container;
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return IDEWorkbenchPlugin.getPluginWorkspace().getRoot();
    }
}

