/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FileSystemElement;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.misc.CheckboxTreeAndListGroup;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.model.WorkbenchViewerComparator;

public class FileSelectionDialog
extends SelectionDialog {
    private FileSystemElement root;
    CheckboxTreeAndListGroup selectionGroup;
    private boolean expandAllOnOpen = false;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 500;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 250;

    public FileSelectionDialog(Shell shell, FileSystemElement fileSystemElement, String string) {
        super(shell);
        this.setTitle(IDEWorkbenchMessages.FileSelectionDialog_title);
        this.root = fileSystemElement;
        if (string != null) {
            this.setMessage(string);
        } else {
            this.setMessage(IDEWorkbenchMessages.FileSelectionDialog_message);
        }
    }

    private void addSelectionButtons(Composite composite) {
        Composite composite2 = new Composite(composite, 131072);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(128);
        composite.setData((Object)gridData);
        Button button = new Button(composite2, 8);
        button.setText(SELECT_ALL_TITLE);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileSelectionDialog.this.selectionGroup.setAllSelections(true);
            }
        };
        button.addSelectionListener((SelectionListener)selectionAdapter);
        Button button2 = new Button(composite2, 8);
        button2.setText(DESELECT_ALL_TITLE);
        selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileSelectionDialog.this.selectionGroup.setAllSelections(false);
            }
        };
        button2.addSelectionListener((SelectionListener)selectionAdapter);
    }

    private void checkInitialSelections() {
        Iterator iterator = this.getInitialElementSelections().iterator();
        while (iterator.hasNext()) {
            FileSystemElement fileSystemElement = (FileSystemElement)iterator.next();
            if (fileSystemElement.isDirectory()) {
                this.selectionGroup.initialCheckTreeItem(fileSystemElement);
                continue;
            }
            this.selectionGroup.initialCheckListItem(fileSystemElement);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.ide.file_selection_dialog_context");
    }

    public void create() {
        super.create();
        this.initializeDialog();
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.createMessageArea(composite2);
        FileSystemElement fileSystemElement = new FileSystemElement("", null, true);
        fileSystemElement.addChild(this.root);
        this.root.setParent(fileSystemElement);
        this.selectionGroup = new CheckboxTreeAndListGroup(composite2, fileSystemElement, this.getFolderProvider(), (ILabelProvider)new WorkbenchLabelProvider(), (IStructuredContentProvider)this.getFileProvider(), (ILabelProvider)new WorkbenchLabelProvider(), 0, 500, 250);
        ICheckStateListener iCheckStateListener = new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                FileSelectionDialog.this.getOkButton().setEnabled(FileSelectionDialog.this.selectionGroup.getCheckedElementCount() > 0);
            }
        };
        WorkbenchViewerComparator workbenchViewerComparator = new WorkbenchViewerComparator();
        this.selectionGroup.setTreeComparator((ViewerComparator)workbenchViewerComparator);
        this.selectionGroup.setListComparator((ViewerComparator)workbenchViewerComparator);
        this.selectionGroup.addCheckStateListener(iCheckStateListener);
        this.addSelectionButtons(composite2);
        return composite2;
    }

    public boolean getExpandAllOnOpen() {
        return this.expandAllOnOpen;
    }

    private ITreeContentProvider getFileProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object object) {
                if (object instanceof FileSystemElement) {
                    return ((FileSystemElement)object).getFiles().getChildren(object);
                }
                return new Object[0];
            }
        };
    }

    private ITreeContentProvider getFolderProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object object) {
                if (object instanceof FileSystemElement) {
                    return ((FileSystemElement)object).getFolders().getChildren(object);
                }
                return new Object[0];
            }
        };
    }

    private void initializeDialog() {
        if (this.getInitialElementSelections().isEmpty()) {
            this.getOkButton().setEnabled(false);
        } else {
            this.checkInitialSelections();
        }
        this.selectionGroup.aboutToOpen();
        if (this.expandAllOnOpen) {
            this.selectionGroup.expandAll();
        }
    }

    protected void okPressed() {
        Iterator iterator = this.selectionGroup.getAllCheckedListItems();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        this.setResult(arrayList);
        super.okPressed();
    }

    public void setExpandAllOnOpen(boolean bl) {
        this.expandAllOnOpen = bl;
    }
}

