/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import com.ibm.icu.text.Collator;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ResourceWorkingSetFilter;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.actions.WorkingSetFilterActionGroup;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.model.ResourceFactory;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.statushandlers.StatusManager;

public class FilteredResourcesSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = "org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog";
    private static final String WORKINGS_SET_SETTINGS = "WorkingSet";
    private static final String SHOW_DERIVED = "ShowDerived";
    private ShowDerivedResourcesAction showDerivedResourcesAction;
    private ResourceItemLabelProvider resourceItemLabelProvider;
    private ResourceItemDetailsLabelProvider resourceItemDetailsLabelProvider;
    private WorkingSetFilterActionGroup workingSetFilterActionGroup;
    private CustomWorkingSetFilter workingSetFilter = new CustomWorkingSetFilter();
    private String title;
    private IContainer container;
    private int typeMask;
    private boolean isDerived;

    public FilteredResourcesSelectionDialog(Shell shell, boolean bl, IContainer iContainer, int n) {
        super(shell, bl);
        this.setSelectionHistory(new ResourceSelectionHistory());
        this.setTitle(IDEWorkbenchMessages.OpenResourceDialog_title);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.ide.open_resource_dialog");
        this.container = iContainer;
        this.typeMask = n;
        this.resourceItemLabelProvider = new ResourceItemLabelProvider();
        this.resourceItemDetailsLabelProvider = new ResourceItemDetailsLabelProvider();
        this.setListLabelProvider((ILabelProvider)this.resourceItemLabelProvider);
        this.setDetailsLabelProvider((ILabelProvider)this.resourceItemDetailsLabelProvider);
    }

    public void setTitle(String string) {
        super.setTitle(string);
        this.title = string;
    }

    private void setSubtitle(String string) {
        if (string == null || string.length() == 0) {
            this.getShell().setText(this.title);
        } else {
            this.getShell().setText(String.valueOf(this.title) + " - " + string);
        }
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings iDialogSettings = IDEWorkbenchPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (iDialogSettings == null) {
            iDialogSettings = IDEWorkbenchPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return iDialogSettings;
    }

    protected void storeDialog(IDialogSettings iDialogSettings) {
        super.storeDialog(iDialogSettings);
        iDialogSettings.put(SHOW_DERIVED, this.showDerivedResourcesAction.isChecked());
        XMLMemento xMLMemento = XMLMemento.createWriteRoot((String)"workingSet");
        this.workingSetFilterActionGroup.saveState((IMemento)xMLMemento);
        this.workingSetFilterActionGroup.dispose();
        StringWriter stringWriter = new StringWriter();
        try {
            xMLMemento.save((Writer)stringWriter);
            iDialogSettings.put(WORKINGS_SET_SETTINGS, stringWriter.getBuffer().toString());
        }
        catch (IOException iOException) {
            StatusManager.getManager().handle((IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 4, "", (Throwable)iOException));
        }
    }

    protected void restoreDialog(IDialogSettings iDialogSettings) {
        super.restoreDialog(iDialogSettings);
        boolean bl = iDialogSettings.getBoolean(SHOW_DERIVED);
        this.showDerivedResourcesAction.setChecked(bl);
        this.isDerived = bl;
        String string = iDialogSettings.get(WORKINGS_SET_SETTINGS);
        if (string != null) {
            try {
                XMLMemento xMLMemento = XMLMemento.createReadRoot((Reader)new StringReader(string));
                this.workingSetFilterActionGroup.restoreState((IMemento)xMLMemento);
            }
            catch (WorkbenchException workbenchException) {
                StatusManager.getManager().handle((IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 4, "", (Throwable)workbenchException));
            }
        }
        this.addListFilter(this.workingSetFilter);
        this.applyFilter();
    }

    protected void fillViewMenu(IMenuManager iMenuManager) {
        super.fillViewMenu(iMenuManager);
        this.showDerivedResourcesAction = new ShowDerivedResourcesAction();
        iMenuManager.add((IAction)this.showDerivedResourcesAction);
        this.workingSetFilterActionGroup = new WorkingSetFilterActionGroup(this.getShell(), new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getProperty();
                if ("changeWorkingSet".equals(string)) {
                    IWorkingSet iWorkingSet = (IWorkingSet)propertyChangeEvent.getNewValue();
                    if (!(iWorkingSet == null || iWorkingSet.isAggregateWorkingSet() && iWorkingSet.isEmpty())) {
                        FilteredResourcesSelectionDialog.this.workingSetFilter.setWorkingSet(iWorkingSet);
                        FilteredResourcesSelectionDialog.this.setSubtitle(iWorkingSet.getLabel());
                    } else {
                        IWorkbenchPage iWorkbenchPage;
                        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (iWorkbenchWindow != null && (iWorkingSet = (iWorkbenchPage = iWorkbenchWindow.getActivePage()).getAggregateWorkingSet()).isAggregateWorkingSet() && iWorkingSet.isEmpty()) {
                            iWorkingSet = null;
                        }
                        FilteredResourcesSelectionDialog.this.workingSetFilter.setWorkingSet(iWorkingSet);
                        FilteredResourcesSelectionDialog.this.setSubtitle(null);
                    }
                    FilteredResourcesSelectionDialog.this.scheduleRefresh();
                }
            }
        });
        iMenuManager.add((IContributionItem)new Separator());
        this.workingSetFilterActionGroup.fillContextMenu(iMenuManager);
    }

    protected Control createExtendedContentArea(Composite composite) {
        return null;
    }

    public Object[] getResult() {
        Object[] objectArray = super.getResult();
        if (objectArray == null) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof IResource) {
                arrayList.add(objectArray[n]);
            }
            ++n;
        }
        return arrayList.toArray();
    }

    public int open() {
        IWorkspace iWorkspace;
        IStatus iStatus;
        String string;
        ISelection iSelection;
        IWorkbenchWindow iWorkbenchWindow;
        if (this.getInitialPattern() == null && (iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null && (iSelection = iWorkbenchWindow.getSelectionService().getSelection()) instanceof ITextSelection && (string = ((ITextSelection)iSelection).getText()) != null && (string = string.trim()).length() > 0 && (iStatus = (iWorkspace = ResourcesPlugin.getWorkspace()).validateName(string, 1)).isOK()) {
            this.setInitialPattern(string);
        }
        return super.open();
    }

    public String getElementName(Object object) {
        IResource iResource = (IResource)object;
        return iResource.getName();
    }

    protected IStatus validateItem(Object object) {
        return new Status(0, WorkbenchPlugin.PI_WORKBENCH, 0, "", null);
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new ResourceFilter(this.container, this.isDerived, this.typeMask);
    }

    protected void applyFilter() {
        super.applyFilter();
    }

    protected Comparator getItemsComparator() {
        return new Comparator(){

            public int compare(Object object, Object object2) {
                String string;
                Collator collator = Collator.getInstance();
                IResource iResource = (IResource)object;
                IResource iResource2 = (IResource)object2;
                String string2 = iResource.getName();
                int n = collator.compare(string2, string = iResource2.getName());
                if (n == 0) {
                    IPath iPath = iResource.getFullPath();
                    IPath iPath2 = iResource2.getFullPath();
                    int n2 = iPath.segmentCount();
                    int n3 = iPath2.segmentCount();
                    int n4 = 0;
                    while (n4 < n2 && n4 < n3) {
                        n = collator.compare(iPath.segment(n4), iPath2.segment(n4));
                        if (n != 0) {
                            return n;
                        }
                        ++n4;
                    }
                    n = n3 - n2;
                }
                return n;
            }
        };
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider abstractContentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor iProgressMonitor) throws CoreException {
        if (itemsFilter instanceof ResourceFilter) {
            this.container.accept((IResourceProxyVisitor)new ResourceProxyVisitor(abstractContentProvider, (ResourceFilter)itemsFilter, iProgressMonitor), 0);
        }
        if (iProgressMonitor != null) {
            iProgressMonitor.done();
        }
    }

    private class CustomWorkingSetFilter
    extends ViewerFilter {
        private ResourceWorkingSetFilter resourceWorkingSetFilter = new ResourceWorkingSetFilter();

        private CustomWorkingSetFilter() {
        }

        public void setWorkingSet(IWorkingSet iWorkingSet) {
            this.resourceWorkingSetFilter.setWorkingSet(iWorkingSet);
        }

        public boolean select(Viewer viewer, Object object, Object object2) {
            return this.resourceWorkingSetFilter.select(viewer, object, object2);
        }
    }

    protected class ResourceFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private boolean showDerived = false;
        private IContainer filterContainer;
        private int filterTypeMask;

        public ResourceFilter(IContainer iContainer, boolean bl, int n) {
            super((FilteredItemsSelectionDialog)FilteredResourcesSelectionDialog.this);
            this.filterContainer = iContainer;
            this.showDerived = bl;
            this.filterTypeMask = n;
        }

        public ResourceFilter() {
            super((FilteredItemsSelectionDialog)FilteredResourcesSelectionDialog.this);
            this.filterContainer = FilteredResourcesSelectionDialog.this.container;
            this.showDerived = FilteredResourcesSelectionDialog.this.isDerived;
            this.filterTypeMask = FilteredResourcesSelectionDialog.this.typeMask;
        }

        public boolean isConsistentItem(Object object) {
            if (!(object instanceof IResource)) {
                return false;
            }
            IResource iResource = (IResource)object;
            return this.filterContainer.findMember(iResource.getFullPath()) != null;
        }

        public boolean matchItem(Object object) {
            if (!(object instanceof IResource)) {
                return false;
            }
            IResource iResource = (IResource)object;
            if (!this.showDerived && iResource.isDerived() || (this.filterTypeMask & iResource.getType()) == 0) {
                return false;
            }
            return this.matches(iResource.getName());
        }

        public boolean isSubFilter(FilteredItemsSelectionDialog.ItemsFilter itemsFilter) {
            if (!super.isSubFilter(itemsFilter)) {
                return false;
            }
            return itemsFilter instanceof ResourceFilter && this.showDerived == ((ResourceFilter)itemsFilter).showDerived;
        }

        public boolean equalsFilter(FilteredItemsSelectionDialog.ItemsFilter itemsFilter) {
            if (!super.equalsFilter(itemsFilter)) {
                return false;
            }
            return itemsFilter instanceof ResourceFilter && this.showDerived == ((ResourceFilter)itemsFilter).showDerived;
        }

        public boolean isShowDerived() {
            return this.showDerived;
        }
    }

    private class ResourceItemDetailsLabelProvider
    extends ResourceItemLabelProvider {
        private ResourceItemDetailsLabelProvider() {
        }

        public Image getImage(Object object) {
            if (!(object instanceof IResource)) {
                return super.getImage(object);
            }
            IContainer iContainer = ((IResource)object).getParent();
            return this.provider.getImage((Object)iContainer);
        }

        public String getText(Object object) {
            if (!(object instanceof IResource)) {
                return super.getText(object);
            }
            IContainer iContainer = ((IResource)object).getParent();
            if (iContainer.getType() == 8) {
                return null;
            }
            return iContainer.getFullPath().makeRelative().toString();
        }

        public void labelProviderChanged(LabelProviderChangedEvent labelProviderChangedEvent) {
            Object[] objectArray = ((ResourceItemLabelProvider)this).listeners.getListeners();
            int n = 0;
            while (n < ((ResourceItemLabelProvider)this).listeners.size()) {
                ((ILabelProviderListener)objectArray[n]).labelProviderChanged(labelProviderChangedEvent);
                ++n;
            }
        }
    }

    private class ResourceItemLabelProvider
    extends LabelProvider
    implements ILabelProviderListener,
    DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private ListenerList listeners = new ListenerList();
        WorkbenchLabelProvider provider = new WorkbenchLabelProvider();

        public ResourceItemLabelProvider() {
            this.provider.addListener((ILabelProviderListener)this);
        }

        public Image getImage(Object object) {
            if (!(object instanceof IResource)) {
                return super.getImage(object);
            }
            IResource iResource = (IResource)object;
            return this.provider.getImage((Object)iResource);
        }

        public String getText(Object object) {
            if (!(object instanceof IResource)) {
                return super.getText(object);
            }
            IResource iResource = (IResource)object;
            String string = iResource.getName();
            if (FilteredResourcesSelectionDialog.this.isDuplicateElement(object)) {
                string = String.valueOf(string) + " - " + iResource.getParent().getFullPath().makeRelative().toString();
            }
            return string;
        }

        public StyledString getStyledText(Object object) {
            if (!(object instanceof IResource)) {
                return new StyledString(super.getText(object));
            }
            IResource iResource = (IResource)object;
            StyledString styledString = new StyledString(iResource.getName());
            if (FilteredResourcesSelectionDialog.this.isDuplicateElement(object)) {
                styledString.append(" - ", StyledString.QUALIFIER_STYLER);
                styledString.append(iResource.getParent().getFullPath().makeRelative().toString(), StyledString.QUALIFIER_STYLER);
            }
            return styledString;
        }

        public void dispose() {
            this.provider.removeListener((ILabelProviderListener)this);
            this.provider.dispose();
            super.dispose();
        }

        public void addListener(ILabelProviderListener iLabelProviderListener) {
            this.listeners.add((Object)iLabelProviderListener);
        }

        public void removeListener(ILabelProviderListener iLabelProviderListener) {
            this.listeners.remove((Object)iLabelProviderListener);
        }

        public void labelProviderChanged(LabelProviderChangedEvent labelProviderChangedEvent) {
            Object[] objectArray = this.listeners.getListeners();
            int n = 0;
            while (n < this.listeners.size()) {
                ((ILabelProviderListener)objectArray[n]).labelProviderChanged(labelProviderChangedEvent);
                ++n;
            }
        }
    }

    private class ResourceProxyVisitor
    implements IResourceProxyVisitor {
        private FilteredItemsSelectionDialog.AbstractContentProvider proxyContentProvider;
        private ResourceFilter resourceFilter;
        private IProgressMonitor progressMonitor;
        private List projects;

        public ResourceProxyVisitor(FilteredItemsSelectionDialog.AbstractContentProvider abstractContentProvider, ResourceFilter resourceFilter, IProgressMonitor iProgressMonitor) throws CoreException {
            this.proxyContentProvider = abstractContentProvider;
            this.resourceFilter = resourceFilter;
            this.progressMonitor = iProgressMonitor;
            IResource[] iResourceArray = FilteredResourcesSelectionDialog.this.container.members();
            this.projects = new ArrayList<IResource>(Arrays.asList(iResourceArray));
            if (iProgressMonitor != null) {
                iProgressMonitor.beginTask(WorkbenchMessages.FilteredItemsSelectionDialog_searchJob_taskName, this.projects.size());
            }
        }

        public boolean visit(IResourceProxy iResourceProxy) {
            if (this.progressMonitor.isCanceled()) {
                return false;
            }
            IResource iResource = iResourceProxy.requestResource();
            if (this.projects.remove(iResource.getProject()) || this.projects.remove(iResource)) {
                this.progressMonitor.worked(1);
            }
            this.proxyContentProvider.add((Object)iResource, (FilteredItemsSelectionDialog.ItemsFilter)this.resourceFilter);
            if (iResource.getType() == 2 && iResource.isDerived() && !this.resourceFilter.isShowDerived()) {
                return false;
            }
            return iResource.getType() != 1;
        }
    }

    private class ResourceSelectionHistory
    extends FilteredItemsSelectionDialog.SelectionHistory {
        private ResourceSelectionHistory() {
        }

        protected Object restoreItemFromMemento(IMemento iMemento) {
            ResourceFactory resourceFactory = new ResourceFactory();
            IResource iResource = (IResource)resourceFactory.createElement(iMemento);
            return iResource;
        }

        protected void storeItemToMemento(Object object, IMemento iMemento) {
            IResource iResource = (IResource)object;
            ResourceFactory resourceFactory = new ResourceFactory(iResource);
            resourceFactory.saveState(iMemento);
        }
    }

    private class ShowDerivedResourcesAction
    extends Action {
        public ShowDerivedResourcesAction() {
            super(IDEWorkbenchMessages.FilteredResourcesSelectionDialog_showDerivedResourcesAction, 2);
        }

        public void run() {
            FilteredResourcesSelectionDialog.this.isDerived = this.isChecked();
            FilteredResourcesSelectionDialog.this.applyFilter();
        }
    }
}

