/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.SimpleListContentProvider;

public class MarkerResolutionSelectionDialog
extends SelectionDialog {
    private static final int LIST_WIDTH = 60;
    private static final int LIST_HEIGHT = 10;
    private IMarkerResolution[] resolutions;
    private ListViewer listViewer;

    public MarkerResolutionSelectionDialog(Shell shell, IMarkerResolution[] iMarkerResolutionArray) {
        super(shell);
        if (iMarkerResolutionArray == null || iMarkerResolutionArray.length == 0) {
            throw new IllegalArgumentException();
        }
        this.resolutions = iMarkerResolutionArray;
        this.setTitle(IDEWorkbenchMessages.MarkerResolutionSelectionDialog_title);
        this.setMessage(IDEWorkbenchMessages.MarkerResolutionSelectionDialog_messageLabel);
        this.setInitialSelections(new Object[]{iMarkerResolutionArray[0]});
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.ide.marker_resolution_selection_dialog_context");
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.createMessageArea(composite2);
        this.listViewer = new ListViewer(composite2, 2820);
        GridData gridData = new GridData(1808);
        gridData.heightHint = this.convertHeightInCharsToPixels(10);
        gridData.widthHint = this.convertWidthInCharsToPixels(60);
        this.listViewer.getList().setLayoutData((Object)gridData);
        this.listViewer.getList().setFont(composite.getFont());
        this.listViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object object) {
                return object == null ? "" : ((IMarkerResolution)object).getLabel();
            }
        });
        SimpleListContentProvider simpleListContentProvider = new SimpleListContentProvider();
        simpleListContentProvider.setElements(this.resolutions);
        this.listViewer.setContentProvider((IContentProvider)simpleListContentProvider);
        this.listViewer.setInput(new Object());
        this.listViewer.setSelection((ISelection)new StructuredSelection(this.getInitialElementSelections()), true);
        this.listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                MarkerResolutionSelectionDialog.this.getOkButton().setEnabled(!selectionChangedEvent.getSelection().isEmpty());
            }
        });
        this.listViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                MarkerResolutionSelectionDialog.this.okPressed();
            }
        });
        return composite2;
    }

    protected void okPressed() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.listViewer.getSelection();
        this.setResult(iStructuredSelection.toList());
        super.okPressed();
    }
}

