/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNatureDescriptor;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.CreateLinkedResourceGroup;

public class NewFolderDialog
extends SelectionStatusDialog {
    private Text folderNameField;
    private Button advancedButton;
    private CreateLinkedResourceGroup linkedResourceGroup;
    private IContainer container;
    private boolean firstLinkCheck = true;
    private Composite linkedResourceParent;
    private Composite linkedResourceComposite;
    private int basicShellHeight = -1;

    public NewFolderDialog(Shell shell, IContainer iContainer) {
        super(shell);
        this.container = iContainer;
        this.setTitle(IDEWorkbenchMessages.NewFolderDialog_title);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setStatusLineAboveButtons(true);
    }

    protected void computeResult() {
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.ide.new_folder_dialog");
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(false);
    }

    protected void createAdvancedControls(Composite composite) {
        Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
        if (!preferences.getBoolean("description.disableLinking") && this.isValidContainer()) {
            this.linkedResourceParent = new Composite(composite, 0);
            this.linkedResourceParent.setFont(composite.getFont());
            this.linkedResourceParent.setLayoutData((Object)new GridData(768));
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            this.linkedResourceParent.setLayout((Layout)gridLayout);
            this.advancedButton = new Button(this.linkedResourceParent, 8);
            this.advancedButton.setFont(this.linkedResourceParent.getFont());
            this.advancedButton.setText(IDEWorkbenchMessages.showAdvanced);
            this.setButtonLayoutData(this.advancedButton);
            GridData gridData = (GridData)this.advancedButton.getLayoutData();
            gridData.horizontalAlignment = 1;
            this.advancedButton.setLayoutData((Object)gridData);
            this.advancedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    NewFolderDialog.this.handleAdvancedButtonSelect();
                }
            });
        }
        this.linkedResourceGroup = new CreateLinkedResourceGroup(2, new Listener(){

            public void handleEvent(Event event) {
                NewFolderDialog.this.validateLinkedResource();
                NewFolderDialog.this.firstLinkCheck = false;
            }
        }, new CreateLinkedResourceGroup.IStringValue(){

            public void setValue(String string) {
                NewFolderDialog.this.folderNameField.setText(string);
            }

            public String getValue() {
                return NewFolderDialog.this.folderNameField.getText();
            }

            public IProject getProject() {
                return NewFolderDialog.this.container.getProject();
            }
        });
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(1808));
        this.createFolderNameGroup(composite2);
        this.createAdvancedControls(composite2);
        return composite2;
    }

    private void createFolderNameGroup(Composite composite) {
        Font font = composite.getFont();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite2, 0);
        label.setFont(font);
        label.setText(IDEWorkbenchMessages.NewFolderDialog_nameLabel);
        this.folderNameField = new Text(composite2, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 200;
        this.folderNameField.setLayoutData((Object)gridData);
        this.folderNameField.setFont(font);
        this.folderNameField.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                NewFolderDialog.this.validateLinkedResource();
            }
        });
    }

    private IFolder createFolderHandle(String string) {
        IWorkspaceRoot iWorkspaceRoot = this.container.getWorkspace().getRoot();
        IPath iPath = this.container.getFullPath().append(string);
        IFolder iFolder = iWorkspaceRoot.getFolder(iPath);
        return iFolder;
    }

    private IFolder createNewFolder(String string, final URI uRI) {
        final IFolder iFolder = this.createFolderHandle(string);
        WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor iProgressMonitor) throws CoreException {
                try {
                    iProgressMonitor.beginTask(IDEWorkbenchMessages.NewFolderDialog_progress, 2000);
                    if (iProgressMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    if (uRI == null) {
                        iFolder.create(false, true, iProgressMonitor);
                    } else {
                        iFolder.createLink(uRI, 16, iProgressMonitor);
                    }
                    if (iProgressMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                }
                finally {
                    iProgressMonitor.done();
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)workspaceModifyOperation);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getShell(), (String)IDEWorkbenchMessages.NewFolderDialog_errorTitle, null, (IStatus)((CoreException)invocationTargetException.getTargetException()).getStatus());
            } else {
                IDEWorkbenchPlugin.log(((Object)((Object)this)).getClass(), "createNewFolder", invocationTargetException.getTargetException());
                MessageDialog.openError((Shell)this.getShell(), (String)IDEWorkbenchMessages.NewFolderDialog_errorTitle, (String)NLS.bind((String)IDEWorkbenchMessages.NewFolderDialog_internalError, (Object)invocationTargetException.getTargetException().getMessage()));
            }
            return null;
        }
        return iFolder;
    }

    protected void handleAdvancedButtonSelect() {
        Shell shell = this.getShell();
        Point point = shell.getSize();
        Composite composite = (Composite)this.getDialogArea();
        if (this.linkedResourceComposite != null) {
            this.linkedResourceComposite.dispose();
            this.linkedResourceComposite = null;
            composite.layout();
            shell.setSize(point.x, this.basicShellHeight);
            this.advancedButton.setText(IDEWorkbenchMessages.showAdvanced);
        } else {
            if (this.basicShellHeight == -1) {
                this.basicShellHeight = shell.computeSize((int)-1, (int)-1, (boolean)true).y;
            }
            this.linkedResourceComposite = this.linkedResourceGroup.createContents(this.linkedResourceParent);
            point = shell.computeSize(-1, -1, true);
            shell.setSize(point);
            composite.layout();
            this.advancedButton.setText(IDEWorkbenchMessages.hideAdvanced);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isValidContainer() {
        if (this.container.getType() != 4 && this.container.getType() != 2) {
            return false;
        }
        try {
            IWorkspace iWorkspace = IDEWorkbenchPlugin.getPluginWorkspace();
            IProject iProject = this.container.getProject();
            String[] stringArray = iProject.getDescription().getNatureIds();
            int n = 0;
            while (true) {
                if (n >= stringArray.length) {
                    return true;
                }
                IProjectNatureDescriptor iProjectNatureDescriptor = iWorkspace.getNatureDescriptor(stringArray[n]);
                if (iProjectNatureDescriptor != null && !iProjectNatureDescriptor.isLinkingAllowed()) {
                    return false;
                }
                ++n;
            }
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    protected void updateStatus(IStatus iStatus) {
        if (this.firstLinkCheck && iStatus != null) {
            Status status = new Status(0, iStatus.getPlugin(), iStatus.getCode(), iStatus.getMessage(), iStatus.getException());
            super.updateStatus((IStatus)status);
        } else {
            super.updateStatus(iStatus);
        }
    }

    private void updateStatus(int n, String string) {
        this.updateStatus((IStatus)new Status(n, "org.eclipse.ui.ide", n, string, null));
    }

    private void validateLinkedResource() {
        boolean bl = this.validateFolderName();
        if (bl) {
            IFolder iFolder = this.createFolderHandle(this.folderNameField.getText());
            IStatus iStatus = this.linkedResourceGroup.validateLinkLocation((IResource)iFolder);
            if (iStatus.getSeverity() != 4) {
                this.getOkButton().setEnabled(true);
            } else {
                this.getOkButton().setEnabled(false);
            }
            if (!iStatus.isOK()) {
                this.updateStatus(iStatus);
            }
        } else {
            this.getOkButton().setEnabled(false);
        }
    }

    private boolean validateFolderName() {
        String string = this.folderNameField.getText();
        IWorkspace iWorkspace = this.container.getWorkspace();
        IStatus iStatus = iWorkspace.validateName(string, 2);
        if ("".equals(string)) {
            this.updateStatus(4, IDEWorkbenchMessages.NewFolderDialog_folderNameEmpty);
            return false;
        }
        if (!iStatus.isOK()) {
            this.updateStatus(iStatus);
            return false;
        }
        Path path = new Path(string);
        if (this.container.getFolder((IPath)path).exists() || this.container.getFile((IPath)path).exists()) {
            this.updateStatus(4, NLS.bind((String)IDEWorkbenchMessages.NewFolderDialog_alreadyExists, (Object)string));
            return false;
        }
        this.updateStatus(0, "");
        return true;
    }

    protected void okPressed() {
        URI uRI = this.linkedResourceGroup.getLinkTargetURI();
        IFolder iFolder = this.createNewFolder(this.folderNameField.getText(), uRI);
        if (iFolder == null) {
            return;
        }
        this.setSelectionResult(new IFolder[]{iFolder});
        super.okPressed();
    }
}

