/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.ProjectContentsLocationArea;

public class ProjectLocationMoveDialog
extends SelectionDialog {
    private IProject project;
    private Label statusMessageLabel;
    private static String PROJECT_LOCATION_SELECTION_TITLE = IDEWorkbenchMessages.ProjectLocationSelectionDialog_selectionTitle;
    private ProjectContentsLocationArea locationArea;

    public ProjectLocationMoveDialog(Shell shell, IProject iProject) {
        super(shell);
        this.setTitle(PROJECT_LOCATION_SELECTION_TITLE);
        this.project = iProject;
    }

    public void setMessage(String string) {
        super.setMessage(string);
        if (this.statusMessageLabel != null) {
            if (string == null) {
                this.statusMessageLabel.setText("");
                this.statusMessageLabel.setToolTipText("");
                this.getOkButton().setEnabled(true);
            } else {
                this.statusMessageLabel.setForeground(JFaceColors.getErrorText((Display)this.statusMessageLabel.getDisplay()));
                this.statusMessageLabel.setText(string);
                this.statusMessageLabel.setToolTipText(string);
                this.getOkButton().setEnabled(false);
            }
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.ide.project_location_selection_dialog_context");
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        this.getOkButton().setEnabled(false);
        return control;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(1808));
        this.locationArea = new ProjectContentsLocationArea(this.getErrorReporter(), composite2, this.project);
        this.setButtonLayoutData(this.locationArea.getBrowseButton());
        this.statusMessageLabel = new Label(composite2, 64);
        this.statusMessageLabel.setLayoutData((Object)new GridData(1808));
        this.statusMessageLabel.setFont(composite.getFont());
        this.statusMessageLabel.setText(" \n ");
        ProjectLocationMoveDialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    private ProjectContentsLocationArea.IErrorMessageReporter getErrorReporter() {
        return new ProjectContentsLocationArea.IErrorMessageReporter(){

            public void reportError(String string, boolean bl) {
                ProjectLocationMoveDialog.this.setMessage(string);
            }
        };
    }

    private IProject getProject() {
        return this.project;
    }

    protected void okPressed() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getProject().getName());
        arrayList.add(this.locationArea.getProjectLocation());
        this.setResult(arrayList);
        super.okPressed();
    }
}

