/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.StringMatcher;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ResourceListSelectionDialog
extends SelectionDialog {
    private static final String DIALOG_SETTINGS_SECTION = "ResourceListSelectionDialogSettings";
    Text pattern;
    Table resourceNames;
    Table folderNames;
    String patternString;
    IContainer container;
    int typeMask;
    private static Collator collator = Collator.getInstance();
    boolean gatherResourcesDynamically = true;
    StringMatcher stringMatcher;
    UpdateFilterThread updateFilterThread;
    UpdateGatherThread updateGatherThread;
    ResourceDescriptor[] descriptors;
    int descriptorsSize;
    WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
    boolean okEnabled = false;
    private boolean showDerived = false;
    private Button showDerivedButton;
    private boolean allowUserToToggleDerived;

    public ResourceListSelectionDialog(Shell shell, IResource[] iResourceArray) {
        super(shell);
        this.gatherResourcesDynamically = false;
        this.initDescriptors(iResourceArray);
    }

    public ResourceListSelectionDialog(Shell shell, IContainer iContainer, int n) {
        super(shell);
        this.container = iContainer;
        this.typeMask = n;
    }

    protected String adjustPattern() {
        String string = this.pattern.getText().trim();
        if (string.endsWith("<")) {
            return string.substring(0, string.length() - 1);
        }
        if (!string.equals("") && !string.endsWith("*")) {
            return String.valueOf(string) + "*";
        }
        return string;
    }

    protected void cancelPressed() {
        this.setResult(null);
        super.cancelPressed();
    }

    public boolean close() {
        boolean bl = super.close();
        this.labelProvider.dispose();
        return bl;
    }

    public void create() {
        super.create();
        this.pattern.setFocus();
        this.getButton(0).setEnabled(this.okEnabled);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Label label = new Label(composite2, 0);
        label.setText(IDEWorkbenchMessages.ResourceSelectionDialog_label);
        GridData gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        this.pattern = new Text(composite2, 2052);
        this.pattern.setLayoutData((Object)new GridData(768));
        label = new Label(composite2, 0);
        label.setText(IDEWorkbenchMessages.ResourceSelectionDialog_matching);
        gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        this.resourceNames = new Table(composite2, 2564);
        gridData = new GridData(1808);
        gridData.heightHint = 12 * this.resourceNames.getItemHeight();
        this.resourceNames.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText(IDEWorkbenchMessages.ResourceSelectionDialog_folders);
        gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        this.folderNames = new Table(composite2, 2820);
        gridData = new GridData(1808);
        gridData.widthHint = 300;
        gridData.heightHint = 4 * this.folderNames.getItemHeight();
        this.folderNames.setLayoutData((Object)gridData);
        if (this.gatherResourcesDynamically) {
            this.updateGatherThread = new UpdateGatherThread();
        } else {
            this.updateFilterThread = new UpdateFilterThread();
        }
        this.pattern.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 0x1000002) {
                    ResourceListSelectionDialog.this.resourceNames.setFocus();
                }
            }
        });
        this.pattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ResourceListSelectionDialog.this.refresh(false);
            }
        });
        this.resourceNames.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ResourceListSelectionDialog.this.updateFolders((ResourceDescriptor)selectionEvent.item.getData());
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                ResourceListSelectionDialog.this.okPressed();
            }
        });
        this.folderNames.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                ResourceListSelectionDialog.this.okPressed();
            }
        });
        if (this.getAllowUserToToggleDerived()) {
            this.showDerivedButton = new Button(composite2, 32);
            this.showDerivedButton.setText(IDEWorkbenchMessages.ResourceSelectionDialog_showDerived);
            this.showDerivedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ResourceListSelectionDialog.this.setShowDerived(ResourceListSelectionDialog.this.showDerivedButton.getSelection());
                    ResourceListSelectionDialog.this.refresh(true);
                }
            });
            this.showDerivedButton.setSelection(this.getShowDerived());
        }
        ResourceListSelectionDialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    public boolean getAllowUserToToggleDerived() {
        return this.allowUserToToggleDerived;
    }

    public void setAllowUserToToggleDerived(boolean bl) {
        this.allowUserToToggleDerived = bl;
    }

    private void filterResources(boolean bl) {
        int n;
        String string = bl ? null : this.patternString;
        this.patternString = this.adjustPattern();
        if (!bl && this.patternString.equals(string)) {
            return;
        }
        this.updateFilterThread.stop = true;
        this.stringMatcher = new StringMatcher(this.patternString, true, false);
        UpdateFilterThread updateFilterThread = this.updateFilterThread;
        this.updateFilterThread = new UpdateFilterThread();
        if (this.patternString.equals("")) {
            this.updateFilterThread.firstMatch = 0;
            this.updateFilterThread.lastMatch = -1;
            this.updateFilterThread.start();
            return;
        }
        if (string != null && string.length() != 0 && string.endsWith("*") && this.patternString.endsWith("*") && this.patternString.regionMatches(0, string, 0, n = string.length() - 1)) {
            this.updateFilterThread.firstMatch = updateFilterThread.firstMatch;
            this.updateFilterThread.lastMatch = updateFilterThread.lastMatch;
            this.updateFilterThread.start();
            return;
        }
        this.updateFilterThread.firstMatch = 0;
        this.updateFilterThread.lastMatch = this.descriptorsSize - 1;
        this.updateFilterThread.start();
    }

    private int getFirstMatch() {
        int n = this.descriptorsSize;
        int n2 = -1;
        boolean bl = false;
        ResourceDescriptor resourceDescriptor = new ResourceDescriptor();
        resourceDescriptor.label = this.patternString.substring(0, this.patternString.length() - 1);
        while (n - n2 > 1) {
            int n3 = (n + n2) / 2;
            String string = this.descriptors[n3].label;
            if (this.match(string)) {
                n = n3;
                bl = true;
                continue;
            }
            int n4 = this.descriptors[n3].compareTo(resourceDescriptor);
            if (n4 == -1) {
                n2 = n3;
                continue;
            }
            n = n3;
        }
        if (bl) {
            return n;
        }
        return -1;
    }

    private void gatherResources(boolean bl) {
        int n;
        String string = bl ? null : this.patternString;
        this.patternString = this.adjustPattern();
        if (!bl && this.patternString.equals(string)) {
            return;
        }
        this.updateGatherThread.stop = true;
        this.updateGatherThread = new UpdateGatherThread();
        if (this.patternString.equals("")) {
            this.updateGatherThread.start();
            return;
        }
        this.stringMatcher = new StringMatcher(this.patternString, true, false);
        if (string != null && string.length() != 0 && string.endsWith("*") && this.patternString.endsWith("*") && this.patternString.regionMatches(0, string, 0, n = string.length() - 1)) {
            this.updateGatherThread.refilter = true;
            this.updateGatherThread.firstMatch = 0;
            this.updateGatherThread.lastMatch = this.descriptorsSize - 1;
            this.updateGatherThread.start();
            return;
        }
        final ArrayList arrayList = new ArrayList();
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                ResourceListSelectionDialog.this.getMatchingResources(arrayList);
                IResource[] iResourceArray = new IResource[arrayList.size()];
                arrayList.toArray(iResourceArray);
                ResourceListSelectionDialog.this.initDescriptors(iResourceArray);
            }
        });
        this.updateGatherThread.firstMatch = 0;
        this.updateGatherThread.lastMatch = this.descriptorsSize - 1;
        this.updateGatherThread.start();
    }

    private Image getImage(ResourceDescriptor resourceDescriptor) {
        IResource iResource = (IResource)resourceDescriptor.resources.get(0);
        return this.labelProvider.getImage((Object)iResource);
    }

    private int getLastMatch() {
        int n = this.descriptorsSize;
        int n2 = -1;
        boolean bl = false;
        ResourceDescriptor resourceDescriptor = new ResourceDescriptor();
        resourceDescriptor.label = this.patternString.substring(0, this.patternString.length() - 1);
        while (n - n2 > 1) {
            int n3 = (n + n2) / 2;
            String string = this.descriptors[n3].label;
            if (this.match(string)) {
                n2 = n3;
                bl = true;
                continue;
            }
            int n4 = this.descriptors[n3].compareTo(resourceDescriptor);
            if (n4 == -1) {
                n2 = n3;
                continue;
            }
            n = n3;
        }
        if (bl) {
            return n2;
        }
        return -1;
    }

    private void getMatchingResources(final ArrayList arrayList) {
        try {
            this.container.accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy iResourceProxy) {
                    if (!ResourceListSelectionDialog.this.getShowDerived() && iResourceProxy.isDerived()) {
                        return false;
                    }
                    int n = iResourceProxy.getType();
                    if ((ResourceListSelectionDialog.this.typeMask & n) != 0 && ResourceListSelectionDialog.this.match(iResourceProxy.getName())) {
                        IResource iResource = iResourceProxy.requestResource();
                        if (ResourceListSelectionDialog.this.select(iResource)) {
                            arrayList.add(iResource);
                            return true;
                        }
                        return false;
                    }
                    return n != 1;
                }
            }, 0);
        }
        catch (CoreException coreException) {}
    }

    private Image getParentImage(IResource iResource) {
        IContainer iContainer = iResource.getParent();
        return this.labelProvider.getImage((Object)iContainer);
    }

    private String getParentLabel(IResource iResource) {
        IContainer iContainer = iResource.getParent();
        String string = iContainer.getType() == 8 ? this.labelProvider.getText((Object)iContainer) : iContainer.getFullPath().makeRelative().toString();
        if (string == null) {
            return "";
        }
        return string;
    }

    protected boolean getShowDerived() {
        return this.showDerived;
    }

    protected void setShowDerived(boolean bl) {
        this.showDerived = bl;
    }

    private void initDescriptors(final IResource[] iResourceArray) {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                ResourceDescriptor resourceDescriptor;
                Object object;
                ResourceListSelectionDialog.this.descriptors = new ResourceDescriptor[iResourceArray.length];
                int n = 0;
                while (n < iResourceArray.length) {
                    object = iResourceArray[n];
                    resourceDescriptor = new ResourceDescriptor();
                    resourceDescriptor.label = object.getName();
                    resourceDescriptor.resources.add(object);
                    ResourceListSelectionDialog.this.descriptors[n] = resourceDescriptor;
                    ++n;
                }
                Arrays.sort(ResourceListSelectionDialog.this.descriptors);
                ResourceListSelectionDialog.this.descriptorsSize = ResourceListSelectionDialog.this.descriptors.length;
                n = 0;
                if (ResourceListSelectionDialog.this.descriptorsSize < 2) {
                    return;
                }
                object = ResourceListSelectionDialog.this.descriptors[n];
                resourceDescriptor = (IResource)object.resources.get(0);
                int n2 = 1;
                while (n2 < ResourceListSelectionDialog.this.descriptorsSize) {
                    ResourceDescriptor resourceDescriptor2 = ResourceListSelectionDialog.this.descriptors[n2];
                    IResource iResource = (IResource)resourceDescriptor2.resources.get(0);
                    if (iResource.getType() == resourceDescriptor.getType() && resourceDescriptor2.label.equals(object.label)) {
                        object.resources.add(iResource);
                        object.resourcesSorted = false;
                    } else {
                        if (object.resources.size() > 1) {
                            object.resourcesSorted = false;
                        }
                        ResourceListSelectionDialog.this.descriptors[n + 1] = ResourceListSelectionDialog.this.descriptors[n2];
                        object = ResourceListSelectionDialog.this.descriptors[++n];
                        resourceDescriptor = (IResource)object.resources.get(0);
                    }
                    ++n2;
                }
                ResourceListSelectionDialog.this.descriptorsSize = n + 1;
            }
        });
    }

    private boolean match(String string) {
        if (this.patternString == null || this.patternString.equals("") || this.patternString.equals("*")) {
            return true;
        }
        return this.stringMatcher.match(string);
    }

    protected void okPressed() {
        TableItem[] tableItemArray = this.folderNames.getSelection();
        if (tableItemArray.length == 1) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(tableItemArray[0].getData());
            this.setResult(arrayList);
        }
        super.okPressed();
    }

    protected boolean select(IResource iResource) {
        return true;
    }

    protected void refresh(boolean bl) {
        if (this.gatherResourcesDynamically) {
            this.gatherResources(bl);
        } else {
            this.filterResources(bl);
        }
    }

    private void updateFolders(final ResourceDescriptor resourceDescriptor) {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                if (!resourceDescriptor.resourcesSorted) {
                    Collections.sort(resourceDescriptor.resources, new Comparator(this){
                        final /* synthetic */ 17 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public int compare(Object object, Object object2) {
                            String string = ResourceListSelectionDialog.access$9(17.access$0(this.this$1), (IResource)object);
                            String string2 = ResourceListSelectionDialog.access$9(17.access$0(this.this$1), (IResource)object2);
                            return ResourceListSelectionDialog.access$0().compare(string, string2);
                        }
                    });
                    resourceDescriptor.resourcesSorted = true;
                }
                ResourceListSelectionDialog.this.folderNames.removeAll();
                int n = 0;
                while (n < resourceDescriptor.resources.size()) {
                    TableItem tableItem = new TableItem(ResourceListSelectionDialog.this.folderNames, 0);
                    IResource iResource = (IResource)resourceDescriptor.resources.get(n);
                    tableItem.setText(ResourceListSelectionDialog.this.getParentLabel(iResource));
                    tableItem.setImage(ResourceListSelectionDialog.this.getParentImage(iResource));
                    tableItem.setData((Object)iResource);
                    ++n;
                }
                ResourceListSelectionDialog.this.folderNames.setSelection(0);
            }

            static /* synthetic */ ResourceListSelectionDialog access$0(17 var0) {
                return var0.ResourceListSelectionDialog.this;
            }
        });
    }

    private void updateItem(int n, int n2, int n3) {
        ResourceDescriptor resourceDescriptor = this.descriptors[n];
        if (n2 < n3) {
            TableItem tableItem = this.resourceNames.getItem(n2);
            if (tableItem.getData() != resourceDescriptor) {
                tableItem.setText(resourceDescriptor.label);
                tableItem.setData((Object)resourceDescriptor);
                tableItem.setImage(this.getImage(resourceDescriptor));
                if (n2 == 0) {
                    this.resourceNames.setSelection(0);
                    this.updateFolders(resourceDescriptor);
                }
            }
        } else {
            TableItem tableItem = new TableItem(this.resourceNames, 0);
            tableItem.setText(resourceDescriptor.label);
            tableItem.setData((Object)resourceDescriptor);
            tableItem.setImage(this.getImage(resourceDescriptor));
            if (n2 == 0) {
                this.resourceNames.setSelection(0);
                this.updateFolders(resourceDescriptor);
            }
        }
        this.updateOKState(true);
    }

    protected void updateOKState(boolean bl) {
        Button button = this.getButton(0);
        if (button != null && !button.isDisposed() && bl != this.okEnabled) {
            button.setEnabled(bl);
            this.okEnabled = bl;
        }
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings iDialogSettings = IDEWorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(DIALOG_SETTINGS_SECTION);
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection(DIALOG_SETTINGS_SECTION);
        }
        return iDialogSettings2;
    }

    static /* synthetic */ void access$3(ResourceListSelectionDialog resourceListSelectionDialog, int n, int n2, int n3) {
        resourceListSelectionDialog.updateItem(n, n2, n3);
    }

    static class ResourceDescriptor
    implements Comparable {
        String label;
        ArrayList resources = new ArrayList();
        boolean resourcesSorted = true;

        ResourceDescriptor() {
        }

        public int compareTo(Object object) {
            return collator.compare(this.label, ((ResourceDescriptor)object).label);
        }
    }

    class UpdateFilterThread
    extends Thread {
        boolean stop = false;
        int firstMatch = 0;
        int lastMatch;

        UpdateFilterThread() {
            this.lastMatch = ResourceListSelectionDialog.this.descriptorsSize - 1;
        }

        public void run() {
            int n;
            Display display = ResourceListSelectionDialog.this.resourceNames.getDisplay();
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            boolean[] blArray = new boolean[1];
            display.syncExec(new Runnable(this, blArray, nArray2){
                final /* synthetic */ UpdateFilterThread this$1;
                private final /* synthetic */ boolean[] val$disposed;
                private final /* synthetic */ int[] val$itemCount;
                {
                    this.this$1 = updateFilterThread;
                    this.val$disposed = blArray;
                    this.val$itemCount = nArray;
                }

                public void run() {
                    if (UpdateFilterThread.access$0((UpdateFilterThread)this.this$1).resourceNames.isDisposed()) {
                        this.val$disposed[0] = true;
                        return;
                    }
                    this.val$itemCount[0] = UpdateFilterThread.access$0((UpdateFilterThread)this.this$1).resourceNames.getItemCount();
                }
            });
            if (blArray[0]) {
                return;
            }
            if (ResourceListSelectionDialog.this.patternString.indexOf(63) == -1 && ResourceListSelectionDialog.this.patternString.endsWith("*") && ResourceListSelectionDialog.this.patternString.indexOf(42) == ResourceListSelectionDialog.this.patternString.length() - 1) {
                this.firstMatch = ResourceListSelectionDialog.this.getFirstMatch();
                if (this.firstMatch == -1) {
                    this.firstMatch = 0;
                    this.lastMatch = -1;
                } else {
                    this.lastMatch = ResourceListSelectionDialog.this.getLastMatch();
                }
                n = this.lastMatch;
                int n2 = this.firstMatch;
                while (n2 <= this.lastMatch) {
                    if (n2 % 50 == 0) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (this.stop || ResourceListSelectionDialog.this.resourceNames.isDisposed()) {
                        blArray[0] = true;
                        return;
                    }
                    int n3 = n2++;
                    display.syncExec(new Runnable(this, n3, nArray, nArray2){
                        final /* synthetic */ UpdateFilterThread this$1;
                        private final /* synthetic */ int val$index;
                        private final /* synthetic */ int[] val$itemIndex;
                        private final /* synthetic */ int[] val$itemCount;
                        {
                            this.this$1 = updateFilterThread;
                            this.val$index = n;
                            this.val$itemIndex = nArray;
                            this.val$itemCount = nArray2;
                        }

                        public void run() {
                            if (this.this$1.stop || UpdateFilterThread.access$0((UpdateFilterThread)this.this$1).resourceNames.isDisposed()) {
                                return;
                            }
                            ResourceListSelectionDialog.access$3(UpdateFilterThread.access$0(this.this$1), this.val$index, this.val$itemIndex[0], this.val$itemCount[0]);
                            this.val$itemIndex[0] = this.val$itemIndex[0] + 1;
                        }
                    });
                }
            } else {
                n = this.lastMatch;
                boolean bl = true;
                int n4 = this.firstMatch;
                while (n4 <= this.lastMatch) {
                    if (n4 % 50 == 0) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (this.stop || ResourceListSelectionDialog.this.resourceNames.isDisposed()) {
                        blArray[0] = true;
                        return;
                    }
                    int n5 = n4;
                    if (ResourceListSelectionDialog.this.match(ResourceListSelectionDialog.this.descriptors[n5].label)) {
                        if (bl) {
                            bl = false;
                            this.firstMatch = n5;
                        }
                        n = n5;
                        display.syncExec(new Runnable(this, n5, nArray, nArray2){
                            final /* synthetic */ UpdateFilterThread this$1;
                            private final /* synthetic */ int val$index;
                            private final /* synthetic */ int[] val$itemIndex;
                            private final /* synthetic */ int[] val$itemCount;
                            {
                                this.this$1 = updateFilterThread;
                                this.val$index = n;
                                this.val$itemIndex = nArray;
                                this.val$itemCount = nArray2;
                            }

                            public void run() {
                                if (this.this$1.stop || UpdateFilterThread.access$0((UpdateFilterThread)this.this$1).resourceNames.isDisposed()) {
                                    return;
                                }
                                ResourceListSelectionDialog.access$3(UpdateFilterThread.access$0(this.this$1), this.val$index, this.val$itemIndex[0], this.val$itemCount[0]);
                                this.val$itemIndex[0] = this.val$itemIndex[0] + 1;
                            }
                        });
                    }
                    ++n4;
                }
            }
            if (blArray[0]) {
                return;
            }
            this.lastMatch = n;
            display.syncExec(new Runnable(this, nArray2, nArray){
                final /* synthetic */ UpdateFilterThread this$1;
                private final /* synthetic */ int[] val$itemCount;
                private final /* synthetic */ int[] val$itemIndex;
                {
                    this.this$1 = updateFilterThread;
                    this.val$itemCount = nArray;
                    this.val$itemIndex = nArray2;
                }

                public void run() {
                    if (UpdateFilterThread.access$0((UpdateFilterThread)this.this$1).resourceNames.isDisposed()) {
                        return;
                    }
                    this.val$itemCount[0] = UpdateFilterThread.access$0((UpdateFilterThread)this.this$1).resourceNames.getItemCount();
                    if (this.val$itemIndex[0] < this.val$itemCount[0]) {
                        UpdateFilterThread.access$0((UpdateFilterThread)this.this$1).resourceNames.setRedraw(false);
                        UpdateFilterThread.access$0((UpdateFilterThread)this.this$1).resourceNames.remove(this.val$itemIndex[0], this.val$itemCount[0] - 1);
                        UpdateFilterThread.access$0((UpdateFilterThread)this.this$1).resourceNames.setRedraw(true);
                    }
                    if (UpdateFilterThread.access$0((UpdateFilterThread)this.this$1).resourceNames.getItemCount() == 0) {
                        UpdateFilterThread.access$0((UpdateFilterThread)this.this$1).folderNames.removeAll();
                        UpdateFilterThread.access$0(this.this$1).updateOKState(false);
                    }
                }
            });
        }

        static /* synthetic */ ResourceListSelectionDialog access$0(UpdateFilterThread updateFilterThread) {
            return updateFilterThread.ResourceListSelectionDialog.this;
        }
    }

    class UpdateGatherThread
    extends Thread {
        boolean stop = false;
        int lastMatch = -1;
        int firstMatch = 0;
        boolean refilter = false;

        UpdateGatherThread() {
        }

        public void run() {
            Display display = ResourceListSelectionDialog.this.resourceNames.getDisplay();
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            boolean[] blArray = new boolean[1];
            display.syncExec(new Runnable(this, blArray, nArray2){
                final /* synthetic */ UpdateGatherThread this$1;
                private final /* synthetic */ boolean[] val$disposed;
                private final /* synthetic */ int[] val$itemCount;
                {
                    this.this$1 = updateGatherThread;
                    this.val$disposed = blArray;
                    this.val$itemCount = nArray;
                }

                public void run() {
                    if (UpdateGatherThread.access$0((UpdateGatherThread)this.this$1).resourceNames.isDisposed()) {
                        this.val$disposed[0] = true;
                        return;
                    }
                    this.val$itemCount[0] = UpdateGatherThread.access$0((UpdateGatherThread)this.this$1).resourceNames.getItemCount();
                }
            });
            if (blArray[0]) {
                return;
            }
            if (!this.refilter) {
                int n = 0;
                while (n <= this.lastMatch) {
                    if (n % 50 == 0) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (this.stop || ResourceListSelectionDialog.this.resourceNames.isDisposed()) {
                        blArray[0] = true;
                        return;
                    }
                    int n2 = n++;
                    display.syncExec(new Runnable(this, n2, nArray, nArray2){
                        final /* synthetic */ UpdateGatherThread this$1;
                        private final /* synthetic */ int val$index;
                        private final /* synthetic */ int[] val$itemIndex;
                        private final /* synthetic */ int[] val$itemCount;
                        {
                            this.this$1 = updateGatherThread;
                            this.val$index = n;
                            this.val$itemIndex = nArray;
                            this.val$itemCount = nArray2;
                        }

                        public void run() {
                            if (this.this$1.stop || UpdateGatherThread.access$0((UpdateGatherThread)this.this$1).resourceNames.isDisposed()) {
                                return;
                            }
                            ResourceListSelectionDialog.access$3(UpdateGatherThread.access$0(this.this$1), this.val$index, this.val$itemIndex[0], this.val$itemCount[0]);
                            this.val$itemIndex[0] = this.val$itemIndex[0] + 1;
                        }
                    });
                }
            } else {
                int n = this.firstMatch;
                while (n <= this.lastMatch) {
                    if (n % 50 == 0) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (this.stop || ResourceListSelectionDialog.this.resourceNames.isDisposed()) {
                        blArray[0] = true;
                        return;
                    }
                    int n3 = n;
                    if (ResourceListSelectionDialog.this.match(ResourceListSelectionDialog.this.descriptors[n3].label)) {
                        display.syncExec(new Runnable(this, n3, nArray, nArray2){
                            final /* synthetic */ UpdateGatherThread this$1;
                            private final /* synthetic */ int val$index;
                            private final /* synthetic */ int[] val$itemIndex;
                            private final /* synthetic */ int[] val$itemCount;
                            {
                                this.this$1 = updateGatherThread;
                                this.val$index = n;
                                this.val$itemIndex = nArray;
                                this.val$itemCount = nArray2;
                            }

                            public void run() {
                                if (this.this$1.stop || UpdateGatherThread.access$0((UpdateGatherThread)this.this$1).resourceNames.isDisposed()) {
                                    return;
                                }
                                ResourceListSelectionDialog.access$3(UpdateGatherThread.access$0(this.this$1), this.val$index, this.val$itemIndex[0], this.val$itemCount[0]);
                                this.val$itemIndex[0] = this.val$itemIndex[0] + 1;
                            }
                        });
                    }
                    ++n;
                }
            }
            if (blArray[0]) {
                return;
            }
            display.syncExec(new Runnable(this, nArray2, nArray){
                final /* synthetic */ UpdateGatherThread this$1;
                private final /* synthetic */ int[] val$itemCount;
                private final /* synthetic */ int[] val$itemIndex;
                {
                    this.this$1 = updateGatherThread;
                    this.val$itemCount = nArray;
                    this.val$itemIndex = nArray2;
                }

                public void run() {
                    if (UpdateGatherThread.access$0((UpdateGatherThread)this.this$1).resourceNames.isDisposed()) {
                        return;
                    }
                    this.val$itemCount[0] = UpdateGatherThread.access$0((UpdateGatherThread)this.this$1).resourceNames.getItemCount();
                    if (this.val$itemIndex[0] < this.val$itemCount[0]) {
                        UpdateGatherThread.access$0((UpdateGatherThread)this.this$1).resourceNames.setRedraw(false);
                        UpdateGatherThread.access$0((UpdateGatherThread)this.this$1).resourceNames.remove(this.val$itemIndex[0], this.val$itemCount[0] - 1);
                        UpdateGatherThread.access$0((UpdateGatherThread)this.this$1).resourceNames.setRedraw(true);
                    }
                    if (UpdateGatherThread.access$0((UpdateGatherThread)this.this$1).resourceNames.getItemCount() == 0) {
                        UpdateGatherThread.access$0((UpdateGatherThread)this.this$1).folderNames.removeAll();
                        UpdateGatherThread.access$0(this.this$1).updateOKState(false);
                    }
                }
            });
        }

        static /* synthetic */ ResourceListSelectionDialog access$0(UpdateGatherThread updateGatherThread) {
            return updateGatherThread.ResourceListSelectionDialog.this;
        }
    }
}

