/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.misc.CheckboxTreeAndListGroup;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ResourceSelectionDialog
extends SelectionDialog {
    private IAdaptable root;
    private CheckboxTreeAndListGroup selectionGroup;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 400;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 300;

    public ResourceSelectionDialog(Shell shell, IAdaptable iAdaptable, String string) {
        super(shell);
        this.setTitle(IDEWorkbenchMessages.ResourceSelectionDialog_title);
        this.root = iAdaptable;
        if (string != null) {
            this.setMessage(string);
        } else {
            this.setMessage(IDEWorkbenchMessages.ResourceSelectionDialog_message);
        }
    }

    private void checkInitialSelections() {
        Iterator iterator = this.getInitialElementSelections().iterator();
        while (iterator.hasNext()) {
            IResource iResource = (IResource)iterator.next();
            if (iResource.getType() == 1) {
                this.selectionGroup.initialCheckListItem(iResource);
                continue;
            }
            this.selectionGroup.initialCheckTreeItem(iResource);
        }
    }

    public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
        this.getOkButton().setEnabled(this.selectionGroup.getCheckedElementCount() > 0);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.ide.resource_selection_dialog_context");
    }

    public void create() {
        super.create();
        this.initializeDialog();
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        ArrayList<IAdaptable> arrayList = new ArrayList<IAdaptable>();
        arrayList.add(this.root);
        this.createMessageArea(composite2);
        this.selectionGroup = new CheckboxTreeAndListGroup(composite2, arrayList, this.getResourceProvider(14), WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider(), (IStructuredContentProvider)this.getResourceProvider(1), WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider(), 0, 400, 300);
        composite2.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent controlEvent) {
            }

            public void controlResized(ControlEvent controlEvent) {
                TableColumn[] tableColumnArray = ResourceSelectionDialog.this.selectionGroup.getListTable().getColumns();
                int n = 0;
                while (n < tableColumnArray.length) {
                    tableColumnArray[n].pack();
                    ++n;
                }
            }
        });
        return composite2;
    }

    private ITreeContentProvider getResourceProvider(final int n) {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object object) {
                if (object instanceof IContainer) {
                    IResource[] iResourceArray = null;
                    try {
                        iResourceArray = ((IContainer)object).members();
                    }
                    catch (CoreException coreException) {
                        return new Object[0];
                    }
                    ArrayList<IResource> arrayList = new ArrayList<IResource>();
                    int n2 = 0;
                    while (n2 < iResourceArray.length) {
                        if ((iResourceArray[n2].getType() & n) > 0) {
                            arrayList.add(iResourceArray[n2]);
                        }
                        ++n2;
                    }
                    return arrayList.toArray();
                }
                if (object instanceof ArrayList) {
                    return ((ArrayList)object).toArray();
                }
                return new Object[0];
            }
        };
    }

    private void initializeDialog() {
        this.selectionGroup.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                ResourceSelectionDialog.this.getOkButton().setEnabled(ResourceSelectionDialog.this.selectionGroup.getCheckedElementCount() > 0);
            }
        });
        if (this.getInitialElementSelections().isEmpty()) {
            this.getOkButton().setEnabled(false);
        } else {
            this.checkInitialSelections();
        }
    }

    protected void okPressed() {
        Iterator iterator = this.selectionGroup.getAllCheckedListItems();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        this.setResult(arrayList);
        super.okPressed();
    }
}

