/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public abstract class WizardDataTransferPage
extends WizardPage
implements Listener,
IOverwriteQuery {
    protected static final int SIZING_TEXT_FIELD_WIDTH = 250;
    protected static final int COMBO_HISTORY_LENGTH = 5;

    protected WizardDataTransferPage(String string) {
        super(string);
    }

    protected String[] addToHistory(String[] stringArray, String string) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        this.addToHistory(arrayList, string);
        String[] stringArray2 = new String[arrayList.size()];
        arrayList.toArray(stringArray2);
        return stringArray2;
    }

    protected void addToHistory(List list, String string) {
        list.remove(string);
        list.add(0, string);
        if (list.size() > 5) {
            list.remove(5);
        }
    }

    protected abstract boolean allowNewContainerName();

    protected Label createBoldLabel(Composite composite, String string) {
        Label label = new Label(composite, 0);
        label.setFont(JFaceResources.getBannerFont());
        label.setText(string);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        label.setLayoutData((Object)gridData);
        return label;
    }

    protected void createOptionsGroupButtons(Group group) {
    }

    protected Label createPlainLabel(Composite composite, String string) {
        Label label = new Label(composite, 0);
        label.setText(string);
        label.setFont(composite.getFont());
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        label.setLayoutData((Object)gridData);
        return label;
    }

    protected void createSpacer(Composite composite) {
        Label label = new Label(composite, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        label.setLayoutData((Object)gridData);
    }

    protected boolean determinePageCompletion() {
        boolean bl;
        boolean bl2 = bl = this.validateSourceGroup() && this.validateDestinationGroup() && this.validateOptionsGroup();
        if (bl) {
            this.setErrorMessage(null);
        }
        return bl;
    }

    protected IPath getPathFromText(Text text) {
        String string = text.getText();
        if (string.length() == 0) {
            return new Path(string);
        }
        return new Path(string).makeAbsolute();
    }

    protected IPath queryForContainer(IContainer iContainer, String string) {
        return this.queryForContainer(iContainer, string, null);
    }

    protected IPath queryForContainer(IContainer iContainer, String string, String string2) {
        ContainerSelectionDialog containerSelectionDialog = new ContainerSelectionDialog(this.getControl().getShell(), iContainer, this.allowNewContainerName(), string);
        if (string2 != null) {
            containerSelectionDialog.setTitle(string2);
        }
        containerSelectionDialog.showClosedProjects(false);
        containerSelectionDialog.open();
        Object[] objectArray = containerSelectionDialog.getResult();
        if (objectArray != null && objectArray.length == 1) {
            return (IPath)objectArray[0];
        }
        return null;
    }

    public String queryOverwrite(String string) {
        Path path = new Path(string);
        String string2 = path.getFileExtension() == null || path.segmentCount() < 2 ? NLS.bind((String)IDEWorkbenchMessages.WizardDataTransfer_existsQuestion, (Object)string) : NLS.bind((String)IDEWorkbenchMessages.WizardDataTransfer_overwriteNameAndPathQuestion, (Object)path.lastSegment(), (Object)path.removeLastSegments(1).toOSString());
        final MessageDialog messageDialog = new MessageDialog(this.getContainer().getShell(), IDEWorkbenchMessages.Question, null, string2, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        String[] stringArray = new String[]{"YES", "ALL", "NO", "NOALL", "CANCEL"};
        this.getControl().getDisplay().syncExec(new Runnable(){

            public void run() {
                messageDialog.open();
            }
        });
        return messageDialog.getReturnCode() < 0 ? "CANCEL" : stringArray[messageDialog.getReturnCode()];
    }

    protected boolean queryYesNoQuestion(String string) {
        MessageDialog messageDialog = new MessageDialog(this.getContainer().getShell(), IDEWorkbenchMessages.Question, null, string, 0, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        return messageDialog.open() == 0;
    }

    protected void restoreWidgetValues() {
    }

    protected void saveWidgetValues() {
    }

    protected void updatePageCompletion() {
        boolean bl = this.determinePageCompletion();
        this.setPageComplete(bl);
        if (bl) {
            this.setErrorMessage(null);
        }
    }

    protected void updateWidgetEnablements() {
    }

    protected boolean validateDestinationGroup() {
        return true;
    }

    protected boolean validateOptionsGroup() {
        return true;
    }

    protected boolean validateSourceGroup() {
        return true;
    }

    protected void createOptionsGroup(Composite composite) {
        Group group = new Group(composite, 0);
        GridLayout gridLayout = new GridLayout();
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(768));
        group.setText(IDEWorkbenchMessages.WizardExportPage_options);
        group.setFont(composite.getFont());
        this.createOptionsGroupButtons(group);
    }

    protected void displayErrorDialog(String string) {
        MessageDialog.openError((Shell)this.getContainer().getShell(), (String)this.getErrorDialogTitle(), (String)string);
    }

    protected void displayErrorDialog(Throwable throwable) {
        String string = throwable.getMessage();
        if (string == null) {
            string = NLS.bind((String)IDEWorkbenchMessages.WizardDataTransfer_exceptionMessage, (Object)throwable);
        }
        this.displayErrorDialog(string);
    }

    protected String getErrorDialogTitle() {
        return IDEWorkbenchMessages.WizardExportPage_internalErrorTitle;
    }
}

