/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FileEditorMappingContentProvider;
import org.eclipse.ui.dialogs.FileEditorMappingLabelProvider;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;
import org.eclipse.ui.dialogs.WizardDataTransferPage;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public abstract class WizardExportPage
extends WizardDataTransferPage {
    private IStructuredSelection currentResourceSelection;
    private List selectedResources;
    private List selectedTypes;
    private boolean exportCurrentSelection = false;
    private boolean exportAllResourcesPreSet = false;
    private Combo typesToExportField;
    private Button typesToExportEditButton;
    private Button exportAllTypesRadio;
    private Button exportSpecifiedTypesRadio;
    private Button resourceDetailsButton;
    private Label resourceDetailsDescription;
    private Text resourceNameField;
    private Button resourceBrowseButton;
    private boolean initialExportAllTypesValue = true;
    private String initialExportFieldValue;
    private String initialTypesFieldValue;
    private static final String CURRENT_SELECTION = "<current selection>";
    private static final String TYPE_DELIMITER = ",";
    private static final String STORE_SELECTED_TYPES_ID = "WizardFileSystemExportPage1.STORE_SELECTED_TYPES_ID.";
    private static final String STORE_EXPORT_ALL_RESOURCES_ID = "WizardFileSystemExportPage1.STORE_EXPORT_ALL_RESOURCES_ID.";

    protected WizardExportPage(String string, IStructuredSelection iStructuredSelection) {
        super(string);
        this.currentResourceSelection = iStructuredSelection;
    }

    protected boolean allowNewContainerName() {
        return false;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(272));
        this.createBoldLabel(composite2, IDEWorkbenchMessages.WizardExportPage_whatLabel);
        this.createSourceGroup(composite2);
        this.createSpacer(composite2);
        this.createBoldLabel(composite2, IDEWorkbenchMessages.WizardExportPage_whereLabel);
        this.createDestinationGroup(composite2);
        this.createSpacer(composite2);
        this.createBoldLabel(composite2, IDEWorkbenchMessages.WizardExportPage_options);
        this.createOptionsGroup(composite2);
        this.restoreResourceSpecificationWidgetValues();
        this.restoreWidgetValues();
        if (this.currentResourceSelection != null) {
            this.setupBasedOnInitialSelections();
        }
        this.updateWidgetEnablements();
        this.setPageComplete(this.determinePageCompletion());
        this.setControl((Control)composite2);
    }

    protected abstract void createDestinationGroup(Composite var1);

    protected final void createSourceGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(272));
        new Label(composite2, 0).setText(IDEWorkbenchMessages.WizardExportPage_folder);
        this.resourceNameField = new Text(composite2, 2052);
        this.resourceNameField.addListener(1, (Listener)this);
        GridData gridData = new GridData(768);
        gridData.widthHint = 250;
        this.resourceNameField.setLayoutData((Object)gridData);
        this.resourceBrowseButton = new Button(composite2, 8);
        this.resourceBrowseButton.setText(IDEWorkbenchMessages.WizardExportPage_browse);
        this.resourceBrowseButton.addListener(13, (Listener)this);
        this.resourceBrowseButton.setLayoutData((Object)new GridData(768));
        this.exportAllTypesRadio = new Button(composite2, 16);
        this.exportAllTypesRadio.setText(IDEWorkbenchMessages.WizardExportPage_allTypes);
        this.exportAllTypesRadio.addListener(13, (Listener)this);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.exportAllTypesRadio.setLayoutData((Object)gridData);
        this.exportSpecifiedTypesRadio = new Button(composite2, 16);
        this.exportSpecifiedTypesRadio.setText(IDEWorkbenchMessages.WizardExportPage_specificTypes);
        this.exportSpecifiedTypesRadio.addListener(13, (Listener)this);
        this.typesToExportField = new Combo(composite2, 0);
        gridData = new GridData(768);
        gridData.widthHint = 250;
        this.typesToExportField.setLayoutData((Object)gridData);
        this.typesToExportField.addListener(24, (Listener)this);
        this.typesToExportEditButton = new Button(composite2, 8);
        this.typesToExportEditButton.setText(IDEWorkbenchMessages.WizardExportPage_edit);
        this.typesToExportEditButton.setLayoutData((Object)new GridData(776));
        this.typesToExportEditButton.addListener(13, (Listener)this);
        this.resourceDetailsButton = new Button(composite2, 8);
        this.resourceDetailsButton.setText(IDEWorkbenchMessages.WizardExportPage_details);
        this.resourceDetailsButton.addListener(13, (Listener)this);
        this.resourceDetailsDescription = new Label(composite2, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.resourceDetailsDescription.setLayoutData((Object)gridData);
        this.resetSelectedResources();
        this.exportAllTypesRadio.setSelection(this.initialExportAllTypesValue);
        this.exportSpecifiedTypesRadio.setSelection(!this.initialExportAllTypesValue);
        this.typesToExportField.setEnabled(!this.initialExportAllTypesValue);
        this.typesToExportEditButton.setEnabled(!this.initialExportAllTypesValue);
        if (this.initialExportFieldValue != null) {
            this.resourceNameField.setText(this.initialExportFieldValue);
        }
        if (this.initialTypesFieldValue != null) {
            this.typesToExportField.setText(this.initialTypesFieldValue);
        }
    }

    protected void displayErrorDialog(String string) {
        MessageDialog.openError((Shell)this.getContainer().getShell(), (String)IDEWorkbenchMessages.WizardExportPage_errorDialogTitle, (String)string);
    }

    protected void displayResourcesSelectedCount(int n) {
        if (n == 1) {
            this.resourceDetailsDescription.setText(IDEWorkbenchMessages.WizardExportPage_oneResourceSelected);
        } else {
            this.resourceDetailsDescription.setText(NLS.bind((String)IDEWorkbenchMessages.WizardExportPage_resourceCountMessage, (Object)new Integer(n)));
        }
    }

    protected boolean ensureResourcesLocal(List list) {
        return true;
    }

    protected List extractNonLocalResources(List list) {
        Vector<IResource> vector = new Vector<IResource>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IResource iResource = (IResource)iterator.next();
            if (iResource.isLocal(0)) continue;
            vector.addElement(iResource);
        }
        return vector;
    }

    public boolean getExportAllTypesValue() {
        if (this.exportAllTypesRadio == null) {
            return this.initialExportAllTypesValue;
        }
        return this.exportAllTypesRadio.getSelection();
    }

    public String getResourceFieldValue() {
        if (this.resourceNameField == null) {
            return this.initialExportFieldValue;
        }
        return this.resourceNameField.getText();
    }

    protected IPath getResourcePath() {
        return this.getPathFromText(this.resourceNameField);
    }

    protected List getSelectedResources() {
        IResource iResource;
        if (this.selectedResources == null && (iResource = this.getSourceResource()) != null) {
            this.selectAppropriateResources(iResource);
        }
        return this.selectedResources;
    }

    protected IResource getSourceResource() {
        IPath iPath;
        IWorkspace iWorkspace = IDEWorkbenchPlugin.getPluginWorkspace();
        IStatus iStatus = iWorkspace.validatePath((iPath = this.getResourcePath()).toString(), 15);
        if (iStatus.isOK() && iWorkspace.getRoot().exists(iPath)) {
            return iWorkspace.getRoot().findMember(iPath);
        }
        return null;
    }

    public String getTypesFieldValue() {
        if (this.typesToExportField == null) {
            return this.initialTypesFieldValue;
        }
        return this.typesToExportField.getText();
    }

    protected List getTypesToExport() {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.typesToExportField.getText(), TYPE_DELIMITER);
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken().trim();
            if (string.equals("")) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public void handleEvent(Event event) {
        Widget widget = event.widget;
        if (widget == this.exportAllTypesRadio || widget == this.typesToExportField || widget == this.resourceNameField) {
            this.resetSelectedResources();
        } else if (widget == this.exportSpecifiedTypesRadio) {
            this.resetSelectedResources();
            this.typesToExportField.setFocus();
        } else if (widget == this.resourceDetailsButton) {
            this.handleResourceDetailsButtonPressed();
        } else if (widget == this.resourceBrowseButton) {
            this.handleResourceBrowseButtonPressed();
        } else if (widget == this.typesToExportEditButton) {
            this.handleTypesEditButtonPressed();
        }
        this.setPageComplete(this.determinePageCompletion());
        this.updateWidgetEnablements();
    }

    protected void handleResourceBrowseButtonPressed() {
        String string;
        IPath iPath;
        IResource iResource = this.getSourceResource();
        if (iResource != null && iResource.getType() == 1) {
            iResource = iResource.getParent();
        }
        if ((iPath = this.queryForContainer((IContainer)iResource, IDEWorkbenchMessages.WizardExportPage_selectResourcesToExport)) != null && !(string = iPath.makeRelative().toString()).toString().equals(this.resourceNameField.getText())) {
            this.resetSelectedResources();
            this.resourceNameField.setText(string);
        }
    }

    protected void handleResourceDetailsButtonPressed() {
        Object[] objectArray;
        IResource iResource = this.getSourceResource();
        if (iResource == null) {
            iResource = ResourcesPlugin.getWorkspace().getRoot();
        }
        this.selectAppropriateResources(iResource);
        if (iResource instanceof IFile) {
            iResource = ((IFile)iResource).getParent();
            this.setResourceToDisplay(iResource);
        }
        if ((objectArray = this.queryIndividualResourcesToExport((IAdaptable)iResource)) != null) {
            this.selectedResources = Arrays.asList(objectArray);
            this.displayResourcesSelectedCount(this.selectedResources.size());
        }
    }

    protected void handleTypesEditButtonPressed() {
        Object[] objectArray = this.queryResourceTypesToExport();
        if (objectArray != null) {
            ArrayList<String> arrayList = new ArrayList<String>(objectArray.length);
            int n = 0;
            while (n < objectArray.length) {
                arrayList.add(((IFileEditorMapping)objectArray[n]).getExtension());
                ++n;
            }
            this.setTypesToExport(arrayList);
        }
    }

    protected boolean hasExportableExtension(String string) {
        if (this.selectedTypes == null) {
            return true;
        }
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return false;
        }
        String string2 = string.substring(n + 1);
        Iterator iterator = this.selectedTypes.iterator();
        while (iterator.hasNext()) {
            if (!string2.equalsIgnoreCase((String)iterator.next())) continue;
            return true;
        }
        return false;
    }

    protected void internalSaveWidgetValues() {
    }

    protected Object[] queryIndividualResourcesToExport(IAdaptable iAdaptable) {
        ResourceSelectionDialog resourceSelectionDialog = new ResourceSelectionDialog(this.getContainer().getShell(), iAdaptable, IDEWorkbenchMessages.WizardExportPage_selectResourcesTitle);
        resourceSelectionDialog.setInitialSelections(this.selectedResources.toArray(new Object[this.selectedResources.size()]));
        resourceSelectionDialog.open();
        return resourceSelectionDialog.getResult();
    }

    protected Object[] queryResourceTypesToExport() {
        IFileEditorMapping[] iFileEditorMappingArray = PlatformUI.getWorkbench().getEditorRegistry().getFileEditorMappings();
        int n = iFileEditorMappingArray.length;
        List list = this.getTypesToExport();
        ArrayList<IFileEditorMapping> arrayList = new ArrayList<IFileEditorMapping>(list.size());
        int n2 = 0;
        while (n2 < n) {
            IFileEditorMapping iFileEditorMapping = iFileEditorMappingArray[n2];
            if (list.contains(iFileEditorMapping.getExtension())) {
                arrayList.add(iFileEditorMapping);
            }
            ++n2;
        }
        ListSelectionDialog listSelectionDialog = new ListSelectionDialog(this.getContainer().getShell(), (Object)iFileEditorMappingArray, (IStructuredContentProvider)FileEditorMappingContentProvider.INSTANCE, (ILabelProvider)FileEditorMappingLabelProvider.INSTANCE, IDEWorkbenchMessages.WizardExportPage_selectionDialogMessage);
        listSelectionDialog.setTitle(IDEWorkbenchMessages.WizardExportPage_resourceTypeDialog);
        listSelectionDialog.open();
        return listSelectionDialog.getResult();
    }

    protected void resetSelectedResources() {
        this.resourceDetailsDescription.setText(IDEWorkbenchMessages.WizardExportPage_detailsMessage);
        this.selectedResources = null;
        if (this.exportCurrentSelection) {
            this.exportCurrentSelection = false;
            if (this.resourceNameField.getText().length() > CURRENT_SELECTION.length()) {
                this.resourceNameField.setText(this.resourceNameField.getText().substring(CURRENT_SELECTION.length()));
            } else {
                this.resourceNameField.setText("");
            }
        }
    }

    protected void restoreResourceSpecificationWidgetValues() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        if (iDialogSettings != null) {
            String[] stringArray;
            String string = this.getName();
            boolean bl = iDialogSettings.getBoolean(STORE_EXPORT_ALL_RESOURCES_ID + string);
            if (!this.exportAllResourcesPreSet) {
                this.exportAllTypesRadio.setSelection(bl);
                this.exportSpecifiedTypesRadio.setSelection(!bl);
            }
            if (this.initialTypesFieldValue == null && (stringArray = iDialogSettings.getArray(STORE_SELECTED_TYPES_ID + string)) != null) {
                if (stringArray.length > 0) {
                    this.typesToExportField.setText(stringArray[0]);
                }
                int n = 0;
                while (n < stringArray.length) {
                    this.typesToExportField.add(stringArray[n]);
                    ++n;
                }
            }
        }
    }

    protected void saveWidgetValues() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        if (iDialogSettings != null) {
            String string = this.getName();
            String[] stringArray = iDialogSettings.getArray(STORE_SELECTED_TYPES_ID + string);
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            if (this.exportSpecifiedTypesRadio.getSelection()) {
                stringArray = this.addToHistory(stringArray, this.typesToExportField.getText());
            }
            iDialogSettings.put(STORE_SELECTED_TYPES_ID + string, stringArray);
            iDialogSettings.put(STORE_EXPORT_ALL_RESOURCES_ID + string, this.exportAllTypesRadio.getSelection());
        }
        this.internalSaveWidgetValues();
    }

    protected void selectAppropriateFolderContents(IContainer iContainer) {
        try {
            IResource[] iResourceArray = iContainer.members();
            int n = 0;
            while (n < iResourceArray.length) {
                IFile iFile;
                if (iResourceArray[n].getType() == 1 && this.hasExportableExtension((iFile = (IFile)iResourceArray[n]).getFullPath().toString())) {
                    this.selectedResources.add(iFile);
                }
                if (iResourceArray[n].getType() == 2) {
                    this.selectAppropriateFolderContents((IContainer)iResourceArray[n]);
                }
                ++n;
            }
        }
        catch (CoreException coreException) {}
    }

    protected void selectAppropriateResources(Object object) {
        if (this.selectedResources == null) {
            this.selectedTypes = this.exportSpecifiedTypesRadio.getSelection() ? this.getTypesToExport() : null;
            this.selectedResources = new ArrayList();
            if (object instanceof IWorkspaceRoot) {
                IProject[] iProjectArray = ((IWorkspaceRoot)object).getProjects();
                int n = 0;
                while (n < iProjectArray.length) {
                    this.selectAppropriateFolderContents((IContainer)iProjectArray[n]);
                    ++n;
                }
            } else if (object instanceof IFile) {
                IFile iFile = (IFile)object;
                if (this.hasExportableExtension(iFile.getFullPath().toString())) {
                    this.selectedResources.add(iFile);
                }
            } else {
                this.selectAppropriateFolderContents((IContainer)object);
            }
        }
    }

    public void setExportAllTypesValue(boolean bl) {
        if (this.exportAllTypesRadio == null) {
            this.initialExportAllTypesValue = bl;
            this.exportAllResourcesPreSet = true;
        } else {
            this.exportAllTypesRadio.setSelection(bl);
            this.exportSpecifiedTypesRadio.setSelection(!bl);
        }
    }

    public void setResourceFieldValue(String string) {
        if (this.resourceNameField == null) {
            this.initialExportFieldValue = string;
        } else {
            this.resourceNameField.setText(string);
        }
    }

    protected void setResourceToDisplay(IResource iResource) {
        this.setResourceFieldValue(iResource.getFullPath().makeRelative().toString());
    }

    public void setTypesFieldValue(String string) {
        if (this.typesToExportField == null) {
            this.initialTypesFieldValue = string;
        } else {
            this.typesToExportField.setText(string);
        }
    }

    protected void setTypesToExport(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            stringBuffer.append(TYPE_DELIMITER);
            stringBuffer.append(" ");
        }
        this.typesToExportField.setText(stringBuffer.toString());
    }

    protected void setupBasedOnInitialSelections() {
        Object object;
        if (this.initialExportFieldValue != null) {
            object = this.getSourceResource();
            this.currentResourceSelection = object == null ? new StructuredSelection() : new StructuredSelection(object);
        }
        if (this.currentResourceSelection.isEmpty()) {
            return;
        }
        object = new ArrayList();
        Iterator iterator = this.currentResourceSelection.iterator();
        while (iterator.hasNext()) {
            IResource iResource = (IResource)iterator.next();
            if (!iResource.isAccessible()) continue;
            object.add(iResource);
        }
        if (object.isEmpty()) {
            return;
        }
        int n = object.size();
        if (n == 1) {
            IResource iResource = (IResource)object.get(0);
            this.setResourceToDisplay(iResource);
        } else {
            this.selectedResources = object;
            this.exportAllTypesRadio.setSelection(true);
            this.exportSpecifiedTypesRadio.setSelection(false);
            this.resourceNameField.setText(CURRENT_SELECTION);
            this.exportCurrentSelection = true;
            this.displayResourcesSelectedCount(n);
        }
    }

    protected void updateWidgetEnablements() {
        if (this.exportCurrentSelection) {
            this.resourceDetailsButton.setEnabled(true);
        } else {
            IResource iResource = this.getSourceResource();
            this.resourceDetailsButton.setEnabled(iResource != null && iResource.isAccessible());
        }
        this.exportSpecifiedTypesRadio.setEnabled(!this.exportCurrentSelection);
        this.typesToExportField.setEnabled(this.exportSpecifiedTypesRadio.getSelection());
        this.typesToExportEditButton.setEnabled(this.exportSpecifiedTypesRadio.getSelection());
    }

    protected final boolean validateSourceGroup() {
        if (this.exportCurrentSelection) {
            return true;
        }
        String string = this.resourceNameField.getText();
        if (string.equals("")) {
            this.setErrorMessage(null);
            return false;
        }
        IResource iResource = this.getSourceResource();
        if (iResource == null) {
            this.setErrorMessage(IDEWorkbenchMessages.WizardExportPage_mustExistMessage);
            return false;
        }
        if (!iResource.isAccessible()) {
            this.setErrorMessage(IDEWorkbenchMessages.WizardExportPage_mustBeAccessibleMessage);
            return false;
        }
        return true;
    }
}

